/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid;

import com.github.mim1q.minecells.structure.MineCellsStructures;
import com.github.mim1q.minecells.structure.grid.GridPiece;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.structure.grid.generator.BetterPromenadeGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.BlackBridgeGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.PrisonGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.PromenadeWallGenerator;
import com.github.mim1q.minecells.structure.grid.generator.RampartsGridGenerator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_7151;

public class GridBasedStructure
extends class_3195 {
    public static final MapCodec<GridBasedStructure> PRISON_CODEC = GridBasedStructure.createMultipartGridBasedStructureCodec(PrisonGridGenerator::new, () -> MineCellsStructures.PRISON);
    public static final MapCodec<GridBasedStructure> PROMENADE_CODEC = GridBasedStructure.createMultipartGridBasedStructureCodec(BetterPromenadeGridGenerator::new, () -> MineCellsStructures.PROMENADE);
    public static final MapCodec<GridBasedStructure> PROMENADE_WALL_X_CODEC = GridBasedStructure.createGridBasedStructureCodec(ctx -> new PromenadeWallGenerator(false), () -> MineCellsStructures.PROMENADE_WALL_X, ctx -> class_3532.method_15382((int)class_3532.method_15387((int)ctx.comp_568().field_9180, (int)64)) == 32 && class_3532.method_15387((int)ctx.comp_568().field_9181, (int)16) == 0);
    public static final MapCodec<GridBasedStructure> PROMENADE_WALL_Z_CODEC = GridBasedStructure.createGridBasedStructureCodec(ctx -> new PromenadeWallGenerator(true), () -> MineCellsStructures.PROMENADE_WALL_Z, ctx -> class_3532.method_15382((int)class_3532.method_15387((int)ctx.comp_568().field_9181, (int)64)) == 32 && class_3532.method_15387((int)ctx.comp_568().field_9180, (int)16) == 0);
    public static final MapCodec<GridBasedStructure> RAMPARTS_CODEC = GridBasedStructure.createMultipartGridBasedStructureCodec(RampartsGridGenerator::new, () -> MineCellsStructures.RAMPARTS);
    public static final MapCodec<GridBasedStructure> BLACK_BRIDGE_CODEC = GridBasedStructure.createMultipartGridBasedStructureCodec(BlackBridgeGridGenerator::new, () -> MineCellsStructures.BLACK_BRIDGE);
    private final Function<class_3195.class_7149, GridPiecesGenerator.RoomGridGenerator> generatorProvider;
    private List<GridPiece> pieces = new ArrayList<GridPiece>();
    private final class_6122 heightProvider;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final Supplier<class_7151<?>> typeSupplier;
    private final Predicate<class_3195.class_7149> spawnPredicate;

    public static MapCodec<GridBasedStructure> createGridBasedStructureCodec(Function<class_3195.class_7149, GridPiecesGenerator.RoomGridGenerator> generatorProvider, Supplier<class_7151<?>> typeSupplier) {
        return GridBasedStructure.createGridBasedStructureCodec(generatorProvider, typeSupplier, ctx -> true);
    }

    public static MapCodec<GridBasedStructure> createGridBasedStructureCodec(Function<class_3195.class_7149, GridPiecesGenerator.RoomGridGenerator> generatorProvider, Supplier<class_7151<?>> typeSupplier, Predicate<class_3195.class_7149> spawnPredicate) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3195.method_42697((RecordCodecBuilder.Instance)instance), (App)class_6122.field_31540.fieldOf("start_height").forGetter(GridBasedStructure::getHeightProvider), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(GridBasedStructure::getProjectStartToHeightmap)).apply((Applicative)instance, (arg_0, arg_1, arg_2) -> GridBasedStructure.lambda$createGridBasedStructureCodec$11(generatorProvider, (Supplier)typeSupplier, spawnPredicate, arg_0, arg_1, arg_2)));
    }

    public static MapCodec<GridBasedStructure> createMultipartGridBasedStructureCodec(BiFunction<Integer, Integer, GridPiecesGenerator.RoomGridGenerator> generatorProvider, Supplier<class_7151<?>> typeSupplier) {
        return GridBasedStructure.createMultipartGridBasedStructureCodec(generatorProvider, typeSupplier, -32, -32, 4, 4);
    }

    public static MapCodec<GridBasedStructure> createMultipartGridBasedStructureCodec(BiFunction<Integer, Integer, GridPiecesGenerator.RoomGridGenerator> generatorProvider, Supplier<class_7151<?>> typeSupplier, int startX, int startZ, int sizeX, int sizeZ) {
        return GridBasedStructure.createGridBasedStructureCodec(ctx -> {
            int x = class_3532.method_15387((int)(ctx.comp_568().field_9181 - startX - 8), (int)64) / 16;
            int z = class_3532.method_15387((int)(ctx.comp_568().field_9180 - startZ - 8), (int)64) / 16;
            return (GridPiecesGenerator.RoomGridGenerator)generatorProvider.apply(x, z);
        }, typeSupplier, ctx -> {
            int x = class_3532.method_15387((int)(ctx.comp_568().field_9181 - startX - 8), (int)64);
            int z = class_3532.method_15387((int)(ctx.comp_568().field_9180 - startZ - 8), (int)64);
            return x % 16 == 0 && z % 16 == 0 && x / 16 < sizeX && z / 16 < sizeZ;
        });
    }

    protected GridBasedStructure(class_3195.class_7302 config, class_6122 heightProvider, Optional<class_2902.class_2903> projectStartToHeightmap, Function<class_3195.class_7149, GridPiecesGenerator.RoomGridGenerator> generatorProvider, Supplier<class_7151<?>> typeSupplier, Predicate<class_3195.class_7149> spawnPredicate) {
        super(config);
        this.generatorProvider = generatorProvider;
        this.heightProvider = heightProvider;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.typeSupplier = typeSupplier;
        this.spawnPredicate = spawnPredicate;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!this.canSpawn(context)) {
            return Optional.empty();
        }
        class_1923 chunkPos = context.comp_568();
        int x = chunkPos.field_9181 * 16;
        int z = chunkPos.field_9180 * 16;
        int y = this.heightProvider.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        int heightmapY = this.projectStartToHeightmap.map(type -> y + context.comp_562().method_20402(x + 8, z + 8, type, context.comp_569(), context.comp_564())).orElse(0);
        class_2338 blockPos = new class_2338(x, y + heightmapY, z);
        GridPiecesGenerator.RoomGridGenerator generator = this.getGenerator(context);
        this.pieces = GridPiecesGenerator.generatePieces(blockPos, this.projectStartToHeightmap, context, 16, generator);
        return Optional.of(new class_3195.class_7150(blockPos, collector -> {
            for (GridPiece piece : this.pieces) {
                collector.method_35462((class_3443)piece);
            }
        }));
    }

    public class_7151<?> method_41618() {
        return this.typeSupplier.get();
    }

    protected boolean canSpawn(class_3195.class_7149 context) {
        return this.spawnPredicate.test(context);
    }

    protected GridPiecesGenerator.RoomGridGenerator getGenerator(class_3195.class_7149 context) {
        return this.generatorProvider.apply(context);
    }

    public class_6122 getHeightProvider() {
        return this.heightProvider;
    }

    public Optional<class_2902.class_2903> getProjectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    private static /* synthetic */ GridBasedStructure lambda$createGridBasedStructureCodec$11(Function generatorProvider, Supplier typeSupplier, Predicate spawnPredicate, class_3195.class_7302 config, class_6122 heightProvider, Optional projectStartToHeightmap) {
        return new GridBasedStructure(config, heightProvider, projectStartToHeightmap, generatorProvider, typeSupplier, spawnPredicate);
    }
}

