/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.mixin.entity;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.accessor.FallResetEntity;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.item.MineCellsItemTags;
import com.github.mim1q.minecells.structure.grid.GridBasedStructureUtils;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.structure.grid.SpecialPointIds;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityFallResetMixin
implements FallResetEntity {
    @Shadow
    public float field_6017;
    @Shadow
    public int field_6012;
    @Unique
    private Double fallResetY = 0.0;
    @Unique
    private class_2338 dimensionTpPos = class_2338.field_10980;

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract class_2338 method_24515();

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract void method_18799(class_243 var1);

    @Shadow
    public abstract class_1299<?> method_5864();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract float method_5705(float var1);

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract void method_31472();

    @Shadow
    public abstract boolean method_31747();

    @Shadow
    public abstract class_2561 method_5477();

    @Shadow
    public abstract void method_29239();

    @Shadow
    public abstract class_243 method_19538();

    @Shadow
    public abstract void method_33567(double var1, double var3, double var5);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void minecells$injectInit(class_1299<?> type, class_1937 world, CallbackInfo ci) {
        this.fallResetY = MineCellsDimension.getFallResetHeight(world);
        this.dimensionTpPos = this.method_24515();
    }

    @Inject(method={"setWorld"}, at={@At(value="HEAD")})
    private void minecells$injectMoveToWorld(class_1937 world, CallbackInfo ci) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (world != this.method_37908()) {
                this.minecells$initDimensionChange((class_1297)this, serverWorld);
            }
        }
    }

    @Override
    public void minecells$initDimensionChange(class_1297 result, class_3218 destination) {
        ((EntityFallResetMixin)result).fallResetY = MineCellsDimension.getFallResetHeight((class_1937)destination);
        ((EntityFallResetMixin)result).dimensionTpPos = result.method_24515();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void minecells$injectTick(CallbackInfo ci) {
        class_1657 player;
        class_1297 class_12972;
        if (this.method_37908().field_9236 || MineCells.COMMON_CONFIG.disableFallProtection() || this.field_6012 < 10 || this.field_6012 % 2 == 0 || this.fallResetY == null || Math.abs((double)this.dimensionTpPos.method_10263() - this.method_23317()) < 4.0 && Math.abs((double)this.dimensionTpPos.method_10260() - this.method_23321()) < 4.0 || (class_12972 = (class_1297)this) instanceof class_1657 && ((player = (class_1657)class_12972).method_7337() || player.method_7325())) {
            return;
        }
        if (this.method_23318() < this.fallResetY) {
            if (this.method_5864() == class_1299.field_6052) {
                if (this.field_6012 % 20 != 0) {
                    return;
                }
                if (((class_1542)this).method_6983().method_31573(MineCellsItemTags.DISCARD_IN_HIGH_DIMENSIONS)) {
                    this.method_31472();
                    return;
                }
                class_1657 nearestPlayer = this.method_37908().method_18459(this.method_23317(), this.method_23318(), this.method_23321(), 180.0, false);
                if (nearestPlayer == null) {
                    return;
                }
                this.method_33567(nearestPlayer.method_23317(), nearestPlayer.method_23318(), nearestPlayer.method_23321());
                this.method_18799(class_243.field_1353);
                this.field_6017 = 0.0f;
                return;
            }
            if ((class_1297)this instanceof class_1588) {
                this.method_5643(this.method_37908().method_48963().method_48827(), 100.0f);
                return;
            }
            class_2338 tpPos = this.minecells$getResetToPos();
            this.method_29239();
            if (this.method_31747()) {
                MineCells.LOGGER.info("Fall protection mechanic triggered for Player {} at {} from {} in dimension {}", (Object)this.method_5477().getString(), (Object)tpPos.method_23854(), (Object)this.method_24515().method_23854(), (Object)this.method_37908().method_27983().method_29177());
                this.minecells$grantAdvancementCriterion();
            }
            this.method_33567((double)tpPos.method_10263() + 0.5, (double)tpPos.method_10264() + 0.5, (double)tpPos.method_10260() + 0.5);
            this.method_18799(class_243.field_1353);
            this.field_6017 = 0.0f;
            this.method_5643(this.method_37908().method_48963().method_48827(), 5.0f);
        }
    }

    @Unique
    private void minecells$grantAdvancementCriterion() {
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            return;
        }
        class_8779 advancement = server.method_3851().method_12896(MineCells.createId("unlock/fall_from_the_ramparts"));
        if (advancement == null) {
            return;
        }
        class_2985 tracker = ((class_3222)this).method_14236();
        tracker.method_12878(advancement, "teleported_up");
    }

    @Unique
    private class_2338 minecells$getResetToPos() {
        class_3218 serverWorld = (class_3218)this.method_37908();
        MineCellsDimension dimension = MineCellsDimension.of(this.method_37908());
        class_2382 pos = MathUtils.getClosestMultiplePosition((class_2382)this.method_24515(), 1024);
        List<GridPiecesGenerator.RoomGridGenerator.SpecialPoint> specialPoints = GridBasedStructureUtils.getSpecialPoints(serverWorld, pos, dimension.baseGenerator);
        Optional<class_2338> point = specialPoints.stream().filter(it -> it.id().equals((Object)SpecialPointIds.CHECKPOINT)).map(it -> {
            class_2338 result = new class_2338(it.offset().method_35853(pos));
            result = new class_2338(result.method_10263(), this.method_37908().method_8624(class_2902.class_2903.field_13197, result.method_10263(), result.method_10260()), result.method_10260());
            return result;
        }).filter(it -> (double)it.method_10260() < this.method_23321() && this.method_37908().method_8320(it.method_10074()).method_26206((class_1922)this.method_37908(), it.method_10074(), class_2350.field_11036)).min(Comparator.comparingDouble(it -> it.method_19770((class_2374)this.method_19538())));
        return point.orElse(class_2338.method_49638((class_2374)((class_2374)dimension.getNonOverworldTeleportPosition(this.method_24515(), serverWorld, SpecialPointIds.ENTRANCE).method_15442())));
    }
}

