/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.shield;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.item.weapon.shield.CustomShieldItem;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import dev.mim1q.gimm1q.valuecalculators.ValueCalculator;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public class CustomShieldType {
    public static final CustomShieldType DEFAULT = new CustomShieldType("default", it -> {});
    public static final CustomShieldType CUDGEL = new CustomShieldType("cudgel", it -> {
        it.onMeleeParry = context -> context.attacker.method_6092(new class_1293(MineCellsStatusEffects.STUNNED, 30, 0, false, false, true));
        it.onMeleeBlock = context -> context.attacker.method_6092(new class_1293(MineCellsStatusEffects.STUNNED, 5, 0, false, false, true));
    });
    public static final CustomShieldType RAMPART = new CustomShieldType("rampart", it -> {
        it.blockAngle = 100.0f;
        it.onMeleeParry = context -> context.player().method_6092(new class_1293(MineCellsStatusEffects.PROTECTED, 30, 0, false, false, true));
    });
    public static final CustomShieldType ASSAULT = new CustomShieldType("assault", it -> {
        it.parryAngle = 360.0f;
        it.onUse = arg_0 -> CustomShieldType.lambda$static$6(it, arg_0);
        it.onHold = context -> {
            class_1657 user = context.player();
            if (context.useTicks() < 10) {
                class_238 box = user.method_5829().method_1014(1.0);
                List entities = user.method_5770().method_8333((class_1297)user, box, entity -> entity instanceof class_1309);
                entities.forEach(entity -> {
                    ((class_1309)entity).method_6005(0.5, entity.method_23317() - user.method_23317(), entity.method_23321() - user.method_23321());
                    entity.method_5643(user.method_37908().method_48963().method_48802(user), 8.0f);
                });
            }
        };
    });
    public static final CustomShieldType BLOOD = new CustomShieldType("blood", it -> {
        it.onParry = context -> CustomShieldType.applyBleedingAround(context.player(), context.player().method_19538());
        it.onMeleeParry = context -> {
            CustomShieldType.applyBleedingAround(context.player(), context.attacker.method_19538());
            context.attacker.method_6092(new class_1293(MineCellsStatusEffects.BLEEDING, 100, 2, false, false, true));
        };
    });
    public static final CustomShieldType ICE = new CustomShieldType("ice", it -> {
        it.onMeleeParry = context -> context.attacker.method_6092(new class_1293(MineCellsStatusEffects.FROZEN, 100, 0, false, false, true));
        it.onMeleeBlock = context -> context.attacker.method_6092(new class_1293(class_1294.field_5909, 30, 0, false, false, true));
        it.particle = class_2398.field_28013;
    });
    public static final CustomShieldType GREED = new CustomShieldType("greed", it -> {
        it.onMeleeParry = context -> {
            class_3218 serverWorld = (class_3218)context.player().method_37908();
            class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)MineCells.createId("gameplay/greed_shield_parry")));
            if (lootTable == null) {
                return;
            }
            class_1309 attacker = context.attacker();
            class_8567 lootContext = new class_8567.class_8568(serverWorld).method_51874(class_181.field_1226, (Object)attacker).method_51874(class_181.field_24424, (Object)attacker.method_19538()).method_51874(class_181.field_1231, (Object)context.source()).method_51877(class_181.field_1230, (Object)context.player()).method_51877(class_181.field_1227, (Object)context.player()).method_51875(class_173.field_1173);
            lootTable.method_51882(lootContext, stack -> {
                class_1542 item = new class_1542((class_1937)serverWorld, attacker.method_23317(), attacker.method_23318() + (double)attacker.method_17682() / 2.0, attacker.method_23321(), stack);
                item.method_6982(20);
                serverWorld.method_8649((class_1297)item);
            });
        };
    });
    private final ValueCalculator blockDamageReduction;
    private final ValueCalculator cooldown;
    private final ValueCalculator cooldownAfterParry;
    private final ValueCalculator parryDamage;
    private float blockAngle = 90.0f;
    private float parryAngle = 90.0f;
    private float parryTime = 5.0f;
    private class_2394 particle = null;
    private Consumer<ShieldUseContext> onUse = context -> {};
    private Consumer<DamageContext> onParry = context -> {};
    private Consumer<MeleeDamageContext> onMeleeParry = context -> {};
    private Consumer<RangedDamageContext> onRangedParry = context -> {};
    private Consumer<ShieldHoldContext> onHold = context -> {};
    private Consumer<DamageContext> onBlock = context -> {};
    private Consumer<MeleeDamageContext> onMeleeBlock = context -> {};
    private Consumer<RangedDamageContext> onRangedBlock = context -> {};

    private static void applyBleedingAround(class_1657 user, class_243 pos) {
        List entities = user.method_37908().method_8333(null, class_238.method_30048((class_243)pos, (double)8.0, (double)8.0, (double)8.0), entity -> entity.method_5707(pos) <= 16.0 && entity != user && entity instanceof class_1309);
        entities.forEach(entity -> ((class_1309)entity).method_6092(new class_1293(MineCellsStatusEffects.BLEEDING, 60, 1, false, false, true)));
    }

    public CustomShieldType(String name, Consumer<CustomShieldType> setup) {
        setup.accept(this);
        boolean base = "default".equals(name);
        this.blockDamageReduction = ValueCalculator.of((class_2960)MineCells.createId("shields/" + name), (String)"block_damage_reduction", base ? ctx -> 0.5 : arg_0 -> ((ValueCalculator)CustomShieldType.DEFAULT.blockDamageReduction).calculate(arg_0));
        this.cooldown = ValueCalculator.of((class_2960)MineCells.createId("shields/" + name), (String)"cooldown", base ? ctx -> 20.0 : arg_0 -> ((ValueCalculator)CustomShieldType.DEFAULT.cooldown).calculate(arg_0));
        this.cooldownAfterParry = ValueCalculator.of((class_2960)MineCells.createId("shields/" + name), (String)"cooldown_after_parry", base ? ctx -> 2.0 : arg_0 -> ((ValueCalculator)CustomShieldType.DEFAULT.cooldownAfterParry).calculate(arg_0));
        this.parryDamage = ValueCalculator.of((class_2960)MineCells.createId("shields/" + name), (String)"parry_damage", base ? ctx -> 6.0 : arg_0 -> ((ValueCalculator)CustomShieldType.DEFAULT.parryDamage).calculate(arg_0));
    }

    public float getBlockDamageReduction(ValueCalculatorContext context) {
        return (float)this.blockDamageReduction.calculate(context);
    }

    public float getBlockAngle() {
        return this.blockAngle;
    }

    public float getParryAngle() {
        return this.parryAngle;
    }

    public float getParryTime() {
        return this.parryTime + (float)MineCells.COMMON_CONFIG.additionalParryTime();
    }

    public float getParryDamage(ValueCalculatorContext context) {
        return (float)this.parryDamage.calculate(context);
    }

    public class_2394 getParticle() {
        return this.particle;
    }

    public int getCooldown(ValueCalculatorContext context, boolean parried) {
        ValueCalculator calculator = parried ? this.cooldownAfterParry : this.cooldown;
        return (int)calculator.calculate(context);
    }

    public void onUse(ShieldUseContext context) {
        this.onUse.accept(context);
    }

    public void onParry(DamageContext context) {
        this.onParry.accept(context);
    }

    public void onMeleeParry(MeleeDamageContext context) {
        this.onMeleeParry.accept(context);
    }

    public void onRangedParry(RangedDamageContext context) {
        this.onRangedParry.accept(context);
    }

    public void onHold(ShieldHoldContext context) {
        this.onHold.accept(context);
    }

    public void onBlock(DamageContext context) {
        this.onBlock.accept(context);
    }

    public void onMeleeBlock(MeleeDamageContext context) {
        this.onMeleeBlock.accept(context);
    }

    public void onRangedBlock(RangedDamageContext context) {
        this.onRangedBlock.accept(context);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$static$6(CustomShieldType it, ShieldUseContext context) {
        player = context.player();
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), MineCellsSounds.LEAPING_ZOMBIE_RELEASE, player.method_5634(), 1.0f, 1.0f);
        player.method_18799(player.method_5720().method_18805(0.5, 0.0, 0.5).method_1029().method_1021(1.5).method_1031(0.0, 0.2, 0.0));
        stack = class_2246.field_10124.method_8389().method_7854();
        mainHand = player.method_6047();
        offHand = player.method_6079();
        patt0$temp = mainHand.method_7909();
        if (!(patt0$temp instanceof CustomShieldItem)) ** GOTO lbl-1000
        shield = (CustomShieldItem)patt0$temp;
        if (shield.shieldType == it) {
            stack = mainHand;
        } else if ((patt1$temp = offHand.method_7909()) instanceof CustomShieldItem) {
            shield = (CustomShieldItem)patt1$temp;
            if (shield.shieldType == it) {
                stack = offHand;
            }
        }
        if (stack.method_7960()) {
            return;
        }
        stack.method_7970(1, (class_1309)player, player.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
    }

    public record MeleeDamageContext(class_1282 source, class_1657 player, class_1309 attacker, float amount) {
    }

    public record DamageContext(class_1282 source, class_1657 player, float amount) {
        public MeleeDamageContext toMelee(class_1309 attacker) {
            return new MeleeDamageContext(this.source, this.player, attacker, this.amount);
        }

        public RangedDamageContext toRanged(class_1309 attacker, class_1676 projectile) {
            return new RangedDamageContext(this.source, this.player, attacker, projectile, this.amount);
        }
    }

    public record ShieldHoldContext(class_1657 player, int useTicks) {
    }

    public record ShieldUseContext(class_1657 player) {
    }

    public record RangedDamageContext(class_1282 source, class_1657 player, class_1309 attacker, class_1676 projectile, float amount) {
    }
}

