/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.bow;

import com.github.mim1q.minecells.entity.nonliving.projectile.CustomArrowEntity;
import com.github.mim1q.minecells.item.MineCellsItemTags;
import com.github.mim1q.minecells.item.weapon.bow.CustomArrowShooter;
import com.github.mim1q.minecells.item.weapon.bow.CustomArrowType;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.LegacyUtil;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorContext;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorParameter;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class CustomBowItem
extends class_1811
implements CustomArrowShooter {
    private static final int MAX_USE_TIME = 72000;
    protected final CustomArrowType arrowType;
    protected final int maxProjectileCount;

    protected CustomBowItem(class_1792.class_1793 settings, CustomArrowType arrowType, int maxProjectileCount) {
        super(settings);
        this.arrowType = arrowType;
        this.maxProjectileCount = maxProjectileCount;
    }

    public CustomBowItem(class_1792.class_1793 settings, CustomArrowType arrowType) {
        this(settings, arrowType, 1);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (world.field_9236) {
            return;
        }
        int ticks = this.method_7881(stack, user) - remainingUseTicks;
        if (ticks < this.getDrawTime(user, stack) || !user.method_31747()) {
            return;
        }
        int loaded = this.loadMaxProjectiles(world, (class_1657)user, stack, user.method_18808(stack), this.maxProjectileCount);
        CustomBowItem.setLoadedProjectiles(stack, loaded);
        this.shoot(world, user, stack);
        stack.method_7970(1, user, user.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
    }

    protected void shoot(class_1937 world, class_1309 user, class_1799 stack) {
        world.method_8396(null, user.method_24515(), MineCellsSounds.BOW_RELEASE, class_3419.field_15248, 0.5f, 0.9f);
        class_243 velocity = user.method_5828(1.0f);
        this.spawnArrow(world, (class_1657)user, stack, velocity);
        CustomBowItem.setLoadedProjectiles(stack, 0);
    }

    protected CustomArrowEntity spawnArrow(class_1937 world, class_1657 user, class_1799 stack, class_243 velocity) {
        CustomArrowEntity arrow = new CustomArrowEntity(world, user, this.arrowType, user.method_33571(), stack);
        ValueCalculatorContext context = ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)user).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack);
        arrow.method_7485(velocity.method_10216(), velocity.method_10214(), velocity.method_10215(), this.arrowType.getSpeed(context), this.arrowType.getSpread(context));
        Optional flame = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9126);
        Optional punch = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9116);
        Integer flameLevel = flame.map(it -> class_1890.method_8225((class_6880)it, (class_1799)stack)).orElse(0);
        Integer punchLevel = punch.map(it -> class_1890.method_8225((class_6880)it, (class_1799)stack)).orElse(0);
        if (flameLevel > 0) {
            arrow.method_5639(1000.0f);
        }
        world.method_8649((class_1297)arrow);
        return arrow;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        boolean hasProjectile;
        class_1799 stack = user.method_5998(hand);
        class_1799 projectileStack = user.method_18808(stack);
        Optional infinity = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9125);
        boolean hasInfinity = infinity.map(it -> class_1890.method_8225((class_6880)it, (class_1799)stack) > 0).orElse(false);
        boolean projectileNeeded = this.arrowType.getAmmoItem().isPresent();
        boolean bl = hasProjectile = !projectileStack.method_7960();
        if (hasProjectile || hasInfinity || !projectileNeeded) {
            world.method_8396(null, user.method_24515(), MineCellsSounds.BOW_CHARGE, class_3419.field_15248, 0.5f, 0.8f);
            user.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public Predicate<class_1799> method_19268() {
        return item -> this.arrowType.getAmmoItem().map(arrow -> item.method_7909() == arrow).orElse(true);
    }

    protected final int loadMaxProjectiles(class_1937 world, class_1657 user, class_1799 bow, class_1799 arrow, int maxCount) {
        Optional infinity = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9125);
        Boolean hasInfinity = infinity.map(it -> class_1890.method_8225((class_6880)it, (class_1799)bow) > 0).orElse(false);
        if (user.method_7337() || world.field_9236 || arrow.method_7960() || this.arrowType.getAmmoItem().isEmpty() || hasInfinity.booleanValue()) {
            return maxCount;
        }
        for (int i = 0; i < maxCount; ++i) {
            if (arrow.method_7960()) {
                return i;
            }
            arrow.method_7934(1);
        }
        return maxCount;
    }

    public int method_24792() {
        return 100;
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float speed, float divergence, float yaw, @Nullable class_1309 target) {
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public int getDrawTime(class_1309 user, class_1799 stack) {
        ValueCalculatorContext context = ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)user).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack);
        return this.arrowType.getDrawTime(context);
    }

    public float getFovMultiplier(class_1657 player, class_1799 stack) {
        float multiplier = (float)player.method_6048() / (float)this.getDrawTime((class_1309)player, stack);
        multiplier = multiplier > 1.0f ? 1.0f : (multiplier *= multiplier);
        return 1.0f - multiplier * 0.15f;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        class_5321 enchantId = (class_5321)enchantment.method_40230().orElseThrow();
        if (enchantId == class_1893.field_9125 && stack.method_31573(MineCellsItemTags.BOWS_ACCEPTING_INFINITY) || enchantId == class_1893.field_9116 && stack.method_31573(MineCellsItemTags.BOWS_ACCEPTING_PUNCH) || enchantId == class_1893.field_9103 && stack.method_31573(MineCellsItemTags.BOWS_ACCEPTING_POWER) || enchantId == class_1893.field_9126 && stack.method_31573(MineCellsItemTags.BOWS_ACCEPTING_FLAME) || enchantId == class_1893.field_9098 && stack.method_31573(MineCellsItemTags.BOWS_ACCEPTING_QUICK_CHARGE)) {
            return true;
        }
        return super.canBeEnchantedWith(stack, enchantment, context);
    }

    public static int getLoadedProjectiles(class_1799 bow) {
        CustomBowItem bowItem = (CustomBowItem)bow.method_7909();
        return bowItem.maxProjectileCount == 1 ? 1 : LegacyUtil.getOrCreateNbt(bow).method_10550("LoadedProjectiles");
    }

    public static void setLoadedProjectiles(class_1799 bow, int count) {
        CustomBowItem bowItem = (CustomBowItem)bow.method_7909();
        if (bowItem.maxProjectileCount == 1) {
            return;
        }
        class_2487 nbt = LegacyUtil.getOrCreateNbt(bow);
        nbt.method_10569("LoadedProjectiles", count);
        LegacyUtil.writeNbt(bow, nbt);
    }

    @Override
    public CustomArrowType getArrowType() {
        return this.arrowType;
    }
}

