/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.JumpBackGoal;
import com.github.mim1q.minecells.entity.ai.goal.ShootGoal;
import com.github.mim1q.minecells.entity.ai.goal.WalkTowardsTargetGoal;
import com.github.mim1q.minecells.entity.interfaces.IShootEntity;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1667;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class UndeadArcherEntity
extends MineCellsEntity
implements IShootEntity {
    public final AnimationProperty handsUpProgess = new AnimationProperty(0.0f);
    public final AnimationProperty pullProgress = new AnimationProperty(0.0f);
    private int jumpbackCooldown = 0;
    private static final class_2940<Boolean> SHOOT_CHARGING = class_2945.method_12791(UndeadArcherEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOOT_RELEASING = class_2945.method_12791(UndeadArcherEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SHOOT_COOLDOWN = class_2945.method_12791(UndeadArcherEntity.class, (class_2941)class_2943.field_13327);

    public UndeadArcherEntity(class_1299<UndeadArcherEntity> type, class_1937 world) {
        super(type, world);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new JumpBackGoal<UndeadArcherEntity>(this, s -> {
            s.minDistance = 8.0;
            s.sideStrength = 0.66;
            s.defaultCooldown = 10;
            s.actionTick = 5;
            s.length = 10;
            s.chance = 0.3f;
            s.cooldownGetter = () -> this.jumpbackCooldown;
            s.cooldownSetter = ticks -> {
                this.jumpbackCooldown = ticks;
            };
        }, it -> !it.isShootCharging() && !it.isShootReleasing()));
        this.field_6201.method_6277(1, (class_1352)new UndeadArcherShootGoal(this, 15, 25, 0.5f));
        this.field_6201.method_6277(2, (class_1352)new WalkTowardsTargetGoal((class_1314)this, 1.0, false, 8.5));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SHOOT_CHARGING, (Object)false);
        builder.method_56912(SHOOT_RELEASING, (Object)false);
        builder.method_56912(SHOOT_COOLDOWN, (Object)0);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);
        this.method_6122(this.method_6058(), class_1802.field_8102.method_7854());
        this.method_5937(false);
        return result;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    private void clientTick() {
        if (this.isShootCharging()) {
            this.handsUpProgess.setupTransitionTo(1.0f, 10.0f);
            this.pullProgress.setupTransitionTo(1.0f, 20.0f);
        } else {
            this.handsUpProgess.setupTransitionTo(0.0f, 5.0f);
            this.pullProgress.setupTransitionTo(0.0f, 5.0f);
        }
    }

    private void serverTick() {
        --this.jumpbackCooldown;
    }

    @Override
    protected void decrementCooldowns() {
        this.decrementCooldown(SHOOT_COOLDOWN);
    }

    public int method_5850() {
        return 3;
    }

    public static class_5132.class_5133 createUndeadArcherAttributes() {
        return UndeadArcherEntity.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23717, 24.0);
    }

    @Override
    public boolean isShootCharging() {
        return (Boolean)this.field_6011.method_12789(SHOOT_CHARGING);
    }

    @Override
    public void setShootCharging(boolean charging) {
        this.method_19540(charging);
        this.field_6011.method_12778(SHOOT_CHARGING, (Object)charging);
    }

    @Override
    public boolean isShootReleasing() {
        return (Boolean)this.field_6011.method_12789(SHOOT_RELEASING);
    }

    @Override
    public void setShootReleasing(boolean releasing) {
        this.field_6011.method_12778(SHOOT_RELEASING, (Object)releasing);
    }

    @Override
    public int getShootCooldown() {
        return (Integer)this.field_6011.method_12789(SHOOT_COOLDOWN);
    }

    @Override
    public void setShootCooldown(int ticks) {
        this.field_6011.method_12778(SHOOT_COOLDOWN, (Object)ticks);
    }

    @Override
    public int getShootMaxCooldown() {
        return 20;
    }

    @Override
    public class_3414 getShootChargeSoundEvent() {
        return MineCellsSounds.BOW_CHARGE;
    }

    @Override
    public class_3414 getShootReleaseSoundEvent() {
        return MineCellsSounds.BOW_RELEASE;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("shootCooldown", this.getShootCooldown());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setShootCooldown(nbt.method_10550("shootCooldown"));
    }

    public static class UndeadArcherShootGoal
    extends ShootGoal<UndeadArcherEntity> {
        public UndeadArcherShootGoal(UndeadArcherEntity entity, int actionTick, int lengthTicks, float chance) {
            super(entity, actionTick, lengthTicks, chance);
        }

        @Override
        public boolean method_6264() {
            return ((UndeadArcherEntity)this.entity).method_6047().method_7909() == class_1802.field_8102 && super.method_6264();
        }

        @Override
        public void shoot(class_1309 target) {
            super.shoot(target);
            class_1667 arrow = (class_1667)class_1299.field_6122.method_5883(target.method_37908());
            if (arrow == null) {
                return;
            }
            arrow.method_23327(((UndeadArcherEntity)this.entity).method_23317(), ((UndeadArcherEntity)this.entity).method_23320(), ((UndeadArcherEntity)this.entity).method_23321());
            double d = target.method_23317() - ((UndeadArcherEntity)this.entity).method_23317();
            double e = target.method_23323(0.33) - arrow.method_23318();
            double f = target.method_23321() - ((UndeadArcherEntity)this.entity).method_23321();
            double g = Math.sqrt(d * d + f * f);
            arrow.method_7485(d, e + g * 0.2, f, 1.6f, 1.0f);
            ((UndeadArcherEntity)this.entity).method_37908().method_8649((class_1297)arrow);
        }

        @Override
        public void method_6268() {
            super.method_6268();
            ((UndeadArcherEntity)this.entity).method_6019(class_1675.method_18812((class_1309)this.entity, (class_1792)class_1802.field_8102));
            if (((UndeadArcherEntity)this.entity).isShootReleasing()) {
                ((UndeadArcherEntity)this.entity).method_6021();
            }
        }
    }
}

