/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedAuraGoal;
import com.github.mim1q.minecells.entity.damage.MineCellsDamageSource;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.ParticleUtils;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;

public class MineCellsEntity
extends class_1588 {
    public static final float ELITE_SCALE = 1.25f;
    private static final class_2940<Boolean> IS_ELITE = class_2945.method_12791(MineCellsEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ELITE_AURA_CHARGING = class_2945.method_12791(MineCellsEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ELITE_AURA_RELEASING = class_2945.method_12791(MineCellsEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> FOR_DISPLAY = class_2945.method_12791(MineCellsEntity.class, (class_2941)class_2943.field_13323);
    public class_2338 spawnRunePos = null;
    private boolean recalculatedDimensions = false;
    private class_2960 additionalLootTable = null;
    private long disappearTime = -1L;
    private int eliteAttackCooldown = 100;

    protected MineCellsEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 1.0));
        if (this.isElite()) {
            this.field_6201.method_6277(0, new TimedAuraGoal<MineCellsEntity>(this, settings -> {
                settings.radius = 2.6;
                settings.defaultCooldown = 80;
                settings.cooldownGetter = () -> this.eliteAttackCooldown;
                settings.cooldownSetter = value -> {
                    this.eliteAttackCooldown = value + this.field_5974.method_43048(40);
                };
                settings.stateSetter = this.handleStateChange(ELITE_AURA_CHARGING, ELITE_AURA_RELEASING);
                settings.chargeSound = MineCellsSounds.SHOCKER_CHARGE;
                settings.releaseSound = MineCellsSounds.SHOCKER_RELEASE;
                settings.length = 80;
                settings.actionTick = 40;
                settings.damage = (float)this.method_45325(class_5134.field_23721);
                settings.chance = 0.05f;
            }, Objects::nonNull));
        }
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 0, false, false, null));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_ELITE, (Object)false);
        builder.method_56912(ELITE_AURA_CHARGING, (Object)false);
        builder.method_56912(ELITE_AURA_RELEASING, (Object)false);
        builder.method_56912(FOR_DISPLAY, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.recalculatedDimensions) {
            this.recalculatedDimensions = true;
            this.method_18382();
            this.method_33332();
        }
        if (this.method_37908().field_9236) {
            this.processAnimations();
            this.spawnAuraParticles();
        } else {
            this.decrementCooldowns();
            --this.eliteAttackCooldown;
        }
        if (!this.method_37908().field_9236 && this.disappearTime > 0L && this.method_37908().method_8510() >= this.disappearTime) {
            this.method_31472();
        }
    }

    private void spawnAuraParticles() {
        int amount = 0;
        double speed = 0.0;
        if (((Boolean)this.field_6011.method_12789(ELITE_AURA_CHARGING)).booleanValue()) {
            amount = 5;
            speed = -0.05;
        } else if (((Boolean)this.field_6011.method_12789(ELITE_AURA_RELEASING)).booleanValue()) {
            amount = 20;
            speed = 0.25;
        }
        ParticleUtils.addAura(this.method_37908(), this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0), (class_2394)MineCellsParticles.AURA, amount, 2.5, 0.0);
        ParticleUtils.addAura(this.method_37908(), this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0), (class_2394)MineCellsParticles.AURA, amount, (double)this.method_17682() * 0.5, speed);
    }

    public class_4048 method_55694(class_4050 pose) {
        class_4048 result = super.method_55694(pose);
        if (this.isElite()) {
            return class_4048.method_18385((float)(result.comp_2185() * 1.25f), (float)(result.comp_2186() * 1.25f));
        }
        return result;
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return 0.0f;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        int worldY = world.method_8624(class_2902.class_2903.field_13202, this.method_31477(), this.method_31479());
        if (this.method_59922().method_43057() < 0.9f || class_3532.method_15382((int)(worldY - this.method_31478())) > 5) {
            return false;
        }
        if (world.method_18460((class_1297)this, 64.0) != null) {
            return false;
        }
        class_2680 blockBelow = world.method_8320(this.method_24515().method_10074());
        return blockBelow.method_26206((class_1922)world, this.method_24515().method_10074(), class_2350.field_11036) && blockBelow.method_26204() != class_2246.field_9987;
    }

    protected void method_23883(class_1297 attacker) {
        super.method_23883(attacker);
        if (this.additionalLootTable != null) {
            MinecraftServer server = this.method_37908().method_8503();
            if (server == null) {
                return;
            }
            class_52 lootTable = server.method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)this.additionalLootTable));
            if (lootTable == null) {
                return;
            }
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)this.method_48923().method_48830());
            class_1282 damageSource = this.method_6081();
            if (damageSource != null) {
                builder = builder.method_51874(class_181.field_1231, (Object)damageSource).method_51877(class_181.field_1230, (Object)damageSource.method_5529()).method_51877(class_181.field_1227, (Object)damageSource.method_5526());
            }
            if (this.method_49107() != null && this.method_49107().method_31747() && this.field_6258 != null) {
                builder = builder.method_51874(class_181.field_1233, (Object)this.field_6258).method_51871(this.field_6258.method_7292());
            }
            class_8567 lootContextParameterSet = builder.method_51875(class_173.field_1173);
            lootTable.method_51882(lootContextParameterSet, arg_0 -> ((MineCellsEntity)this).method_5775(arg_0));
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_49708(MineCellsDamageSource.GRENADE.key)) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    protected void decrementCooldown(class_2940<Integer> cooldown) {
        int current = (Integer)this.field_6011.method_12789(cooldown);
        if (current > 0) {
            this.field_6011.method_12778(cooldown, (Object)(current - 1));
        }
    }

    protected TimedActionGoal.State getStateFromTrackedData(class_2940<Boolean> charging, class_2940<Boolean> releasing) {
        if (((Boolean)this.field_6011.method_12789(charging)).booleanValue()) {
            return TimedActionGoal.State.CHARGE;
        }
        if (((Boolean)this.field_6011.method_12789(releasing)).booleanValue()) {
            return TimedActionGoal.State.RELEASE;
        }
        return TimedActionGoal.State.IDLE;
    }

    protected void decrementCooldowns() {
    }

    protected void processAnimations() {
    }

    public boolean isElite() {
        return (Boolean)this.field_6011.method_12789(IS_ELITE);
    }

    protected class_3414 method_6002() {
        return MineCellsSounds.LEAPING_ZOMBIE_DEATH;
    }

    public boolean isForDisplay() {
        return (Boolean)this.field_6011.method_12789(FOR_DISPLAY);
    }

    public void setDisappearTime(long disappearTime) {
        this.disappearTime = disappearTime;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.spawnRunePos != null) {
            nbt.method_10544("spawnRunePos", this.spawnRunePos.method_10063());
        }
        nbt.method_10556("isElite", ((Boolean)this.field_6011.method_12789(IS_ELITE)).booleanValue());
        if (this.additionalLootTable != null) {
            nbt.method_10582("additionalLootTable", this.additionalLootTable.toString());
        }
        nbt.method_10556("forDisplay", ((Boolean)this.field_6011.method_12789(FOR_DISPLAY)).booleanValue());
        nbt.method_10544("disappear_time", this.disappearTime);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("spawnRunePos")) {
            this.spawnRunePos = class_2338.method_10092((long)nbt.method_10537("spawnRunePos"));
        }
        this.field_6011.method_12778(IS_ELITE, (Object)nbt.method_10577("isElite"));
        if (nbt.method_10545("additionalLootTable")) {
            this.additionalLootTable = class_2960.method_12829((String)nbt.method_10558("additionalLootTable"));
        }
        if (nbt.method_10545("forDisplay")) {
            this.field_6011.method_12778(FOR_DISPLAY, (Object)nbt.method_10577("forDisplay"));
        }
        if (nbt.method_10545("disappear_time")) {
            this.disappearTime = nbt.method_10537("disappear_time");
        }
        this.method_18382();
        this.method_33332();
        this.field_6201.method_35113(Objects::nonNull);
        this.field_6185.method_35113(Objects::nonNull);
        this.method_5959();
    }

    protected void handleStateChange(TimedActionGoal.State state, boolean value, class_2940<Boolean> charging, class_2940<Boolean> releasing) {
        switch (state) {
            case CHARGE: {
                this.field_6011.method_12778(charging, (Object)value);
                break;
            }
            case RELEASE: {
                this.field_6011.method_12778(releasing, (Object)value);
            }
        }
    }

    protected BiConsumer<TimedActionGoal.State, Boolean> handleStateChange(class_2940<Boolean> charging, class_2940<Boolean> releasing) {
        return (state, value) -> this.handleStateChange((TimedActionGoal.State)((Object)state), (boolean)value, charging, releasing);
    }

    public float getDamage(float scale) {
        return (float)this.method_45325(class_5134.field_23721) * scale;
    }
}

