/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.datagen.util;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.ColoredTorchBlock;
import com.github.mim1q.minecells.block.FlagBlock;
import com.github.mim1q.minecells.block.SkeletonDecorationBlock;
import com.github.mim1q.minecells.datagen.util.DatagenLootTableUtils;
import com.github.mim1q.minecells.datagen.util.DatagenModelUtils;
import com.github.mim1q.minecells.datagen.util.DatagenRecipeUtil;
import com.github.mim1q.minecells.datagen.util.DatagenTagUtils;
import com.github.mim1q.minecells.datagen.util.specific.DatagenWoodModelUtils;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.registry.featureset.FullStoneSet;
import com.github.mim1q.minecells.registry.featureset.LeavesSet;
import com.github.mim1q.minecells.registry.featureset.SimpleSet;
import com.github.mim1q.minecells.registry.featureset.StoneSet;
import com.github.mim1q.minecells.registry.featureset.WoodSet;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2231;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2473;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_44;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public interface DatagenBlockSetUtils
extends DatagenWoodModelUtils,
DatagenTagUtils,
DatagenLootTableUtils,
DatagenRecipeUtil {
    default public void addSimpleSet(SimpleSet set) {
        this.addBlock(set.block);
        this.addSlab(set.slab, set.block);
        this.addStairs(set.stairs, set.block);
        this.addSimpleDrop(new class_2248[]{set.block, set.slab, set.stairs});
    }

    default public void addWoodSet(WoodSet set) {
        this.addBlock(set.planks);
        this.addPillar((class_2248)set.log);
        this.addPillar((class_2248)set.strippedLog);
        this.addPillar((class_2248)set.wood, DatagenModelUtils.getBlockId((class_2248)set.log).method_48331("_side"));
        this.addPillar((class_2248)set.strippedWood, DatagenModelUtils.getBlockId((class_2248)set.strippedLog).method_48331("_side"));
        this.addStairs(set.stairs, set.planks);
        this.addSlab(set.slab, set.planks);
        this.addFence(set.fence, set.planks);
        this.addFenceGate(set.fenceGate, set.planks);
        this.addButton(set.button, set.planks);
        this.addPressurePlate((class_2231)set.pressurePlate, set.planks);
        this.addTrapdoor(set.trapdoor, set.planks);
        this.addDoor(set.door, set.planks);
        this.addSign(set.sign, set.wallSign, (class_1792)set.signItem, set.planks);
        this.addSimpleDrop((class_2248[])set.getBlocks().stream().filter(it -> !(it instanceof class_2323)).toArray(class_2248[]::new));
        this.getInitializers().blockLootTable().add(it -> it.method_45988((class_2248)set.door, it.method_46022((class_2248)set.door)));
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15471, set.planks);
        this.addBlockTag((class_6862<class_2248>)class_3481.field_23210, new class_2248[]{set.log, set.strippedLog, set.wood, set.strippedWood});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15468, new class_2248[]{set.slab});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15502, new class_2248[]{set.stairs});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_17619, new class_2248[]{set.fence});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_25147, new class_2248[]{set.fenceGate});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15499, new class_2248[]{set.button});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15477, new class_2248[]{set.pressurePlate});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15491, new class_2248[]{set.trapdoor});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15494, new class_2248[]{set.door});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15492, new class_2248[]{set.wallSign});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15472, new class_2248[]{set.sign});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15500, new class_2248[]{set.wallSign, set.sign});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_33713, set.getBlocks());
        this.addItemTag((class_6862<class_1792>)class_3489.field_15534, new class_1935[]{set.slab});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15557, new class_1935[]{set.stairs});
        this.addItemTag((class_6862<class_1792>)class_3489.field_17620, new class_1935[]{set.fence});
        this.addItemTag((class_6862<class_1792>)class_3489.field_40858, new class_1935[]{set.fenceGate});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15555, new class_1935[]{set.button});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15540, new class_1935[]{set.pressurePlate});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15550, new class_1935[]{set.trapdoor});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15552, new class_1935[]{set.door});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15533, (FabricTagProvider.FabricTagBuilder tag) -> tag.add((Object)set.signItem));
    }

    default public void addStoneSet(StoneSet set, boolean baseBlockDrop, StoneSet ... baseSets) {
        if (set.getClass() != StoneSet.class) {
            throw new IllegalArgumentException("Subclasses of StoneSet must use specific methods");
        }
        this._addStoneSet(set, baseBlockDrop, baseSets);
    }

    private void _addStoneSet(StoneSet set, boolean baseBlockDrop, StoneSet ... baseSets) {
        this.addBlock(set.block);
        this.addStairs(set.stairs, set.block);
        this.addSlab(set.slab, set.block);
        this.addWall(set.wall, set.block);
        if (baseBlockDrop) {
            this.addSimpleDrop(set.block);
        }
        this.addSimpleDrop(new class_2248[]{set.stairs, set.slab, set.wall});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_33715, set.getBlocks());
        this.addStoneSetStonecutterRecipes(set, baseSets);
    }

    default public void addFullStoneSet(FullStoneSet set, boolean baseBlockDrop, StoneSet ... baseSets) {
        this._addStoneSet(set, baseBlockDrop, baseSets);
        this.addButton(set.button, set.block);
        this.addPressurePlate((class_2231)set.pressurePlate, set.block);
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15493, new class_2248[]{set.button});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_24076, new class_2248[]{set.pressurePlate});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_33715, new class_2248[]{set.button, set.pressurePlate});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15551, new class_1935[]{set.button});
        this.addItemTag((class_6862<class_1792>)class_3489.field_25808, new class_1935[]{set.block});
        this.addItemTag((class_6862<class_1792>)class_3489.field_23802, new class_1935[]{set.block});
        this.addSimpleDrop(new class_2248[]{set.button, set.pressurePlate});
    }

    default public void addStoneSetStonecutterRecipes(StoneSet set, StoneSet ... baseSets) {
        this.addStonecutterRecipe((class_1935)set.block, (class_1935)set.stairs, 1);
        this.addStonecutterRecipe((class_1935)set.block, (class_1935)set.slab, 2);
        this.addStonecutterRecipe((class_1935)set.block, (class_1935)set.wall, 1);
        for (StoneSet baseSet : baseSets) {
            this.addStonecutterRecipe((class_1935)baseSet.block, (class_1935)set.block, 1);
            this.addStonecutterRecipe((class_1935)baseSet.block, (class_1935)set.stairs, 1);
            this.addStonecutterRecipe((class_1935)baseSet.stairs, (class_1935)set.stairs, 1);
            this.addStonecutterRecipe((class_1935)baseSet.block, (class_1935)set.slab, 2);
            this.addStonecutterRecipe((class_1935)baseSet.slab, (class_1935)set.slab, 1);
            this.addStonecutterRecipe((class_1935)baseSet.block, (class_1935)set.wall, 1);
            this.addStonecutterRecipe((class_1935)baseSet.wall, (class_1935)set.wall, 1);
        }
    }

    default public void addLeavesSet(LeavesSet set, class_2473 sapling) {
        this.addLeaves(set.leaves, sapling);
        this.getInitializers().blockState().add(it -> {
            class_4945 zeroTextureKey = class_4945.method_27043((String)"0");
            class_4945 baseTextureKey = class_4945.method_27043((String)"base");
            class_4945 detailTextureKey = class_4945.method_27043((String)"detail");
            class_2960 wallModel = new class_4942(Optional.of(MineCells.createId("block/wall_leaves")), Optional.empty(), new class_4945[]{baseTextureKey, detailTextureKey}).method_25846((class_2248)set.wallLeaves, class_4944.method_25883((class_4945)baseTextureKey, (class_2960)DatagenModelUtils.getBlockId(set.wallLeaves)).method_25868(detailTextureKey, DatagenModelUtils.getBlockId(set.wallLeaves).method_48331("_detail")), it.field_22831);
            class_2960 hangingModel = new class_4942(Optional.of(MineCells.createId("block/hanging_leaves")), Optional.empty(), new class_4945[]{zeroTextureKey}).method_25846((class_2248)set.hangingLeaves, class_4944.method_25883((class_4945)zeroTextureKey, (class_2960)DatagenModelUtils.getBlockId((class_2248)set.hangingLeaves)), it.field_22831);
            it.field_22830.accept(class_4925.method_25769((class_2248)set.wallLeaves).method_25775(DatagenModelUtils.createRotateableCoordinates(wallModel)));
            it.field_22830.accept(class_4925.method_25769((class_2248)set.hangingLeaves).method_25775(DatagenModelUtils.createHorizontalRotateableCoordinates(hangingModel)));
            it.method_25538(set.wallLeaves.method_8389(), wallModel);
            it.method_25538(set.hangingLeaves.method_8389(), hangingModel);
            it.method_25549((class_2248)sapling, class_4910.class_4913.field_22840, class_4944.method_25883((class_4945)class_4945.field_23025, (class_2960)DatagenModelUtils.getBlockId((class_2248)sapling)));
        });
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15503, new class_2248[]{set.leaves});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15558, new class_1935[]{set.leaves});
        this.addBlockTag((class_6862<class_2248>)class_3481.field_15462, new class_2248[]{sapling});
        this.addItemTag((class_6862<class_1792>)class_3489.field_15528, new class_1935[]{sapling});
    }

    default public void addColoredTorch(ColoredTorchBlock torch, String flameName) {
        this.getInitializers().blockState().add(it -> {
            class_4945 flameTextureKey = class_4945.method_27043((String)"flame");
            class_2960 flameTexture = MineCells.createId("block/colored_torch/" + flameName);
            class_2960 baseModel = MineCells.createId("block/template/colored_torch");
            class_2960 baseModelStanding = MineCells.createId("block/template/colored_torch_standing");
            class_4944 texture = new class_4944().method_25868(flameTextureKey, flameTexture);
            class_2960 model = new class_4942(Optional.of(baseModel), Optional.empty(), new class_4945[]{flameTextureKey}).method_25846((class_2248)torch, texture, it.field_22831);
            class_2960 modelStanding = new class_4942(Optional.of(baseModelStanding), Optional.empty(), new class_4945[]{flameTextureKey}).method_25847((class_2248)torch, "_standing", texture, it.field_22831);
            it.field_22830.accept(class_4925.method_25769((class_2248)torch).method_25775(class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)ColoredTorchBlock.STANDING).method_25803((dir, standing) -> {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(standing != false ? modelStanding : model));
                if (!standing.booleanValue()) {
                    variant.method_25828(class_4936.field_22886, (Object)DatagenModelUtils.rotationFromDir(dir));
                }
                return List.of(variant);
            })));
            it.method_25623((class_2248)torch, modelStanding);
        });
        this.addSimpleDrop((class_2248)torch);
    }

    default public void addFlag(FlagBlock flag, class_1935 ingredient, @Nullable class_2960 advancement) {
        this.addParticleOnly((class_2248)flag, class_2246.field_10161);
        this.addSimpleDrop((class_2248)flag);
        this.getInitializers().blockState().add(it -> {
            class_4942 model = new class_4942(Optional.of(BUILTIN_ENTITY_MODEL), Optional.of("inventory"), new class_4945[0]);
            model.method_48525(DatagenModelUtils.getItemId((class_1935)flag), new class_4944(), it.field_22831, (x, textures) -> {
                JsonObject json = model.method_48524(DatagenModelUtils.getItemId((class_1935)flag), Map.of());
                json.addProperty("gui_light", "front");
                return json;
            });
        });
        this.getInitializers().cellCrafterRecipes().add(new CellForgeRecipe(class_7923.field_41178.method_10221((Object)flag.method_8389()), Map.of(ingredient.method_8389(), 2, class_1802.field_8600, 1), flag.method_8389().method_7854(), Optional.ofNullable(advancement), 100, CellForgeRecipe.Category.DECORATION));
        this.addBlockTag((class_6862<class_2248>)class_3481.field_33713, new class_2248[]{flag});
    }

    default public void addCorpse(SkeletonDecorationBlock sitting, SkeletonDecorationBlock hanging, class_1792 drop, class_1792 dropRare) {
        this.getInitializers().blockState().add(it -> {
            it.method_25708((class_2248)sitting);
            it.method_25708((class_2248)hanging);
        });
        this.getInitializers().blockLootTable().add(it -> {
            class_52.class_53 dropBuilder = it.method_46003((class_1935)sitting).method_336(class_55.method_347().method_356(it.method_60390().method_16780()).method_352((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)drop)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)dropRare)).method_356(class_219.method_932((float)0.2f)));
            it.method_45988((class_2248)sitting, dropBuilder);
            it.method_45988((class_2248)hanging, dropBuilder);
        });
    }
}

