/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.nonliving;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.client.render.misc.AdvancementHintRenderer;
import com.github.mim1q.minecells.client.render.model.nonliving.ObeliskEntityModel;
import com.github.mim1q.minecells.entity.nonliving.obelisk.ObeliskEntity;
import com.github.mim1q.minecells.registry.MineCellsRenderers;
import com.github.mim1q.minecells.util.MathUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Quaternionf;

public class ObeliskEntityRenderer
extends class_897<ObeliskEntity> {
    private final class_2960 texture;
    private final ObeliskEntityModel model;
    private final AdvancementHintRenderer hintRenderer;

    public ObeliskEntityRenderer(class_5617.class_5618 ctx, String texture) {
        super(ctx);
        this.model = new ObeliskEntityModel(ctx.method_32167(MineCellsRenderers.OBELISK_LAYER));
        this.texture = MineCells.createId("textures/entity/obelisk/" + texture + ".png");
        this.hintRenderer = new AdvancementHintRenderer(MineCells.createId("elite"), ctx.method_32168(), -45510, null);
    }

    public void render(ObeliskEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        matrices.method_22903();
        matrices.method_22905(1.0f, -1.0f, -1.0f);
        matrices.method_46416(0.0f, -1.5f, 0.0f);
        matrices.method_22907(new Quaternionf().rotationY(MathUtils.radians(yaw)));
        float animationProgress = (float)entity.field_6012 + tickDelta;
        this.model.setAngles(entity, 0.0f, 0.0f, animationProgress, 0.0f, 0.0f);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)this.texture));
        this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, -1);
        class_4588 glowVertexConsumer = vertexConsumers.getBuffer(class_1921.method_42600((class_2960)this.texture));
        float glow = entity.glow.update(animationProgress);
        this.model.renderGlow(matrices, glowVertexConsumer, light, class_4608.field_21444, 0xFFFFFF | (int)(glow * 255.0f) << 24);
        matrices.method_22909();
        if (entity.bury.getValue() < 0.1f) {
            matrices.method_22903();
            matrices.method_22904(0.0, 2.75, 0.0);
            this.hintRenderer.render(matrices, vertexConsumers, (float)entity.field_6012 + tickDelta);
            matrices.method_22909();
        }
    }

    public class_2960 getTexture(ObeliskEntity entity) {
        return this.texture;
    }
}

