/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.model;

import com.github.mim1q.minecells.entity.ScorpionEntity;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.animation.AnimationUtils;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class ScorpionEntityModel
extends class_583<ScorpionEntity> {
    private final class_630 root;
    private final class_630[] tail = new class_630[5];
    private final class_630 body;
    private final class_630 head;
    private final class_630 rightHindLeg;
    private final class_630 leftHindLeg;
    private final class_630 rightFrontLeg;
    private final class_630 leftFrontLeg;
    private boolean shouldRender = false;

    public ScorpionEntityModel(class_630 bone) {
        this.root = bone.method_32086("root");
        this.body = this.root.method_32086("body");
        this.tail[0] = this.body.method_32086("tail_0");
        for (int i = 1; i < this.tail.length; ++i) {
            this.tail[i] = this.tail[i - 1].method_32086("tail_" + i);
        }
        this.head = this.body.method_32086("head");
        this.leftHindLeg = this.root.method_32086("left_hind_leg");
        this.leftFrontLeg = this.root.method_32086("left_front_leg");
        this.rightHindLeg = this.root.method_32086("right_hind_leg");
        this.rightFrontLeg = this.root.method_32086("right_front_leg");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 dRoot = modelPartData.method_32117("root", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 dBody = dRoot.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -6.0f, -6.0f, 8.0f, 6.0f, 12.0f), class_5603.method_32090((float)0.0f, (float)-4.0f, (float)0.0f));
        dBody.method_32117("plate_0", class_5606.method_32108().method_32101(28, 0).method_32098(-4.0f, 0.0f, 0.0f, 8.0f, 2.0f, 9.0f, new class_5605(0.02f)), class_5603.method_32091((float)0.0f, (float)-6.0f, (float)-6.0f, (float)MathUtils.radians(40.0f), (float)0.0f, (float)0.0f));
        dBody.method_32117("plate_1", class_5606.method_32108().method_32101(28, 0).method_32098(-4.0f, 0.0f, 0.0f, 8.0f, 2.0f, 9.0f, new class_5605(0.01f)), class_5603.method_32091((float)0.0f, (float)-6.0f, (float)-3.0f, (float)MathUtils.radians(25.0f), (float)0.0f, (float)0.0f));
        dRoot.method_32117("left_front_leg", class_5606.method_32108().method_32101(0, 14).method_32098(0.0f, 0.0f, -2.0f, 0.0f, 9.0f, 4.0f, new class_5605(0.01f)), class_5603.method_32091((float)4.5f, (float)-9.0f, (float)-5.5f, (float)0.0f, (float)MathUtils.radians(25.0f), (float)0.0f));
        dRoot.method_32117("left_hind_leg", class_5606.method_32108().method_32101(0, 14).method_32098(0.0f, 0.0f, -2.0f, 0.0f, 9.0f, 4.0f, new class_5605(0.01f)), class_5603.method_32091((float)4.5f, (float)-9.0f, (float)5.5f, (float)0.0f, (float)MathUtils.radians(-25.0f), (float)0.0f));
        dRoot.method_32117("right_front_leg", class_5606.method_32108().method_32101(0, 14).method_32098(0.0f, 0.0f, -2.0f, 0.0f, 9.0f, 4.0f, new class_5605(0.01f)), class_5603.method_32091((float)-4.5f, (float)-9.0f, (float)-5.5f, (float)0.0f, (float)MathUtils.radians(-25.0f), (float)0.0f));
        dRoot.method_32117("right_hind_leg", class_5606.method_32108().method_32101(0, 14).method_32098(0.0f, 0.0f, -2.0f, 0.0f, 9.0f, 4.0f, new class_5605(0.01f)), class_5603.method_32091((float)-4.5f, (float)-9.0f, (float)5.5f, (float)0.0f, (float)MathUtils.radians(25.0f), (float)0.0f));
        class_5610 dHead = dBody.method_32117("head", class_5606.method_32108().method_32101(26, 37).method_32097(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 5.0f), class_5603.method_32090((float)0.0f, (float)-3.0f, (float)-6.0f));
        class_5610 dUpperRightMandible = dHead.method_32117("upper_right_mandible", class_5606.method_32108().method_32101(0, 45).method_32097(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f), class_5603.method_32091((float)-2.5f, (float)-3.0f, (float)-5.0f, (float)MathUtils.radians(45.0f), (float)0.0f, (float)MathUtils.radians(-30.0f)));
        dUpperRightMandible.method_32117("upper_right_spike", class_5606.method_32108().method_32101(6, 45).method_32097(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 1.0f), class_5603.method_32091((float)0.0f, (float)-2.0f, (float)0.0f, (float)MathUtils.radians(45.0f), (float)0.0f, (float)0.0f));
        class_5610 dUpperLeftMandible = dHead.method_32117("upper_left_mandible", class_5606.method_32108().method_32101(0, 45).method_32097(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f), class_5603.method_32091((float)2.5f, (float)-3.0f, (float)-5.0f, (float)MathUtils.radians(45.0f), (float)0.0f, (float)MathUtils.radians(30.0f)));
        dUpperLeftMandible.method_32117("upper_left_spike", class_5606.method_32108().method_32101(6, 45).method_32097(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 1.0f), class_5603.method_32091((float)0.0f, (float)-2.0f, (float)0.0f, (float)MathUtils.radians(45.0f), (float)0.0f, (float)0.0f));
        class_5610 dLowerLeftMandible = dHead.method_32117("lower_left_mandible", class_5606.method_32108().method_32101(0, 45).method_32096().method_32097(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 1.0f), class_5603.method_32091((float)2.5f, (float)3.0f, (float)-5.0f, (float)MathUtils.radians(-45.0f), (float)0.0f, (float)MathUtils.radians(-30.0f)));
        dLowerLeftMandible.method_32117("lower_left_spike", class_5606.method_32108().method_32101(6, 45).method_32097(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), class_5603.method_32091((float)0.0f, (float)2.0f, (float)0.0f, (float)MathUtils.radians(-45.0f), (float)0.0f, (float)0.0f));
        class_5610 dLowerRightMandible = dHead.method_32117("lower_right_mandible", class_5606.method_32108().method_32101(0, 45).method_32096().method_32097(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 1.0f), class_5603.method_32091((float)-2.5f, (float)3.0f, (float)-5.0f, (float)MathUtils.radians(-45.0f), (float)0.0f, (float)MathUtils.radians(30.0f)));
        dLowerRightMandible.method_32117("lower_right_spike", class_5606.method_32108().method_32101(6, 45).method_32097(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), class_5603.method_32091((float)0.0f, (float)2.0f, (float)0.0f, (float)MathUtils.radians(-45.0f), (float)0.0f, (float)0.0f));
        class_5610 dTail0 = dBody.method_32117("tail_0", class_5606.method_32108().method_32101(0, 18).method_32098(-3.0f, -5.0f, 0.0f, 6.0f, 5.0f, 10.0f, new class_5605(0.02f)), class_5603.method_32090((float)0.0f, (float)-1.0f, (float)6.0f));
        class_5610 dTail1 = dTail0.method_32117("tail_1", class_5606.method_32108().method_32101(0, 18).method_32096().method_32098(-3.0f, -5.0f, 0.0f, 6.0f, 5.0f, 10.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)10.0f));
        class_5610 dTail2 = dTail1.method_32117("tail_2", class_5606.method_32108().method_32101(22, 23).method_32097(-3.0f, -4.0f, 0.0f, 6.0f, 4.0f, 10.0f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)10.0f));
        class_5610 dTail3 = dTail2.method_32117("tail_3", class_5606.method_32108().method_32101(34, 12).method_32097(-2.5f, -4.0f, 0.0f, 5.0f, 4.0f, 6.0f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)10.0f));
        dTail3.method_32117("tail_4", class_5606.method_32108().method_32101(0, 33).method_32097(-3.0f, -5.0f, 0.0f, 6.0f, 6.0f, 6.0f).method_32101(0, 0).method_32098(0.0f, -5.0f, 6.0f, 0.0f, 5.0f, 3.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)6.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    public void setAngles(ScorpionEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        AnimationUtils.rotateHead(headYaw, headPitch, this.head);
        this.shouldRender = !entity.method_6113();
        entity.buriedProgress.update(animationProgress);
        entity.swingProgress.update(animationProgress);
        this.root.field_3656 = 24.0f + entity.buriedProgress.getValue() * 32.0f;
        this.tail[0].field_3654 = MathUtils.radians(55.0f);
        this.tail[1].field_3654 = MathUtils.radians(30.0f);
        this.tail[2].field_3654 = MathUtils.radians(30.0f);
        this.tail[3].field_3654 = MathUtils.radians(45.0f);
        this.tail[4].field_3654 = MathUtils.radians(35.0f);
        for (int i = 0; i < 5; ++i) {
            float deltaPitch = class_3532.method_15374((float)(limbAngle * 0.5f)) * limbDistance;
            this.tail[i].field_3654 += deltaPitch * MathUtils.radians(5.0f);
            float deltaRoll = class_3532.method_15374((float)(limbAngle * 0.25f)) * limbDistance;
            this.tail[i].field_3674 = deltaRoll * MathUtils.radians(5.0f);
            this.tail[i].field_3675 = deltaRoll * MathUtils.radians(5.0f);
        }
        float deltaPivotY = class_3532.method_15374((float)(limbAngle * 0.5f)) * limbDistance * 3.0f;
        float deltaPivotZ = -class_3532.method_15362((float)(limbAngle * 0.5f)) * limbDistance * 2.0f;
        this.leftHindLeg.field_3656 = -9.0f - Math.max(0.0f, deltaPivotY);
        this.leftFrontLeg.field_3656 = this.rightHindLeg.field_3656 = -9.0f - Math.max(0.0f, -deltaPivotY);
        this.rightFrontLeg.field_3656 = this.leftHindLeg.field_3656;
        this.leftHindLeg.field_3655 = 5.5f - deltaPivotZ;
        this.rightHindLeg.field_3655 = 5.5f + deltaPivotZ;
        this.leftFrontLeg.field_3655 = -5.5f + deltaPivotZ;
        this.rightFrontLeg.field_3655 = -5.5f - deltaPivotZ;
        float swingProgress = entity.swingProgress.getValue();
        float shake = class_3532.method_15374((float)(animationProgress * 10.0f));
        this.body.field_3654 = MathUtils.lerp(0.0f, MathUtils.radians(-30.0f), swingProgress);
        this.head.field_3654 -= MathUtils.lerp(0.0f, MathUtils.radians(-30.0f + shake * 5.0f), swingProgress);
        for (int i = 0; i < 5; ++i) {
            class_630 part = this.tail[i];
            float target = i == 0 ? MathUtils.radians(30.0f) : MathUtils.radians(5.0f);
            part.field_3654 = MathUtils.lerp(part.field_3654, target, swingProgress);
        }
    }

    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        if (this.shouldRender) {
            this.root.method_22699(matrices, vertices, light, overlay, color);
        }
    }
}

