/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.book;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;

public class ReferenceListComponent
implements ICustomComponent {
    private IVariable content;
    private transient GuiBook bookGui = null;
    private final transient Map<Integer, String> titles = new HashMap<Integer, String>();
    private final transient List<class_2960> referencesList = new ArrayList<class_2960>();
    private static List<BookEntry> entries = new ArrayList<BookEntry>();
    private transient int y = 0;
    private transient int x = 0;
    private transient int pageNum = 0;
    private static final ArrayList<class_4185> buttons = new ArrayList();

    public void build(int componentX, int componentY, int pageNum) {
        entries.clear();
        this.y = componentY;
        this.x = componentX;
        this.pageNum = pageNum;
    }

    public void onDisplayed(IComponentRenderContext context) {
        if (context.getGui() instanceof GuiBook) {
            this.bookGui = (GuiBook)context.getGui();
        }
        entries = this.referencesList.stream().map(it -> (BookEntry)this.bookGui.book.getContents().entries.get(it)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        int buttonY = this.y + 5;
        for (int i = 0; i < entries.size(); ++i) {
            if (this.titles.get(i) != null) {
                buttonY += 20;
            }
            BookEntry entry = entries.get(i);
            GuiButtonEntry guiButton = new GuiButtonEntry(this.bookGui, this.x, buttonY, entry, button -> context.navigateToEntry(entry.getId(), 0, false));
            context.addWidget((class_339)guiButton, this.pageNum);
            buttons.add((class_4185)guiButton);
            buttonY += 10;
        }
    }

    public void render(class_332 graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        AtomicInteger spaceAtomic = new AtomicInteger(-3);
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.titles.forEach((key, value) -> {
            int space = spaceAtomic.getAndAdd(20);
            graphics.method_51439(textRenderer, (class_2561)class_2561.method_43471((String)value), this.x, this.y + space + key * 10, 0x404040, false);
        });
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, class_7225.class_7874 registries) {
        List<String> tempList = ((IVariable)lookup.apply(this.content)).asList(registries).stream().map(IVariable::asString).toList();
        int i = 0;
        for (String entry : tempList) {
            if (entry.startsWith("# ")) {
                this.titles.put(i, entry.substring(2));
                continue;
            }
            this.referencesList.add(class_2960.method_60654((String)entry));
            ++i;
        }
    }

    public static void clearButtons() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof GuiBook) {
            GuiBook book = (GuiBook)screen;
            book.removeDrawablesIn(buttons);
            buttons.clear();
        }
    }
}

