/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneVisibilities;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class EditWaystoneMessage
implements class_8710 {
    public static final class_8710.class_9154<EditWaystoneMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"waystones", (String)"edit_waystone"));
    private final UUID waystoneUid;
    private final String name;
    private final WaystoneVisibility visibility;

    public EditWaystoneMessage(UUID waystoneUid, String name, WaystoneVisibility visibility) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.visibility = visibility;
    }

    public static void encode(class_2540 buf, EditWaystoneMessage message) {
        buf.method_10797(message.waystoneUid);
        buf.method_10814(message.name);
        buf.method_10817((Enum)message.visibility);
    }

    public static EditWaystoneMessage decode(class_2540 buf) {
        UUID waystoneUid = buf.method_10790();
        String name = buf.method_10800(255);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.method_10818(WaystoneVisibility.class);
        return new EditWaystoneMessage(waystoneUid, name, visibility);
    }

    public static void handle(class_3222 player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.field_13995, message.waystoneUid);
        if (!waystone.isValid()) {
            Waystones.logger.warn("{} tried to edit an invalid waystone with id {}", (Object)player.method_5477().getString(), (Object)message.waystoneUid);
            return;
        }
        Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, waystone);
        if (error.isPresent()) {
            return;
        }
        WaystoneVisibility visibility = message.visibility;
        List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions(player, waystone);
        if (!visibilityOptions.contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.method_5477().getString(), (Object)message.visibility);
            visibility = visibilityOptions.getFirst();
        }
        if (!WaystonePermissionManager.isAllowedVisibility(visibility) && !WaystonePermissionManager.skipsPermissions(player)) {
            Waystones.logger.warn("{} tried to edit a restricted waystone without permission", (Object)player.method_5477().getString());
            return;
        }
        class_2338 pos = waystone.getPos();
        if (player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)) > 64.0) {
            return;
        }
        WaystoneImpl backingWaystone = (WaystoneImpl)waystone.getBackingWaystone();
        class_2561 legalName = EditWaystoneMessage.makeNameLegal(player.field_13995, message.name);
        backingWaystone.setName(legalName);
        if (visibility == WaystoneVisibility.GLOBAL && (WaystonePermissionManager.isAllowedVisibility(visibility) || WaystonePermissionManager.skipsPermissions(player)) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(player.field_13995, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        WaystoneManagerImpl.get(player.field_13995).method_80();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.field_13995, backingWaystone);
        player.method_7346();
    }

    private static class_2561 makeNameLegal(MinecraftServer server, String input) {
        if (input.trim().isEmpty()) {
            return class_2561.method_43471((String)"waystones.untitled_waystone");
        }
        String inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton;
        if (inventoryButtonMode.equals(input) && WaystoneManagerImpl.get(server).findWaystoneByName(input).isPresent()) {
            return class_2561.method_43470((String)(input + "*"));
        }
        return class_2561.method_43470((String)input);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

