/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bundleapi.item;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import com.github.theredbrain.bundleapi.item.tooltip.CustomBundleTooltipData;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_6862;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class CustomBundleItem
extends class_1792 {
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    public static final HashSet<CustomBundleItem> instances = new HashSet();
    private final class_6862<class_1792> tag;

    public CustomBundleItem(@Nullable class_6862<class_1792> tag, class_1792.class_1793 settings) {
        super(settings);
        this.tag = tag;
        instances.add(this);
    }

    public CustomBundleItem(class_1792.class_1793 settings) {
        this(null, settings);
    }

    public static float getAmountFilled(class_1799 stack) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57825(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.DEFAULT);
        return customBundleContentsComponent.getOccupancy().floatValue();
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        int i;
        if (clickType != class_5536.field_27014) {
            return false;
        }
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent == null) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        CustomBundleContentsComponent.Builder builder = new CustomBundleContentsComponent.Builder(customBundleContentsComponent);
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            class_1799 itemStack2 = builder.removeFirst();
            if (itemStack2 != null) {
                class_1799 itemStack3 = slot.method_32756(itemStack2);
                builder.add(itemStack3);
            }
        } else if (itemStack.method_7909().method_31568() && (this.tag == null || itemStack.method_31573(this.tag)) && (i = builder.add(slot, player)) > 0) {
            this.playInsertSound((class_1297)player);
        }
        stack.method_57379(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)builder.build());
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            int i;
            CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
            if (customBundleContentsComponent == null) {
                return false;
            }
            CustomBundleContentsComponent.Builder builder = new CustomBundleContentsComponent.Builder(customBundleContentsComponent);
            if (otherStack.method_7960()) {
                class_1799 itemStack = builder.removeFirst();
                if (itemStack != null) {
                    this.playRemoveOneSound((class_1297)player);
                    cursorStackReference.method_32332(itemStack);
                }
            } else if ((this.tag == null || otherStack.method_31573(this.tag)) && (i = builder.add(otherStack)) > 0) {
                this.playInsertSound((class_1297)player);
            }
            stack.method_57379(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)builder.build());
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (CustomBundleItem.dropAllBundledItems(itemStack, user)) {
            this.playDropContentsSound((class_1297)user);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public boolean method_31567(class_1799 stack) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57825(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.DEFAULT);
        return customBundleContentsComponent.getOccupancy().compareTo(Fraction.ZERO) > 0;
    }

    public int method_31569(class_1799 stack) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57825(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.DEFAULT);
        return Math.min(1 + class_3532.method_59515((Fraction)customBundleContentsComponent.getOccupancy(), (int)12), 13);
    }

    public int method_31571(class_1799 stack) {
        return ITEM_BAR_COLOR;
    }

    private static boolean dropAllBundledItems(class_1799 stack, class_1657 player) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null && !customBundleContentsComponent.isEmpty()) {
            stack.method_57379(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)new CustomBundleContentsComponent.Builder(customBundleContentsComponent).clear().build());
            if (player instanceof class_3222) {
                customBundleContentsComponent.iterateCopy().forEach(stackx -> player.method_7328(stackx, true));
            }
            return true;
        }
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return !stack.method_57826(class_9334.field_50074) && !stack.method_57826(class_9334.field_49638) ? Optional.ofNullable((CustomBundleContentsComponent)stack.method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT)).map(CustomBundleTooltipData::new) : Optional.empty();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null) {
            int bundleMaxSize = customBundleContentsComponent.sizeMultiplier() * 64;
            int i = class_3532.method_59515((Fraction)customBundleContentsComponent.getOccupancy(), (int)bundleMaxSize);
            tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, bundleMaxSize}).method_27692(class_124.field_1080));
        }
    }

    public void method_33261(class_1542 entity) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)entity.method_6983().method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null) {
            entity.method_6983().method_57379(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)new CustomBundleContentsComponent.Builder(customBundleContentsComponent).clear().build());
            class_5328.method_33263((class_1542)entity, customBundleContentsComponent.iterateCopy());
        }
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

