/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bundleapi.client.gui.tooltip;

import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import org.apache.commons.lang3.math.Fraction;

@Environment(value=EnvType.CLIENT)
public class CustomBundleTooltipComponent
implements class_5684 {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60656((String)"container/bundle/background");
    private static final int field_32381 = 4;
    private static final int field_32382 = 1;
    private static final int WIDTH_PER_COLUMN = 18;
    private static final int HEIGHT_PER_ROW = 20;
    private final CustomBundleContentsComponent customBundleContents;

    public CustomBundleTooltipComponent(CustomBundleContentsComponent customBundleContents) {
        this.customBundleContents = customBundleContents;
    }

    public int method_32661() {
        return this.getRowsHeight() + 4;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getColumnsWidth();
    }

    private int getColumnsWidth() {
        return this.getColumns() * 18 + 2;
    }

    private int getRowsHeight() {
        return this.getRows() * 20 + 2;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        int i = this.getColumns();
        int j = this.getRows();
        context.method_52706(BACKGROUND_TEXTURE, x, y, this.getColumnsWidth(), this.getRowsHeight());
        boolean bl = this.customBundleContents.getOccupancy().compareTo(Fraction.ONE) >= 0;
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int m = 0; m < i; ++m) {
                int n = x + m * 18 + 1;
                int o = y + l * 20 + 1;
                this.drawSlot(n, o, k++, bl, context, textRenderer);
            }
        }
    }

    private void drawSlot(int x, int y, int index, boolean shouldBlock, class_332 context, class_327 textRenderer) {
        if (index >= this.customBundleContents.size()) {
            this.draw(context, x, y, shouldBlock ? SlotSprite.BLOCKED_SLOT : SlotSprite.SLOT);
        } else {
            class_1799 itemStack = this.customBundleContents.get(index);
            this.draw(context, x, y, SlotSprite.SLOT);
            context.method_51428(itemStack, x + 1, y + 1, index);
            context.method_51431(textRenderer, itemStack, x + 1, y + 1);
            if (index == 0) {
                class_465.method_33285((class_332)context, (int)(x + 1), (int)(y + 1), (int)0);
            }
        }
    }

    private void draw(class_332 context, int x, int y, SlotSprite sprite) {
        context.method_52707(sprite.texture, x, y, 0, sprite.width, sprite.height);
    }

    private int getColumns() {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.customBundleContents.size() + 1.0)));
    }

    private int getRows() {
        return (int)Math.ceil(((double)this.customBundleContents.size() + 1.0) / (double)this.getColumns());
    }

    @Environment(value=EnvType.CLIENT)
    static enum SlotSprite {
        BLOCKED_SLOT(class_2960.method_60656((String)"container/bundle/blocked_slot"), 18, 20),
        SLOT(class_2960.method_60656((String)"container/bundle/slot"), 18, 20);

        public final class_2960 texture;
        public final int width;
        public final int height;

        private SlotSprite(class_2960 texture, int width, int height) {
            this.texture = texture;
            this.width = width;
            this.height = height;
        }
    }
}

