/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin;

import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.client.screens.OwoScreenHandler;
import io.wispforest.owo.client.screens.ScreenInternals;
import io.wispforest.owo.client.screens.ScreenhandlerMessageData;
import io.wispforest.owo.client.screens.SyncedProperty;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.pond.OwoScreenHandlerExtension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1703.class})
public abstract class ScreenHandlerMixin
implements OwoScreenHandler,
OwoScreenHandlerExtension {
    @Shadow
    private boolean field_29209;
    private final List<SyncedProperty<?>> owo$properties = new ArrayList();
    private final Map<Class<?>, ScreenhandlerMessageData<?>> owo$messages = new LinkedHashMap();
    private final List<ScreenhandlerMessageData<?>> owo$clientboundMessages = new ArrayList();
    private final List<ScreenhandlerMessageData<?>> owo$serverboundMessages = new ArrayList();
    private class_1657 owo$player = null;
    @Unique
    private ReflectiveEndecBuilder builder;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void createReflectiveBuilder(class_3917 type, int syncId, CallbackInfo ci) {
        this.builder = MinecraftEndecs.addDefaults(new ReflectiveEndecBuilder());
    }

    @Override
    public ReflectiveEndecBuilder endecBuilder() {
        return this.builder;
    }

    @Override
    public void owo$attachToPlayer(class_1657 player) {
        this.owo$player = player;
    }

    @Override
    public class_1657 player() {
        return this.owo$player;
    }

    @Override
    public <R extends Record> void addServerboundMessage(Class<R> messageClass, Endec<R> endec, Consumer<R> handler) {
        int id = this.owo$serverboundMessages.size();
        ScreenhandlerMessageData<R> messageData = new ScreenhandlerMessageData<R>(id, false, endec, handler);
        this.owo$serverboundMessages.add(messageData);
        if (this.owo$messages.put(messageClass, messageData) != null) {
            throw new NetworkException(String.valueOf(messageClass) + " is already registered as a message!");
        }
    }

    @Override
    public <R extends Record> void addClientboundMessage(Class<R> messageClass, Endec<R> endec, Consumer<R> handler) {
        int id = this.owo$clientboundMessages.size();
        ScreenhandlerMessageData<R> messageData = new ScreenhandlerMessageData<R>(id, true, endec, handler);
        this.owo$clientboundMessages.add(messageData);
        if (this.owo$messages.put(messageClass, messageData) != null) {
            throw new NetworkException(String.valueOf(messageClass) + " is already registered as a message!");
        }
    }

    @Override
    public <R extends Record> void sendMessage(@NotNull R message) {
        if (this.owo$player == null) {
            throw new NetworkException("Tried to send a message before player was attached");
        }
        ScreenhandlerMessageData<?> messageData = this.owo$messages.get(message.getClass());
        if (messageData == null) {
            throw new NetworkException("Tried to send message of unknown type " + String.valueOf(message.getClass()));
        }
        SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(this.owo$player.method_56673())});
        class_2540 buf = PacketByteBufs.create();
        buf.write(ctx, messageData.endec(), message);
        ScreenInternals.LocalPacket packet = new ScreenInternals.LocalPacket(messageData.id(), buf);
        if (messageData.clientbound()) {
            class_1657 class_16572 = this.owo$player;
            if (!(class_16572 instanceof class_3222)) {
                throw new NetworkException("Tried to send clientbound message on the server");
            }
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)packet);
        } else {
            if (!this.owo$player.method_37908().field_9236) {
                throw new NetworkException("Tried to send serverbound message on the client");
            }
            this.owo$sendToServer(packet);
        }
    }

    @Unique
    @Environment(value=EnvType.CLIENT)
    private void owo$sendToServer(class_8710 payload) {
        ClientPlayNetworking.send((class_8710)payload);
    }

    @Override
    public void owo$handlePacket(ScreenInternals.LocalPacket packet, boolean clientbound) {
        ScreenhandlerMessageData<?> messageData = (clientbound ? this.owo$clientboundMessages : this.owo$serverboundMessages).get(packet.packetId());
        SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(this.owo$player.method_56673())});
        messageData.handler().accept(packet.payload().read(ctx, messageData.endec()));
    }

    @Override
    public <T> SyncedProperty<T> createProperty(Class<T> clazz, Endec<T> endec, T initial) {
        SyncedProperty<T> prop = new SyncedProperty<T>(this.owo$properties.size(), endec, initial, (class_1703)this);
        this.owo$properties.add(prop);
        return prop;
    }

    @Override
    public void owo$readPropertySync(ScreenInternals.SyncPropertiesPacket packet) {
        int count = packet.payload().method_10816();
        for (int i = 0; i < count; ++i) {
            int idx = packet.payload().method_10816();
            this.owo$properties.get(idx).read(packet.payload());
        }
    }

    @Inject(method={"syncState"}, at={@At(value="RETURN")})
    private void syncOnSyncState(CallbackInfo ci) {
        this.syncProperties();
    }

    @Inject(method={"sendContentUpdates"}, at={@At(value="RETURN")})
    private void syncOnSendContentUpdates(CallbackInfo ci) {
        if (this.field_29209) {
            return;
        }
        this.syncProperties();
    }

    @Unique
    private void syncProperties() {
        if (this.owo$player == null) {
            return;
        }
        class_1657 class_16572 = this.owo$player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        int count = 0;
        for (SyncedProperty<?> property : this.owo$properties) {
            if (!property.needsSync()) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(count);
        for (SyncedProperty<?> prop : this.owo$properties) {
            if (!prop.needsSync()) continue;
            buf.method_10804(prop.index());
            prop.write(buf);
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ScreenInternals.SyncPropertiesPacket(buf));
    }
}

