/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.item.ScrollItem;
import net.spell_engine.item.SpellEngineItems;
import org.jetbrains.annotations.Nullable;

public class SpellBindRandomlyLootFunction
extends class_120 {
    public static final String NAME = "spell_bind_randomly";
    public static final class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_bind_randomly");
    public static final MapCodec<SpellBindRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SpellBindRandomlyLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.fieldOf("pool").orElse(null).forGetter(function -> function.pool), (App)class_5659.field_45888.fieldOf("tier").forGetter(function -> function.tier), (App)class_5659.field_45888.fieldOf("count").forGetter(function -> function.count))).apply((Applicative)instance, SpellBindRandomlyLootFunction::new));
    public static final class_5339<SpellBindRandomlyLootFunction> TYPE = new class_5339(CODEC);
    private final class_5658 tier;
    @Nullable
    private final String pool;
    @Nullable
    private final class_5658 count;

    private SpellBindRandomlyLootFunction(List<class_5341> conditions, String pool, class_5658 tier, class_5658 count) {
        super(conditions);
        this.pool = pool;
        this.tier = tier;
        this.count = count;
    }

    public class_5339<SpellBindRandomlyLootFunction> method_29321() {
        return TYPE;
    }

    public Set<class_169<?>> method_293() {
        return Set.of();
    }

    @Nullable
    class_6862<Spell> getSpellTag() {
        if (this.pool == null || this.pool.isEmpty()) {
            return null;
        }
        class_2960 id = this.pool.startsWith("#") ? class_2960.method_60654((String)this.pool.substring(1)) : class_2960.method_60654((String)this.pool);
        return class_6862.method_40092(SpellRegistry.KEY, (class_2960)id);
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        SpellContainer.ContentType selectedContentType;
        class_6862<Spell> spellTag = this.getSpellTag();
        int selectedTier = this.tier != null ? this.tier.method_366(context) : -1;
        SpellContainer existingContainer = SpellContainerHelper.containerFromItemStack(stack);
        List alreadyPresentSpells = existingContainer != null ? existingContainer.spell_ids().stream().map(class_2960::method_60654).toList() : List.of();
        List<class_6880.class_6883> spells = SpellRegistry.stream((class_1937)context.method_299()).filter(entry -> {
            class_2960 id = ((class_5321)entry.method_40230().get()).method_29177();
            return !(selectedTier >= 0 && ((Spell)entry.comp_349()).tier != selectedTier || spellTag != null && !entry.method_40220(spellTag) || alreadyPresentSpells.contains(id));
        }).toList();
        ArrayList<class_6880.class_6883> selectedSpells = new ArrayList<class_6880.class_6883>();
        SpellContainer.ContentType contentType = selectedContentType = existingContainer != null ? existingContainer.content() : null;
        if (!spells.isEmpty()) {
            int selectedCount = this.count != null ? this.count.method_366(context) : 1;
            int retryAttempts = 3;
            for (int i = 0; i < selectedCount; ++i) {
                class_6880.class_6883 entry2 = spells.get(context.method_294().method_43048(spells.size()));
                while (retryAttempts > 0 && (selectedSpells.contains(entry2) || selectedContentType != null && Objects.equals((Object)SpellContainerHelper.contentTypeForSpell((Spell)entry2.comp_349()), (Object)selectedContentType))) {
                    entry2 = spells.get(context.method_294().method_43048(spells.size()));
                    --retryAttempts;
                }
                selectedSpells.add(entry2);
                selectedContentType = SpellContainerHelper.contentTypeForSpell((Spell)entry2.comp_349());
            }
        }
        if (!selectedSpells.isEmpty()) {
            SpellContainer newContainer = existingContainer != null ? existingContainer : SpellContainer.EMPTY.withContentType(selectedContentType != null ? selectedContentType : SpellContainer.ContentType.MAGIC);
            List<String> newSpellIds = selectedSpells.stream().map(entry -> ((class_5321)entry.method_40230().get()).method_29177().toString()).toList();
            newContainer = newContainer.withAdditionalSpell(newSpellIds);
            List<String> sortedSpellIds = SpellContainerHelper.sortedSpells((class_1937)context.method_299(), newContainer.spell_ids());
            newContainer = newContainer.copyWith(sortedSpellIds);
            stack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)newContainer);
            if (stack.method_7909() == SpellEngineItems.SCROLL.method_15332()) {
                ScrollItem.onSpellAdded(stack, (class_6880<Spell>)((class_6880)selectedSpells.getFirst()), ScrollItem.resolveSpellPool((class_1937)context.method_299(), (class_6880<Spell>)((class_6880)selectedSpells.getFirst())));
            }
        } else if (stack.method_7909() == SpellEngineItems.SCROLL.method_15332()) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public static class_120.class_121<?> builder(String pool, class_5658 tier, class_5658 count) {
        return SpellBindRandomlyLootFunction.method_520(conditions -> new SpellBindRandomlyLootFunction((List<class_5341>)conditions, pool, tier, count));
    }
}

