/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.event.SpellEvents;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.compat.CriticalStrikeCompat;
import net.spell_engine.compat.MeleeCompat;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.casting.SpellBatcher;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.internals.delivery.SpellStashHelper;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.mixin.entity.LivingEntityAccessor;
import net.spell_engine.utils.ObjectHelper;
import net.spell_engine.utils.PatternMatching;
import net.spell_engine.utils.WorldScheduler;
import org.jetbrains.annotations.Nullable;

public class SpellTriggers {
    private static final Random random = new Random();

    public static void init() {
        CombatEvents.PLAYER_MELEE_ATTACK.register(args -> SpellTriggers.onMeleeImpact(args.player(), args.target()));
        CombatEvents.PLAYER_DAMAGE_TAKEN.register(args -> SpellTriggers.onDamageTaken(args.player(), args.source(), args.amount()));
        CombatEvents.PLAYER_DAMAGE_INCOMING.register(args -> SpellTriggers.onDamageIncoming(args.player(), args.source(), args.amount()));
        CombatEvents.PLAYER_SHIELD_BLOCK.register(args -> SpellTriggers.onShieldBlock(args.player(), args.source(), args.amount()));
        SpellEvents.SPELL_CAST.register(args -> SpellTriggers.onSpellCast(args.caster(), args.spell(), args.targets()));
        CombatEvents.ENTITY_EVASION.register(args -> SpellTriggers.onEvasion(args.entity(), args.damageAmount(), args.source()));
    }

    public static void onArrowShot(ArrowExtension arrow, class_1657 player, boolean firedBySpell) {
        Event event = new Event(Spell.Trigger.Type.ARROW_SHOT, player, (class_1297)player, null);
        event.arrow = arrow;
        event.arrowFiredBySpell = firedBySpell;
        SpellTriggers.fireTriggers(event);
    }

    public static void onArrowImpact(ArrowExtension arrow, class_1657 player, class_1297 target, class_1282 damageSource, float damageAmount) {
        Event event = new Event(Spell.Trigger.Type.ARROW_IMPACT, player, target, target);
        event.arrow = arrow;
        event.damageSource = damageSource;
        event.damageAmount = damageAmount;
        event.criticalImpact = CriticalStrikeCompat.isCriticalStrike(damageSource);
        SpellTriggers.fireTriggers(event);
    }

    public static void onMeleeImpact(class_1657 player, class_1297 target) {
        Event event = new Event(Spell.Trigger.Type.MELEE_IMPACT, player, target, target);
        if (target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            event.damageSource = ((LivingEntityAccessor)livingTarget).spellEngine_getLastDamageSource();
            event.damageAmount = ((LivingEntityAccessor)livingTarget).spellEngine_getLastDamageTaken();
            event.criticalImpact = CriticalStrikeCompat.isCriticalStrike(event.damageSource);
        }
        event.melee = MeleeCompat.attackProperties.apply(player);
        SpellTriggers.fireTriggers(event);
    }

    public static void onSpellImpactAny(class_1657 player, class_1297 target, class_1297 aoeSource, class_6880<Spell> spell) {
        Event event = new Event(Spell.Trigger.Type.SPELL_IMPACT_ANY, player, aoeSource, target);
        event.spell = spell;
        SpellTriggers.fireTriggers(event);
    }

    public static void onSpellImpactSpecific(class_1657 player, class_1297 target, class_6880<Spell> spell, Spell.Impact impact, boolean critical, Spell.Trigger.Stage stage) {
        Event event = new Event(Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC, player, target, target);
        event.spell = spell;
        event.impact = impact;
        event.criticalImpact = critical;
        event.stage = stage;
        SpellTriggers.fireTriggers(event);
    }

    public static void onSpellCast(class_1657 player, class_6880<Spell> spell, List<class_1297> targets) {
        class_1297 firstTarget = targets.isEmpty() ? null : targets.getFirst();
        class_1297 target = ObjectHelper.coalesce(firstTarget, player);
        Event event = new Event(Spell.Trigger.Type.SPELL_CAST, player, (class_1297)player, target);
        event.spell = spell;
        SpellTriggers.fireTriggers(event);
    }

    public static void onSpellAreaImpact(class_1657 player, @Nullable class_1297 target, class_243 location, class_6880<Spell> spell) {
        Event event = new Event(Spell.Trigger.Type.SPELL_AREA_IMPACT, player, target, target);
        event.location = location;
        event.spell = spell;
        SpellTriggers.fireTriggers(event);
    }

    public static void onEffectTick(class_1657 player, class_6880<class_1291> effect) {
        Event event = new Event(Spell.Trigger.Type.EFFECT_TICK, player, (class_1297)player, null);
        event.statusEffect = effect;
        SpellTriggers.fireTriggers(event);
    }

    public static void onDamageIncoming(class_1657 player, class_1282 source, float amount) {
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity == null) {
            return;
        }
        Event event = new Event(Spell.Trigger.Type.DAMAGE_TAKEN, player, (class_1297)player, sourceEntity);
        event.stage = Spell.Trigger.Stage.PRE;
        event.damageFatal = amount >= player.method_6032();
        event.damageSource = source;
        event.criticalImpact = CriticalStrikeCompat.isCriticalStrike(event.damageSource);
        event.damageAmount = amount;
        SpellTriggers.fireTriggers(event);
    }

    public static void onDamageTaken(class_1657 player, class_1282 source, float amount) {
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity == null) {
            return;
        }
        class_1297 aoeSourceEntity = ObjectHelper.coalesce(sourceEntity, player);
        Event event = new Event(Spell.Trigger.Type.DAMAGE_TAKEN, player, aoeSourceEntity, sourceEntity);
        event.damageSource = source;
        event.criticalImpact = CriticalStrikeCompat.isCriticalStrike(event.damageSource);
        event.damageAmount = amount;
        SpellTriggers.fireTriggers(event);
    }

    public static void onShieldBlock(class_1657 player, class_1282 source, float amount) {
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity == null) {
            return;
        }
        Event event = new Event(Spell.Trigger.Type.SHIELD_BLOCK, player, (class_1297)player, sourceEntity);
        event.damageSource = source;
        event.criticalImpact = CriticalStrikeCompat.isCriticalStrike(event.damageSource);
        event.damageAmount = amount;
        SpellTriggers.fireTriggers(event);
    }

    public static void onRoll(class_1657 player) {
        Event event = new Event(Spell.Trigger.Type.ROLL, player, (class_1297)player, null);
        SpellTriggers.fireTriggers(event);
    }

    public static void onEvasion(class_1309 entity, float damageAmount, class_1282 source) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity == null) {
            return;
        }
        Event event = new Event(Spell.Trigger.Type.EVASION, player, (class_1297)player, sourceEntity);
        event.damageSource = source;
        event.criticalImpact = CriticalStrikeCompat.isCriticalStrike(event.damageSource);
        event.damageAmount = damageAmount;
        SpellTriggers.fireTriggers(event);
    }

    private static void fireTriggers(Event event) {
        if (event.player.method_37908().method_8608()) {
            return;
        }
        SpellStashHelper.useStashes(event);
        class_1657 player = event.player;
        SpellCasterEntity caster = (SpellCasterEntity)player;
        block0: for (class_6880<Spell> spellEntry : SpellContainerSource.passiveSpellsOf(event.player)) {
            Spell spell = (Spell)spellEntry.comp_349();
            class_2960 spellId = ((class_5321)spellEntry.method_40230().get()).method_29177();
            if (spell.passive == null || caster.getCooldownManager().isCoolingDown(spellId)) continue;
            for (Spell.Trigger trigger : spell.passive.triggers) {
                SpellTarget.SearchResult targetResult;
                if (!SpellTriggers.evaluateTrigger(spellEntry, trigger, event)) continue;
                if (spell.target.type == Spell.Target.Type.FROM_TRIGGER) {
                    if (event.target == null && event.location != null) {
                        targetResult = SpellTarget.SearchResult.of(event.location);
                    } else {
                        List<class_1297> targets = List.of(event.target(trigger));
                        targetResult = SpellTarget.SearchResult.of(targets);
                    }
                } else {
                    targetResult = SpellTarget.findTargets(player, spellEntry, SpellTarget.SearchResult.empty(), true);
                }
                if (trigger.fire_delay > 0) {
                    ((WorldScheduler)player.method_37908()).schedule(trigger.fire_delay - 1, () -> SpellHelper.performSpell(player.method_37908(), player, spellEntry, targetResult, SpellCast.Action.TRIGGER, 1.0f));
                    continue block0;
                }
                SpellHelper.performSpell(player.method_37908(), player, spellEntry, targetResult, SpellCast.Action.TRIGGER, 1.0f);
                continue block0;
            }
        }
    }

    public static boolean evaluateTrigger(class_6880<Spell> spellEntry, Spell.Trigger trigger, Event event) {
        SpellContainer container;
        if (trigger.type != event.type) {
            return false;
        }
        if (trigger.stage != event.stage) {
            return false;
        }
        class_2960 spellId = ((class_5321)spellEntry.method_40230().get()).method_29177();
        int triggerCount = 0;
        if (trigger.cap_per_tick > 0) {
            triggerCount = ((SpellBatcher)event.player).getBatchTriggerCount(spellId);
            if (triggerCount >= trigger.cap_per_tick) {
                return false;
            }
            ++triggerCount;
        }
        if (trigger.chance < 1.0f) {
            float randomValue;
            if (trigger.chance_batching) {
                Float batchedChances = ((SpellBatcher)event.player).getBatchTriggerChance(spellId);
                if (batchedChances == null) {
                    randomValue = random.nextFloat();
                    ((SpellBatcher)event.player).batchTriggerChance(spellId, randomValue);
                } else {
                    randomValue = batchedChances.floatValue();
                }
            } else {
                randomValue = random.nextFloat();
            }
            if (randomValue > trigger.chance) {
                return false;
            }
        }
        if (trigger.caster_conditions != null) {
            for (Spell.TargetCondition condition : trigger.caster_conditions) {
                if (SpellTarget.evaluate((class_1297)event.player, event.target, condition)) continue;
                return false;
            }
        }
        if (event.target != null && trigger.target_conditions != null) {
            for (Spell.TargetCondition condition : trigger.target_conditions) {
                if (SpellTarget.evaluate(event.target, (class_1297)event.player, condition)) continue;
                return false;
            }
        }
        if (!(trigger.equipment_condition == null || (container = SpellContainerHelper.containerFromItemStack(event.player.method_6118(trigger.equipment_condition))) != null && container.contains(spellId))) {
            return false;
        }
        boolean result = switch (trigger.type) {
            case Spell.Trigger.Type.SPELL_CAST, Spell.Trigger.Type.SPELL_IMPACT_ANY, Spell.Trigger.Type.SPELL_AREA_IMPACT -> SpellTriggers.evaluateSpellCast(event.spell, trigger.spell) && SpellTriggers.evaluateDamage(trigger.damage, event);
            case Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC -> SpellTriggers.evaluateSpellCast(event.spell, trigger.spell) && SpellTriggers.evaluateSpellImpact(event.impact, event, trigger.impact) && SpellTriggers.evaluateDamage(trigger.damage, event);
            case Spell.Trigger.Type.ARROW_IMPACT, Spell.Trigger.Type.EVASION -> SpellTriggers.evaluateDamage(trigger.damage, event);
            case Spell.Trigger.Type.MELEE_IMPACT -> SpellTriggers.evaluateMelee(event.melee, trigger.melee) && SpellTriggers.evaluateDamage(trigger.damage, event);
            case Spell.Trigger.Type.EFFECT_TICK -> SpellTriggers.evaluateEffect(event, trigger.effect);
            case Spell.Trigger.Type.DAMAGE_TAKEN -> SpellTriggers.evaluateSpellImpact(null, event, trigger.impact) && SpellTriggers.evaluateDamage(trigger.damage, event);
            case Spell.Trigger.Type.ARROW_SHOT -> SpellTriggers.evaluateArrowShot(event, trigger.arrow_shot);
            case Spell.Trigger.Type.SHIELD_BLOCK, Spell.Trigger.Type.ROLL -> true;
            default -> true;
        };
        if (result && triggerCount > 0) {
            ((SpellBatcher)event.player).batchTriggerCount(spellId, triggerCount);
        }
        return result;
    }

    private static boolean evaluateSpellCast(@Nullable class_6880<Spell> spellEntry, @Nullable Spell.Trigger.SpellCondition condition) {
        if (condition == null) {
            return true;
        }
        if (spellEntry == null) {
            return false;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        if (condition.school != null && !PatternMatching.regexMatches(spell.school.id.toString(), condition.school.toLowerCase(Locale.ROOT))) {
            return false;
        }
        if (condition.id != null && !PatternMatching.matches(spellEntry, SpellRegistry.KEY, condition.id)) {
            return false;
        }
        if (condition.archetype != null && condition.archetype != spell.school.archetype) {
            return false;
        }
        if (condition.type != null && condition.type != spell.type) {
            return false;
        }
        return !(condition.cooldown_min > 0.0f) || spell.cost.cooldown != null && !(spell.cost.cooldown.duration < condition.cooldown_min);
    }

    private static boolean evaluateSpellImpact(@Nullable Spell.Impact impact, Event event, @Nullable Spell.Trigger.ImpactCondition condition) {
        if (condition == null) {
            return true;
        }
        if (impact == null) {
            return false;
        }
        if (condition.impact_type != null && !PatternMatching.regexMatches(condition.impact_type.toLowerCase(Locale.ROOT), impact.action.type.toString().toLowerCase(Locale.ROOT))) {
            return false;
        }
        return condition.critical == null || condition.critical == event.criticalImpact;
    }

    private static boolean evaluateDamage(@Nullable Spell.Trigger.DamageCondition condition, Event event) {
        if (condition == null) {
            return true;
        }
        if (condition.damage_type != null && event.damageSource != null && !PatternMatching.matches(event.damageSource.method_48793(), class_7924.field_42534, condition.damage_type)) {
            return false;
        }
        if (condition.amount_min != null && event.damageAmount < condition.amount_min.floatValue()) {
            return false;
        }
        if (condition.amount_max != null && event.damageAmount > condition.amount_max.floatValue()) {
            return false;
        }
        return condition.fatal == null || event.damageFatal == condition.fatal;
    }

    private static boolean evaluateMelee(@Nullable MeleeCompat.Attack melee, @Nullable Spell.Trigger.MeleeCondition condition) {
        if (condition == null) {
            return true;
        }
        if (melee == null) {
            return false;
        }
        if (condition.is_combo != null && melee.isCombo() != condition.is_combo.booleanValue()) {
            return false;
        }
        return condition.is_offhand == null || melee.isOffhand() == condition.is_offhand.booleanValue();
    }

    private static boolean evaluateEffect(Event event, Spell.Trigger.EffectCondition condition) {
        if (condition == null) {
            return true;
        }
        if (event.statusEffect == null) {
            return false;
        }
        Optional key = event.statusEffect.method_40230();
        return condition.id == null || !key.isPresent() || Objects.equals(((class_5321)key.get()).method_29177().toString(), condition.id);
    }

    private static boolean evaluateArrowShot(Event event, Spell.Trigger.ArrowShotCondition condition) {
        if (condition == null) {
            return true;
        }
        if (event.arrow == null) {
            return false;
        }
        return condition.from_spell == null || event.arrowFiredBySpell == condition.from_spell;
    }

    public static class Event {
        public final Spell.Trigger.Type type;
        public Spell.Trigger.Stage stage = Spell.Trigger.Stage.POST;
        public final class_1657 player;
        @Nullable
        private final class_1297 aoeSource;
        @Nullable
        private final class_1297 target;
        public ArrowExtension arrow;
        @Nullable
        private class_243 location;
        @Nullable
        public class_6880<Spell> spell;
        @Nullable
        public Spell.Impact impact;
        boolean criticalImpact = false;
        @Nullable
        public class_1282 damageSource;
        public float damageAmount = 0.0f;
        public boolean damageFatal = false;
        @Nullable
        public MeleeCompat.Attack melee;
        @Nullable
        public class_6880<class_1291> statusEffect;
        public boolean arrowFiredBySpell = false;

        public Event(Spell.Trigger.Type type, class_1657 player, @Nullable class_1297 aoeSource, @Nullable class_1297 target) {
            this.type = type;
            this.player = player;
            this.aoeSource = aoeSource;
            this.target = target;
        }

        private class_1297 entityFromSelector(Spell.Trigger.TargetSelector selector) {
            switch (selector) {
                case CASTER: {
                    return this.player;
                }
                case AOE_SOURCE: {
                    return this.aoeSource;
                }
                case TARGET: {
                    return this.target;
                }
            }
            return null;
        }

        public class_1297 target(Spell.Trigger trigger) {
            if (trigger.target_override != null) {
                return this.entityFromSelector(trigger.target_override);
            }
            return ObjectHelper.coalesce(this.target, this.aoeSource, this.player);
        }

        public class_1297 aoeSource(Spell.Trigger trigger) {
            if (trigger.aoe_source_override != null) {
                return this.entityFromSelector(trigger.aoe_source_override);
            }
            return ObjectHelper.coalesce(this.aoeSource, this.target, this.player);
        }
    }
}

