/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.casting.SpellCast;

public class HudMessages {
    public static final HudMessages INSTANCE = new HudMessages();
    public static final int DEFAULT_ERROR_MESSAGE_DURATION = 20;
    public static final int DEFAULT_ERROR_MESSAGE_FADEOUT = 10;
    private MessageState currentMessage;
    private static final String castAttemptPrefix = "hud.cast_attempt_error.";
    private boolean attemptDisplayed = false;

    public void castAttemptError(SpellCast.Attempt attempt) {
        if (this.attemptDisplayed) {
            return;
        }
        if (attempt.isSuccess() || attempt.isFail()) {
            this.attemptDisplayed = true;
        }
        if (!attempt.isFail() || !SpellEngineClient.config.showSpellCastErrors) {
            return;
        }
        String translationKey = castAttemptPrefix + attempt.result().toString().toLowerCase(Locale.ENGLISH);
        class_5250 message = null;
        switch (attempt.result()) {
            case MISSING_ITEM: {
                Ammo.Searched item = attempt.missingItem().item();
                if (item == null) break;
                String itemName = class_1074.method_4662((String)item.getTranslationKey(), (Object[])new Object[0]);
                message = class_2561.method_43469((String)translationKey, (Object[])new Object[]{itemName});
                break;
            }
            case ON_COOLDOWN: {
                message = class_2561.method_43471((String)translationKey);
            }
        }
        if (message != null) {
            this.error((class_2561)message.method_27692(class_124.field_1061));
        }
    }

    public void actionImpaired(EntityActionsAllowed.SemanticType reason) {
        this.error(class_1074.method_4662((String)("hud.action_impaired." + reason.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
    }

    public void error(String message) {
        this.error(message, 20, 10);
    }

    public void error(String message, int duration, int fadeOut) {
        this.currentMessage = MessageState.error(message, duration, fadeOut);
    }

    public void error(class_2561 text) {
        this.error(text, 20, 10);
    }

    public void error(class_2561 text, int duration, int fadeOut) {
        this.currentMessage = new MessageState(text, duration, fadeOut);
    }

    public void onCooldownsChanged(List<class_2960> before, List<class_2960> after) {
        List<class_2960> cooldownsRemoved = before.stream().filter(spellId -> !after.contains(spellId)).toList();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        if (cooldownsRemoved.isEmpty()) {
            return;
        }
        if (cooldownsRemoved.size() == 1) {
            class_2960 spellId2 = cooldownsRemoved.getFirst();
            class_6880.class_6883 spellEntry = SpellRegistry.from((class_1937)world).method_55841(spellId2).orElse(null);
            if (spellEntry == null) {
                return;
            }
            String spellName = SpellTooltip.spellTranslationKey(spellId2);
            this.info((class_2561)class_2561.method_43469((String)"hud.cooldown_cleared.single", (Object[])new Object[]{class_1074.method_4662((String)spellName, (Object[])new Object[0])}));
        } else {
            this.info((class_2561)class_2561.method_43471((String)"hud.cooldown_cleared.multiple"));
        }
    }

    public void info(class_2561 message) {
        this.info(message, 20, 10);
    }

    public void infoQuick(class_2561 message) {
        this.info(message, 10, 5);
    }

    public void info(class_2561 message, int duration, int fadeOut) {
        this.currentMessage = new MessageState(message, duration, fadeOut);
    }

    public void tick() {
        if (this.currentMessage != null) {
            if (this.currentMessage.durationLeft <= 0) {
                this.currentMessage = null;
            } else {
                --this.currentMessage.durationLeft;
            }
        }
        class_310 client = class_310.method_1551();
        if (!client.field_1690.field_1904.method_1434()) {
            this.attemptDisplayed = false;
        }
    }

    public MessageState currentError() {
        return this.currentMessage;
    }

    public static class MessageState {
        public class_2561 message;
        public int durationLeft;
        public int fadeOut;

        public MessageState(class_2561 message, int durationLeft, int fadeOut) {
            this.message = message;
            this.durationLeft = durationLeft;
            this.fadeOut = fadeOut;
        }

        public static MessageState error(String message, int durationLeft, int fadeOut) {
            return new MessageState((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061), durationLeft, fadeOut);
        }
    }
}

