/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.config.EffectConfig;

public class Effects {
    public static void register(List<Entry> entries, Map<String, EffectConfig> effects) {
        for (Entry entry : entries) {
            String key = entry.id.toString();
            EffectConfig current = effects.get(key);
            if (current != null) {
                entry.config = current;
            } else {
                effects.put(key, entry.config);
            }
            List<ConfigUtil.Entry> modifiers = ConfigUtil.modifiersFrom(entry.id, entry.config.attributes());
            for (ConfigUtil.Entry modifier : modifiers) {
                entry.effect.method_5566(modifier.attribute(), modifier.modifier().comp_2447(), modifier.modifier().comp_2449(), modifier.modifier().comp_2450());
            }
        }
        for (Entry entry : entries) {
            entry.entry = class_2378.method_47985((class_2378)class_7923.field_41174, (class_2960)entry.id, (Object)entry.effect);
        }
    }

    public static final class Entry {
        public final class_2960 id;
        public final String title;
        public final String description;
        public final class_1291 effect;
        public final EffectConfig defaults;
        public EffectConfig config;
        public class_6880<class_1291> entry;

        public Entry(class_2960 id, String title, String description, class_1291 effect) {
            this(id, title, description, effect, EffectConfig.EMPTY);
        }

        public Entry(class_2960 id, String title, String description, class_1291 effect, EffectConfig config) {
            this.id = id;
            this.title = title;
            this.description = description;
            this.effect = effect;
            this.defaults = config;
            this.config = config;
        }

        public EffectConfig config() {
            return this.config;
        }
    }
}

