/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.sound;

import absolutelyaya.formidulus.Formidulus;
import absolutelyaya.formidulus.entities.boss.BossType;
import absolutelyaya.formidulus.sound.BossMusicEntry;
import absolutelyaya.formidulus.sound.FadingMusicInstance;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class BossMusicHandler {
    static class_1144 manager;
    BossMusicEntry last;
    BossMusicEntry current;
    BossMusicEntry next;
    int introTicks;
    int outroTicks;
    int outroDelayTicks;
    boolean playIntro;
    boolean playOutro;
    boolean stopping;
    boolean late;
    boolean noOutro;
    boolean noFade;
    boolean startedOutro;
    List<class_1109> soundInstances = new ArrayList<class_1109>();
    FadingMusicInstance mainInstance;
    FadingMusicInstance introInstance;
    FadingMusicInstance outroInstance;

    public void startTrack(class_2960 bossId, String musicKey, boolean late) {
        this.late = late;
        if (late) {
            this.introTicks = 0;
        }
        try {
            BossType type = BossType.fromId(bossId);
            if (type == null) {
                return;
            }
            Object music = type.fight().getMethod("getMusicEntry", String.class).invoke(null, musicKey);
            if (music instanceof BossMusicEntry) {
                BossMusicEntry musicEntry = (BossMusicEntry)music;
                if (!musicEntry.equals(this.current)) {
                    this.next = musicEntry;
                }
            } else {
                Formidulus.LOGGER.warn("BossMusicHandler -> Received invalid musicKey; '{}' does not exist in '{}'s fight class!", (Object)musicKey, (Object)bossId);
            }
        }
        catch (NoSuchMethodException exception) {
            Formidulus.LOGGER.warn("BossMusicHandler -> Couldn't find 'getMusicEntry' in BossType '{}'s fight class!", (Object)bossId, (Object)exception);
        }
        catch (Exception exception) {
            Formidulus.LOGGER.warn("BossMusicHandler -> Something went wrong trying to get musicEntry from '{}'s fight class!", (Object)bossId, (Object)exception);
        }
    }

    public void stopCurrentTrack() {
        this.stopping = true;
    }

    public void stopCurrentTrackNoOutro() {
        this.stopping = true;
        this.noOutro = true;
    }

    public void stopCurrentTrackNoFade() {
        this.stopping = true;
        this.noFade = true;
        this.noOutro = false;
    }

    public void tick() {
        if (manager == null) {
            manager = class_310.method_1551().method_1483();
            return;
        }
        if (this.introTicks > 0) {
            --this.introTicks;
        }
        if (this.outroTicks > 0) {
            --this.outroTicks;
        }
        if (this.stopping && !this.playOutro) {
            if (!this.startedOutro) {
                if (this.mainInstance != null) {
                    if (this.noFade) {
                        this.mainInstance.stopImmediately();
                        this.noFade = false;
                    } else {
                        this.mainInstance.startFadeOut();
                    }
                }
                if (this.introTicks > 0) {
                    if (this.introInstance != null) {
                        if (this.noFade) {
                            this.introInstance.stopImmediately();
                            this.noFade = false;
                        } else {
                            this.introInstance.startFadeOut();
                        }
                    }
                    this.introTicks = 0;
                }
                this.startedOutro = true;
            }
            if (!this.noOutro && this.current != null && this.current.hasOutro()) {
                if (this.outroDelayTicks <= 0) {
                    this.playOutro = true;
                } else {
                    --this.outroDelayTicks;
                }
                return;
            }
            this.current = null;
            this.stopping = false;
            this.noOutro = false;
            return;
        }
        if (this.introTicks > 0) {
            if (this.next != null) {
                this.playIntro = false;
                this.introInstance.startFadeOut();
                this.introTicks = 0;
            }
            return;
        }
        if (this.outroTicks > 0) {
            return;
        }
        if (this.current != null) {
            if (this.playIntro) {
                if (this.next == null) {
                    this.mainInstance.startFadeIn();
                    manager.method_4873((class_1113)this.mainInstance);
                }
                this.playIntro = false;
                return;
            }
            if (this.playOutro) {
                this.outroInstance.setFullVolume();
                manager.method_4873((class_1113)this.outroInstance);
                this.outroTicks = this.current.outroTicks;
                this.playOutro = false;
                this.last = this.current;
                this.current = null;
                return;
            }
        }
        if (this.next != null) {
            if (this.playIntro) {
                this.playIntro = false;
            }
            this.current = this.next;
            this.mainInstance = new FadingMusicInstance(this.current.mainSound, this.current.fadeIn, this.current.fadeOut, true);
            this.next = null;
            if (!(!this.current.hasIntro() || this.current.skipIntroIfLate && this.late)) {
                this.introInstance = new FadingMusicInstance(this.current.introSound, 0.0f, this.current.fadeOut, false);
                this.introInstance.setFullVolume();
                manager.method_4873((class_1113)this.introInstance);
                this.introTicks = this.current.introTicks;
                this.playIntro = true;
            } else {
                this.mainInstance.startFadeIn();
                manager.method_4873((class_1113)this.mainInstance);
                if (this.late) {
                    this.late = false;
                }
            }
            if (this.current.hasOutro()) {
                this.outroInstance = new FadingMusicInstance(this.current.outroSound, this.current.fadeIn, 0.0f, false);
            }
            this.outroDelayTicks = this.current.outroDelayTicks;
            this.startedOutro = false;
        }
    }

    public void cancelAll() {
        this.stopCurrentTrackNoOutro();
        this.next = null;
        this.outroDelayTicks = 0;
    }

    public void stopAll() {
        this.soundInstances.forEach(arg_0 -> ((class_1144)manager).method_4870(arg_0));
        this.soundInstances.clear();
        this.next = null;
        this.current = null;
        this.last = null;
        this.outroDelayTicks = 0;
        this.outroTicks = 0;
        this.introTicks = 0;
    }

    public boolean isPlayingMusic() {
        return this.current != null || this.next != null;
    }
}

