/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.mixin;

import absolutelyaya.formidulus.accessor.LivingEntityAccessor;
import absolutelyaya.formidulus.compat.TrinketsUtil;
import absolutelyaya.formidulus.damage.DamageSources;
import absolutelyaya.formidulus.entities.BossEntity;
import absolutelyaya.formidulus.item.JollyHatItem;
import absolutelyaya.formidulus.item.components.AbilityComponent;
import absolutelyaya.formidulus.registries.DataComponentRegistry;
import absolutelyaya.formidulus.registries.ItemRegistry;
import absolutelyaya.formidulus.registries.StatusEffectRegistry;
import absolutelyaya.formidulus.registries.TagRegistry;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityAccessor {
    @Unique
    int bossImmunity;
    @Unique
    int soulImmunity;
    @Unique
    int shieldBreakImmunity;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    public abstract boolean method_5679(class_1282 var1);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @ModifyReturnValue(method={"isInvulnerableTo"}, at={@At(value="RETURN")})
    private boolean modifyIsInvulnerable(boolean original) {
        return original || this.method_6059(StatusEffectRegistry.REVERENCE);
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    void onDamage(class_1282 source, float amount, CallbackInfo ci) {
        class_1309 attacker;
        if (this.method_5679(source) || amount <= 0.0f) {
            return;
        }
        Object object = source.method_5529();
        if (object instanceof class_1309 && (object = (attacker = (class_1309)object).method_59958().method_57824(DataComponentRegistry.ABILITY)) instanceof AbilityComponent) {
            AbilityComponent component = (AbilityComponent)object;
            component.ability().onDamageEntity(attacker.method_59958(), attacker, source, amount, (class_1309)this);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    void onBaseTick(CallbackInfo ci) {
        if (this.bossImmunity > 0) {
            --this.bossImmunity;
        }
        if (this.soulImmunity > 0) {
            --this.soulImmunity;
        }
        if (this.shieldBreakImmunity > 0) {
            --this.shieldBreakImmunity;
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    void preDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_49708(DamageSources.SOUL) && this.method_5864().method_20210(TagRegistry.SOULLESS_MOBS)) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.shieldBreakImmunity > 0) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyExpressionValue(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageSource;isIn(Lnet/minecraft/registry/tag/TagKey;)Z", ordinal=4)})
    boolean modifyIgnoresCooldown(boolean original, @Local(argsOnly=true) class_1282 source) {
        return original || (source.method_5529() instanceof BossEntity || source.method_5526() instanceof BossEntity) && source.method_48789(TagRegistry.BOSS_DAMAGE) && this.bossImmunity <= 0 || source.method_48789(TagRegistry.SOUL_DAMAGE) && this.soulImmunity <= 0;
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    void modifyTimeUntilRegen(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1937 class_19372;
        if (source.method_48789(TagRegistry.SOUL_DAMAGE) && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_22246, this.method_23317(), this.method_5829().method_1005().field_1351, this.method_23321(), (int)(amount * 2.0f), (double)(this.method_17681() / 2.0f), (double)(this.method_17682() / 2.0f), (double)(this.method_17681() / 2.0f), (double)0.025f);
        }
    }

    @ModifyConstant(method={"damage"}, constant={@Constant(intValue=20)})
    int modifyTimeUntilRegen(int constant, @Local(argsOnly=true) class_1282 source) {
        if (source.method_48789(TagRegistry.BOSS_DAMAGE)) {
            this.bossImmunity = 10;
        }
        if (source.method_48789(TagRegistry.SOUL_DAMAGE)) {
            this.soulImmunity = 15;
        }
        return constant;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V")})
    void onDamageShield(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin;
        if (source.method_48789(TagRegistry.SHIELD_DISABLING_DAMAGE) && (livingEntityMixin = this) instanceof class_1657) {
            class_1657 player = (class_1657)livingEntityMixin;
            player.method_7284();
            this.shieldBreakImmunity = 5;
        }
    }

    @ModifyConstant(method={"onDamaged"}, constant={@Constant(intValue=20)})
    int modifyTimeUntilRegenOnDamaged(int constant, @Local(argsOnly=true) class_1282 source) {
        if (source.method_48789(TagRegistry.BOSS_DAMAGE)) {
            this.bossImmunity = 10;
        }
        if (source.method_48789(TagRegistry.SOUL_DAMAGE)) {
            this.soulImmunity = 15;
        }
        return constant;
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    void onTickMovement(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        if (this.method_37908().field_9236) {
            class_1799 head = this.method_6118(class_1304.field_6169);
            if (!TrinketsUtil.performIfPresent(self, ItemRegistry.JOLLY_HAT, i -> JollyHatItem.tickSnowfall(self, i)) && head.method_31574((class_1792)ItemRegistry.JOLLY_HAT)) {
                JollyHatItem.tickSnowfall(self, head);
            }
        }
    }

    @Override
    public void setBossImmunity(int bossImmunity) {
        this.bossImmunity = bossImmunity;
    }

    @Override
    public int getBossImmunity() {
        return this.bossImmunity;
    }

    @Override
    public void setSoulImmunity(int soulImmunity) {
        this.soulImmunity = soulImmunity;
    }

    @Override
    public int getSoulImmunity() {
        return this.soulImmunity;
    }

    @Override
    public void setShieldBreakImmunity(int shieldBreakImmunity) {
        this.shieldBreakImmunity = shieldBreakImmunity;
    }

    @Override
    public int getShieldBreakImmunity() {
        return this.shieldBreakImmunity;
    }
}

