/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.entities.goal;

import absolutelyaya.formidulus.entities.BossEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5575;

public class BossTargetGoal
extends class_1352 {
    final Class<class_1309>[] untargettableTypes;
    final BossEntity mob;
    final int switchInterval;
    final float range;
    final float switchChance;
    final Map<class_1309, Float> knownTargets = new HashMap<class_1309, Float>();
    int lastAttackedTime;
    int lastTargetDamagedTime;
    int targetSwitchTimer;
    class_1309 lastTarget;

    @SafeVarargs
    public BossTargetGoal(BossEntity mob, float range, int switchInterval, float switchChance, Class<class_1309> ... untargettableTypes) {
        this.mob = mob;
        this.untargettableTypes = untargettableTypes;
        this.range = range;
        this.switchInterval = switchInterval;
        this.switchChance = switchChance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        return true;
    }

    public void method_6268() {
        super.method_6268();
        this.validateTargetList();
        class_1309 curTarget = this.mob.method_5968();
        if (this.mob.method_6117() != this.lastAttackedTime) {
            this.targetSwitchTimer -= this.switchInterval / 3;
            this.lastAttackedTime = this.mob.method_6083();
            class_1309 lastAttacker = this.mob.method_49107();
            if (this.isTargetValid(lastAttacker)) {
                this.knownTargets.put(lastAttacker, Float.valueOf(this.knownTargets.containsKey(lastAttacker) ? this.knownTargets.get(lastAttacker).floatValue() + this.mob.getLastDamageTaken() : this.getStartPriority(lastAttacker)));
            }
        }
        if (this.mob.getLastTargetDamagedTime() != this.lastTargetDamagedTime) {
            this.lastTargetDamagedTime = this.mob.getLastTargetDamagedTime();
            this.targetSwitchTimer = Math.min(this.targetSwitchTimer + this.switchInterval / 6, this.switchInterval);
        }
        this.mob.method_37908().method_18023(class_5575.method_31795(class_1657.class), class_238.method_29968((class_243)this.mob.method_19538().method_1023(0.5, 0.5, 0.5)).method_1014((double)this.range), this::isTargetValid).forEach(p -> {
            if (!this.knownTargets.containsKey(p)) {
                this.knownTargets.put((class_1309)p, Float.valueOf(5.0f));
            }
        });
        if (curTarget != null) {
            if (!this.isTargetValid(curTarget)) {
                curTarget = null;
                this.mob.method_5980(null);
            } else if (!this.knownTargets.containsKey(curTarget)) {
                this.knownTargets.put(curTarget, Float.valueOf(this.getStartPriority(curTarget)));
            }
        }
        if (this.knownTargets.isEmpty()) {
            return;
        }
        --this.targetSwitchTimer;
        if (!this.isTargetValid(curTarget)) {
            this.mob.method_5980(this.getBestTarget());
            this.targetSwitchTimer = this.switchInterval;
        } else if (this.targetSwitchTimer <= 0) {
            if (this.mob.method_59922().method_43057() <= this.switchChance) {
                class_1309 bestTarget = this.getBestTarget();
                if (bestTarget != null && this.knownTargets.size() > 1 && bestTarget.equals((Object)this.lastTarget)) {
                    this.randomizeTarget();
                } else {
                    this.mob.method_5980(bestTarget);
                }
            }
            this.targetSwitchTimer = this.switchInterval;
        }
    }

    void validateTargetList() {
        ArrayList<class_1309> remove = new ArrayList<class_1309>();
        for (class_1309 living : this.knownTargets.keySet()) {
            if (this.isTargetValid(living)) continue;
            remove.add(living);
        }
        remove.forEach(this.knownTargets::remove);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isTargetValid(class_1309 living) {
        if (!this.mob.isTargetValid(living)) return false;
        if (!(living instanceof class_3222)) return true;
        class_3222 serverPlayer = (class_3222)living;
        if (this.mob.getBossFightInstance() == null) return false;
        if (!this.mob.getBossFightInstance().isParticipant(serverPlayer)) return false;
        return true;
    }

    float getStartPriority(class_1309 living) {
        return living instanceof class_1657 ? 5.0f : 0.0f;
    }

    class_1309 getBestTarget() {
        this.validateTargetList();
        if (this.knownTargets.size() == 1) {
            return this.knownTargets.keySet().toArray(new class_1309[0])[0];
        }
        float highestPriority = Float.MIN_VALUE;
        class_1309 bestTarget = null;
        for (class_1309 living : this.knownTargets.keySet()) {
            float priority;
            if (!this.isTargetValid(living) || !((priority = this.knownTargets.get(living).floatValue() - this.mob.method_5739((class_1297)living) * 0.25f) > highestPriority)) continue;
            highestPriority = priority;
            bestTarget = living;
        }
        return bestTarget;
    }

    public void randomizeTarget() {
        class_1309 target = this.getRandomTarget();
        this.mob.method_5980(target);
    }

    public class_1309 getRandomTarget() {
        List<class_1309> targets = this.getAllTargets();
        if (targets.isEmpty()) {
            return null;
        }
        return targets.get(this.mob.method_59922().method_43048(this.knownTargets.size()));
    }

    public List<class_1309> getAllTargets() {
        this.validateTargetList();
        return new ArrayList<class_1309>(this.knownTargets.keySet());
    }

    public boolean isHasNoTargets() {
        return this.getAllTargets().isEmpty();
    }
}

