/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.entities;

import absolutelyaya.formidulus.accessor.LivingEntityAccessor;
import absolutelyaya.formidulus.components.FormidableComponents;
import absolutelyaya.formidulus.components.entity.IBulwarkComponent;
import absolutelyaya.formidulus.entities.AnimatedEntity;
import absolutelyaya.formidulus.entities.AnimatedHostileEntity;
import absolutelyaya.formidulus.registries.EntityRegistry;
import absolutelyaya.formidulus.registries.SoundRegistry;
import absolutelyaya.formidulus.registries.TagRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class BulwarkEntity
extends AnimatedEntity {
    public static final class_2940<Optional<UUID>> OWNER = class_2945.method_12791(BulwarkEntity.class, (class_2941)class_2943.field_13313);
    public static final class_2940<Boolean> SMASH = class_2945.method_12791(BulwarkEntity.class, (class_2941)class_2943.field_13323);
    public class_7094 prePlaceAnimationState = new class_7094();
    public class_7094 placeAnimationState = new class_7094();
    public class_7094 hitAnimationState = new class_7094();
    public class_7094 removeAnimationState = new class_7094();
    static final byte PREPLACE_ANIM = 0;
    static final byte PLACE_ANIM = 1;
    static final byte HIT_ANIM = 2;
    static final byte REMOVE_ANIM = 3;

    public BulwarkEntity(class_1299<? extends AnimatedEntity> type, class_1937 world) {
        super(type, world);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OWNER, Optional.empty());
        builder.method_56912(SMASH, (Object)false);
    }

    public static BulwarkEntity place(class_1657 owner) {
        if (owner == null || !owner.method_5805()) {
            return null;
        }
        BulwarkEntity bulwark = new BulwarkEntity((class_1299<? extends AnimatedEntity>)EntityRegistry.BULWARK, owner.method_37908());
        bulwark.setOwner(owner);
        bulwark.method_33574(owner.method_19538().method_1019(owner.method_5720().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)0.4f)));
        bulwark.method_36456(owner.method_36454());
        owner.method_37908().method_8649((class_1297)bulwark);
        bulwark.method_36456(owner.method_36454());
        bulwark.method_5847(owner.method_36454());
        bulwark.method_5636(owner.method_36454());
        bulwark.setAnimation((byte)0);
        if (!owner.method_24828()) {
            bulwark.field_6011.method_12778(SMASH, (Object)true);
        }
        return bulwark;
    }

    public void setOwner(class_1657 owner) {
        if (owner == null) {
            this.field_6011.method_12778(OWNER, Optional.empty());
        } else {
            this.field_6011.method_12778(OWNER, Optional.of(owner.method_5667()));
        }
    }

    public class_1657 getOwner() {
        if (((Optional)this.field_6011.method_12789(OWNER)).isEmpty()) {
            return null;
        }
        return this.method_37908().method_18470((UUID)((Optional)this.field_6011.method_12789(OWNER)).get());
    }

    @Override
    @Nullable
    protected class_7094 getAnimationState(byte id) {
        return switch (id) {
            case 0 -> this.prePlaceAnimationState;
            case 1 -> this.placeAnimationState;
            case 2 -> this.hitAnimationState;
            case 3 -> this.removeAnimationState;
            default -> null;
        };
    }

    public boolean method_33190() {
        return this.getCurrentAnimation() == 2 || this.getCurrentAnimation() == 1 && this.getCurrentAnimationDuration() > 0.35f;
    }

    public void method_5697(class_1297 entity) {
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_5632(double x, double y, double z) {
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    public void method_6005(double strength, double x, double z) {
    }

    public int method_5669() {
        return 20;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42337)) {
            return super.method_5643(source, amount);
        }
        return false;
    }

    public void redirectDamage(class_1282 source, float amount) {
        boolean b = super.method_5643(source, amount);
        if (b) {
            if (this.method_6032() <= 0.0f) {
                this.setAnimation((byte)3);
                class_1657 owner = this.getOwner();
                if (owner instanceof LivingEntityAccessor) {
                    LivingEntityAccessor living = (LivingEntityAccessor)owner;
                    living.setShieldBreakImmunity(5);
                }
                IBulwarkComponent comp = (IBulwarkComponent)FormidableComponents.BULWARK.get((Object)owner);
                comp.onBulwarkBreak();
                this.method_5783(SoundRegistry.BULWARK_BREAK, 1.0f, 0.8f);
            } else {
                this.setAnimation((byte)2);
            }
        }
    }

    public boolean method_5863() {
        return false;
    }

    protected void method_6013(class_1282 damageSource) {
        this.method_5783(SoundRegistry.BULWARK_BLOCK, 1.0f, 0.8f);
    }

    protected void method_6108() {
    }

    public void method_18799(class_243 velocity) {
    }

    public void method_5773() {
        class_1657 owner;
        block16: {
            block17: {
                super.method_5773();
                if (!this.method_37908().field_9236 && this.getOwner() != null && this.getOwner().method_24828() && this.getCurrentAnimation() == 0 && this.getCurrentAnimationDuration() > 0.25f) {
                    this.setAnimation((byte)1);
                }
                this.method_18799(class_243.field_1353);
                if (this.method_31481()) {
                    return;
                }
                if (this.getCurrentAnimation() == 3) {
                    if (this.getCurrentAnimationDuration() > 0.75f) {
                        this.method_31472();
                    }
                    return;
                }
                if (this.method_31481()) {
                    return;
                }
                if (((Optional)this.field_6011.method_12789(OWNER)).isEmpty()) {
                    this.setAnimation((byte)3);
                    return;
                }
                owner = this.method_37908().method_18470((UUID)((Optional)this.field_6011.method_12789(OWNER)).get());
                if (this.method_37908().field_9236) break block16;
                if (owner == null || !owner.method_5805()) break block17;
                class_241 class_2412 = new class_241((float)this.method_23317(), (float)this.method_23321());
                class_241 class_2413 = new class_241((float)owner.method_23317(), (float)owner.method_23321());
                if (!(class_2412.method_35589(class_2413) > 1.0f)) break block16;
            }
            this.setAnimation((byte)3);
        }
        if (this.getCurrentAnimation() == 1 && this.getCurrentAnimationDuration() >= 0.1f && !this.getAnimationFlag(0)) {
            if (!((Boolean)this.field_6011.method_12789(SMASH)).booleanValue()) {
                this.method_5783(SoundRegistry.BULWARK_PLACE, 1.0f, 0.9f);
                for (int i2 = 0; i2 < 16; ++i2) {
                    class_243 ppos = this.method_19538().method_1019(class_243.field_1353.method_49272(this.field_5974, 1.25f).method_18805(1.0, 0.0, 1.0));
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, this.method_37908().method_8320(class_2338.method_49638((class_2374)ppos).method_10074())), ppos.field_1352, ppos.field_1351, ppos.field_1350, 0.0, 0.0, 0.0);
                }
            } else {
                this.method_5783(SoundRegistry.BULWARK_SMASH, 1.0f, 0.9f);
                for (int i3 = 0; i3 < 32; ++i3) {
                    class_243 ppos = this.method_19538().method_1019(class_243.field_1353.method_49272(this.field_5974, 2.0f).method_18805(1.0, 0.0, 1.0));
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_50248, this.method_37908().method_8320(class_2338.method_49638((class_2374)ppos).method_10074())), ppos.field_1352, ppos.field_1351, ppos.field_1350, 0.0, (double)0.33f, 0.0);
                }
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_18023(class_5575.method_31795(class_1309.class), this.method_5829().method_1009(3.0, 1.0, 3.0), i -> i.method_33190() && !i.equals((Object)owner) && !i.equals((Object)this)).forEach(living -> {
                        class_243 dir = living.method_19538().method_1020(this.method_19538()).method_18805(1.0, 0.0, 1.0).method_1029();
                        living.method_60491(dir.method_1021(2.0).method_1031(0.0, (double)0.2f, 0.0).method_1021(Math.max(1.0 - living.method_45325(class_5134.field_23718) - this.method_19538().method_18805(1.0, 0.0, 1.0).method_1022(living.method_19538().method_18805(1.0, 0.0, 1.0)) / 4.0, 0.0)));
                        if (owner != null) {
                            living.method_6015((class_1309)owner);
                        }
                    });
                }
            }
            this.setAnimationFlag(0, true);
        }
        if (owner != null) {
            this.method_5814(owner.method_23317(), owner.method_23318(), owner.method_23321());
        }
    }

    public boolean tryBlockDamage(class_1282 source, float amount) {
        class_1297 src;
        if (!this.method_33190()) {
            return false;
        }
        if (source.method_48789(TagRegistry.BULWARK_UNBLOCKABLE_DAMAGE)) {
            return false;
        }
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1297 && this.tryBlockDamage(src = class_12972, source, amount)) {
            return true;
        }
        class_12972 = source.method_5529();
        return class_12972 instanceof class_1297 && this.tryBlockDamage(src = class_12972, source, amount);
    }

    public boolean tryBlockDamage(class_1297 sourceEntity, class_1282 source, float amount) {
        if (this.isPosInFront(sourceEntity.method_19538()) && !source.method_48789(TagRegistry.BULWARK_UNBLOCKABLE_DAMAGE)) {
            this.redirectDamage(source, amount);
            if (sourceEntity instanceof AnimatedHostileEntity) {
                AnimatedHostileEntity entity = (AnimatedHostileEntity)sourceEntity;
                entity.tryInterruptActiveGoals((byte)100);
            }
            return true;
        }
        return false;
    }

    public boolean isPosInFront(class_243 pos) {
        float angle = this.getRelativeHorizontalAngleTo(this.method_19538(), pos, this.method_5720());
        return angle > 0.3f;
    }
}

