/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.entities;

import absolutelyaya.formidulus.entities.AnimatedHostileEntity;
import absolutelyaya.formidulus.entities.boss.BossFight;
import absolutelyaya.formidulus.entities.boss.BossType;
import absolutelyaya.formidulus.entities.goal.BossOutOfCombatGoal;
import absolutelyaya.formidulus.entities.goal.BossTargetGoal;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public abstract class BossEntity
extends AnimatedHostileEntity {
    public static final class_2940<class_2338> ORIGIN = class_2945.method_12791(BossEntity.class, (class_2941)class_2943.field_13324);
    protected class_3213 bossBar;
    boolean wasBossbarVisible;
    boolean shouldUpdateBossbar = true;
    float lastDamageTakenRaw;
    float lastDamageTaken;
    int lastTargetDamagedTime;
    int combatTimer;
    BossTargetGoal targetGoal;
    BossOutOfCombatGoal outOfCombatGoal;
    BossFight bossFight;
    BossType type;

    protected BossEntity(class_1299<? extends AnimatedHostileEntity> entityType, class_1937 world, BossType type) {
        super(entityType, world);
        this.type = type;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ORIGIN, (Object)this.method_24515());
    }

    protected class_3213 initBossBar() {
        return new class_3213(this.method_5476(), class_1259.class_1260.field_5784, this.getBossBarStyle());
    }

    abstract class_1259.class_1261 getBossBarStyle();

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (this.isBossBarVisible()) {
            this.bossBar.method_5413(this.method_5476());
        }
    }

    public boolean isBossBarVisible() {
        if (this.bossBar == null) {
            this.bossBar = this.initBossBar();
        }
        return true;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        if (this.isBossBarVisible()) {
            this.bossBar.method_14088(player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        if (this.isBossBarVisible()) {
            this.bossBar.method_14089(player);
        }
    }

    protected void method_5958() {
        class_1309 living;
        super.method_5958();
        if (this.isBossBarVisible() && this.shouldUpdateBossbar) {
            this.bossBar.method_5408(this.method_6032() / this.method_6063());
        }
        if (this.method_37908().field_9236) {
            return;
        }
        class_1309 class_13092 = this.method_5968();
        if (class_13092 instanceof class_1309 && (living = class_13092).method_5805() && !living.method_31481()) {
            this.combatTimer = 10;
        } else if (this.combatTimer > 0) {
            --this.combatTimer;
        }
        if (((class_2338)this.field_6011.method_12789(ORIGIN)).equals((Object)class_2338.field_10980)) {
            this.field_6011.method_12778(ORIGIN, (Object)this.method_24515());
        }
        if (this.wasBossbarVisible && !this.isBossBarVisible()) {
            this.bossBar.method_14094();
        } else if (!this.wasBossbarVisible && this.isBossBarVisible()) {
            this.method_37908().method_18023(class_5575.method_31795(class_1657.class), this.method_5829().method_1014(64.0), p -> true).forEach(p -> this.bossBar.method_14088((class_3222)p));
        }
        this.wasBossbarVisible = this.isBossBarVisible();
    }

    public boolean method_17326() {
        return true;
    }

    abstract boolean isInSequence();

    public class_243 getFocusPos() {
        return this.method_33571().method_1023(0.0, 0.5, 0.0);
    }

    public float getLastDamageTakenRaw() {
        return this.lastDamageTakenRaw;
    }

    public float getLastDamageTaken() {
        return this.lastDamageTaken;
    }

    public int getLastTargetDamagedTime() {
        return this.lastTargetDamagedTime;
    }

    @Nullable
    public class_1309 getRandomTarget() {
        if (this.targetGoal != null) {
            return this.targetGoal.getRandomTarget();
        }
        return null;
    }

    public List<class_1309> getAllTargets() {
        if (this.targetGoal != null) {
            return this.targetGoal.getAllTargets();
        }
        return List.of();
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean b = super.method_5643(source, amount);
        if (b) {
            this.lastDamageTakenRaw = amount;
            this.lastDamageTaken = this.method_6132(source, amount);
        }
        return b;
    }

    @Override
    public void onDamageEntity(class_1309 damaged) {
        if (damaged.equals((Object)this.method_5968())) {
            this.lastTargetDamagedTime = this.field_6012;
        }
    }

    public boolean isInCombat() {
        return this.combatTimer > 0;
    }

    public abstract void beforeBossReset();

    public abstract void afterBossReset();

    public abstract BossType getBossType();

    public abstract boolean isActive();

    public class_2338 getOriginBlock() {
        return (class_2338)this.field_6011.method_12789(ORIGIN);
    }

    public class_243 getOriginBlockMinCorner() {
        class_2338 pos = this.getOriginBlock();
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public void setOriginBlock(class_2338 pos) {
        this.field_6011.method_12778(ORIGIN, (Object)pos);
    }

    protected void beginFight() {
        this.bossFight = this.type.beginFight(this, this.getFightId());
    }

    public UUID getFightId() {
        if (this.bossFight == null) {
            return null;
        }
        return this.bossFight.getFightID();
    }

    public BossFight getBossFightInstance() {
        return this.bossFight;
    }

    public void forceReset() {
        this.forceStopActiveGoals();
        if (this.outOfCombatGoal != null) {
            this.outOfCombatGoal.method_6269();
        }
    }

    abstract int getFightPhase();

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Origin", 4)) {
            this.field_6011.method_12778(ORIGIN, (Object)class_2338.method_10092((long)nbt.method_10537("Origin")));
        }
        if (nbt.method_10573("CombatTimer", 3)) {
            this.combatTimer = nbt.method_10550("CombatTimer");
        }
        if (nbt.method_25928("FightId") && (this.bossFight == null || this.bossFight.hasEnded())) {
            this.bossFight = this.type.beginFight(this, nbt.method_25926("FightId"));
        } else if (this.getFightPhase() >= 0 && (this.bossFight == null || this.bossFight.hasEnded())) {
            this.beginFight();
            this.bossFight.setPhase(this.getFightPhase());
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (!((class_2338)this.field_6011.method_12789(ORIGIN)).equals((Object)class_2338.field_10980)) {
            nbt.method_10544("Origin", ((class_2338)this.field_6011.method_12789(ORIGIN)).method_10063());
        }
        if (this.isInCombat()) {
            nbt.method_10569("CombatTimer", this.combatTimer);
        }
        if (this.bossFight != null) {
            nbt.method_25927("FightId", this.bossFight.getFightID());
        }
    }
}

