/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.entities;

import absolutelyaya.formidulus.entities.goal.InterruptableGoal;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_7094;

public abstract class AnimatedHostileEntity
extends class_1588 {
    static final class_2940<Byte> ANIMATION = class_2945.method_12791(AnimatedHostileEntity.class, (class_2941)class_2943.field_13319);
    static final class_2940<Integer> ANIMATION_START = class_2945.method_12791(AnimatedHostileEntity.class, (class_2941)class_2943.field_13327);
    static final class_2940<Integer> ATTACK_COOLDOWN = class_2945.method_12791(AnimatedHostileEntity.class, (class_2941)class_2943.field_13327);
    byte lastAnimation;
    int animFlags;

    protected AnimatedHostileEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANIMATION, (Object)0);
        builder.method_56912(ANIMATION_START, (Object)0);
        builder.method_56912(ATTACK_COOLDOWN, (Object)0);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (this.method_37908().field_9236) {
            if (data.equals(ANIMATION_START)) {
                this.field_6012 = (Integer)this.field_6011.method_12789(ANIMATION_START);
            }
            if (data.equals(ANIMATION)) {
                this.setAnimation((Byte)this.field_6011.method_12789(ANIMATION));
            }
        }
    }

    public void setAnimation(byte id) {
        class_7094 class_70942;
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(ANIMATION_START, (Object)this.field_6012);
            this.field_6011.method_12778(ANIMATION, (Object)id);
        }
        if ((class_70942 = this.getAnimationState(this.lastAnimation)) instanceof class_7094) {
            class_7094 lastState = class_70942;
            lastState.method_41325();
        }
        if ((class_70942 = this.getAnimationState(id)) instanceof class_7094) {
            class_7094 newState = class_70942;
            newState.method_41322(this.field_6012);
        }
        this.lastAnimation = id;
        this.animFlags = 0;
    }

    public byte getCurrentAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public float getCurrentAnimationDuration() {
        return (float)(this.field_6012 - (Integer)this.field_6011.method_12789(ANIMATION_START)) / 20.0f;
    }

    abstract class_7094 getAnimationState(byte var1);

    protected void setAnimationFlag(int idx, boolean state) {
        this.animFlags = state ? (this.animFlags |= 1 << idx) : (this.animFlags &= ~(1 << idx));
    }

    protected boolean getAnimationFlag(int idx) {
        return (this.animFlags >> idx & 1) == 1;
    }

    public void setAttackCooldown(int cooldown) {
        this.field_6011.method_12778(ATTACK_COOLDOWN, (Object)Math.max(cooldown, 0));
    }

    public boolean isReadyToAttack() {
        return (Integer)this.field_6011.method_12789(ATTACK_COOLDOWN) <= 0 && this.isTargetValid() && this.isNotInAttackAnimation();
    }

    public void method_5773() {
        super.method_5773();
        if (this.isTargetValid()) {
            int cd = (Integer)this.field_6011.method_12789(ATTACK_COOLDOWN);
            if (cd > 0) {
                this.field_6011.method_12778(ATTACK_COOLDOWN, (Object)(cd - 1));
            }
        } else if (this.method_5968() != null) {
            this.method_5980(null);
        }
    }

    protected void forceStopActiveGoals() {
        this.field_6189.method_6340();
        this.field_6201.method_35115().forEach(i -> {
            class_1352 patt0$temp = i.method_19058();
            if (patt0$temp instanceof InterruptableGoal) {
                InterruptableGoal animated = (InterruptableGoal)patt0$temp;
                if (i.method_19056()) {
                    animated.forceStop();
                }
            }
        });
    }

    public void tryInterruptActiveGoals(byte reason) {
        this.field_6201.method_35115().forEach(i -> {
            class_1352 patt0$temp = i.method_19058();
            if (patt0$temp instanceof InterruptableGoal) {
                InterruptableGoal interruptable = (InterruptableGoal)patt0$temp;
                if (i.method_19056()) {
                    interruptable.interrupt(reason);
                }
            }
        });
    }

    public abstract boolean isNotInAttackAnimation();

    protected float getHealthPercent() {
        return this.method_6032() / this.method_6063();
    }

    public float getHorizontalDistanceToTarget() {
        return this.getHorizontalDistanceTo(this.method_5968());
    }

    public float getHorizontalDistanceTo(class_243 pos, class_1309 target) {
        if (!this.isTargetValid(target) || target == null) {
            return Float.MAX_VALUE;
        }
        return (float)pos.method_18805(1.0, 0.0, 1.0).method_1022(target.method_19538().method_18805(1.0, 0.0, 1.0));
    }

    public float getHorizontalDistanceTo(class_1309 target) {
        return this.getHorizontalDistanceTo(this.method_19538(), target);
    }

    public boolean isTargetValid(class_1309 target) {
        class_1657 player;
        if (target instanceof class_1657 && (player = (class_1657)target).method_7337()) {
            return false;
        }
        return target != null && !target.method_29504() && !target.method_31481() && !target.method_7325() && target.method_33190();
    }

    public boolean isTargetValid() {
        return this.isTargetValid(this.method_5968());
    }

    public float getRelativeHorizontalAngleTo(class_243 pos, class_1309 target, class_243 forward) {
        if (!this.isTargetValid(target) || target == null) {
            return 0.0f;
        }
        class_243 targetDir = target.method_19538().method_18805(1.0, 0.0, 1.0).method_1020(pos.method_18805(1.0, 0.0, 1.0)).method_1029();
        forward = forward.method_18805(1.0, 0.0, 1.0).method_1029();
        return (float)Math.acos(targetDir.method_1026(forward));
    }

    public float getRelativeHorizontalAngleTo(class_1309 target, class_243 forward) {
        return this.getRelativeHorizontalAngleTo(this.method_19538(), target, forward);
    }

    public float getRelativeHorizontalAngleTo(class_1309 target) {
        return this.getRelativeHorizontalAngleTo(target, this.method_5720());
    }

    public float getRelativeHorizontalTargetAngle() {
        return this.getRelativeHorizontalAngleTo(this.method_5968());
    }

    public int applyDamageInCylindricArea(float radius, float height, float maxAngle, class_1282 source, float amount, class_243 angleCheckFowards, class_243 offset, BiConsumer<class_1309, Boolean> extraProcess) {
        int successfulHits = 0;
        class_238 area = this.box(this.method_19538()).method_1009((double)radius, 0.0, (double)radius).method_1012(0.0, (double)height, 0.0).method_997(offset);
        List hits = this.method_37908().method_18467(class_1309.class, area);
        for (class_1309 hit : hits) {
            if (this.getIgnoredClasses().contains(hit.getClass()) || this.getHorizontalDistanceTo(this.method_19538().method_1019(offset), hit) > radius || (double)this.getRelativeHorizontalAngleTo(this.method_19538().method_1019(offset), hit, angleCheckFowards) > Math.toRadians(maxAngle)) continue;
            boolean success = hit.method_5643(source, amount);
            extraProcess.accept(hit, success);
            if (!success) continue;
            ++successfulHits;
            this.onDamageEntity(hit);
        }
        return successfulHits;
    }

    public int applyDamageInCylindricArea(float radius, float height, float maxAngle, class_1282 source, float amount, class_243 angleCheckFowards, BiConsumer<class_1309, Boolean> extraProcess) {
        return this.applyDamageInCylindricArea(radius, height, maxAngle, source, amount, angleCheckFowards, class_243.field_1353, extraProcess);
    }

    public int applyDamageInCylindricArea(float radius, float height, float maxAngle, class_1282 source, float amount, BiConsumer<class_1309, Boolean> extraProcess) {
        return this.applyDamageInCylindricArea(radius, height, maxAngle, source, amount, this.method_5720(), class_243.field_1353, extraProcess);
    }

    public int applyDamageInCylindricArea(float radius, float height, class_1282 source, float amount, BiConsumer<class_1309, Boolean> extraProcess) {
        return this.applyDamageInCylindricArea(radius, height, 360.0f, source, amount, extraProcess);
    }

    public int applyDamageInCylindricArea(float radius, float height, float maxAngle, class_1282 source, float amount) {
        return this.applyDamageInCylindricArea(radius, height, maxAngle, source, amount, (i, b) -> {});
    }

    public int applyDamageInCylindricArea(float radius, float height, class_1282 source, float amount) {
        return this.applyDamageInCylindricArea(radius, height, 360.0f, source, amount, (i, b) -> {});
    }

    public List<Class<? extends class_1309>> getIgnoredClasses() {
        return List.of();
    }

    public void onDamageEntity(class_1309 damaged) {
    }

    protected class_238 box(class_243 pos) {
        return new class_238(pos.method_1023(0.5, 0.5, 0.5), pos.method_1031(0.5, 0.5, 0.5));
    }
}

