/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5363;
import net.minecraft.class_5425;
import net.minecraft.class_5820;
import net.minecraft.class_6544;
import net.minecraft.class_6568;
import net.minecraft.class_6880;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.interfaces.BETargetChecker;
import org.betterx.betterend.mixin.common.NoiseBasedChunkGeneratorAccessor;
import org.betterx.betterend.mixin.common.NoiseChunkAccessor;
import org.betterx.betterend.mixin.common.NoiseInterpolatorAccessor;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.betterend.world.generator.IslandLayer;
import org.betterx.betterend.world.generator.TerrainBoolCache;
import org.betterx.wover.biome.api.BiomeManager;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceConfig;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithConfig;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.generator.api.biomesource.end.WoverEndConfig;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class TerrainGenerator {
    private static final Map<Point, TerrainBoolCache> TERRAIN_BOOL_CACHE_MAP = Maps.newHashMap();
    private static final ReentrantLock LOCKER = new ReentrantLock();
    private static final Point POS = new Point();
    private static final double SCALE_XZ = 8.0;
    private static final double SCALE_Y = 4.0;
    private static final float[] COEF;
    private static final Point[] OFFS;
    private static IslandLayer largeIslands;
    private static IslandLayer mediumIslands;
    private static IslandLayer smallIslands;
    private static OpenSimplexNoise noise1;
    private static OpenSimplexNoise noise2;
    private static class_1966 biomeSource;
    public static WoverEndConfig config;
    private static class_6544.class_6552 sampler;

    public static void initNoise(long seed, class_1966 biomeSource, class_6544.class_6552 sampler) {
        BiomeSourceWithConfig bcl;
        BiomeSourceConfig biomeSourceConfig;
        if (biomeSource instanceof BiomeSourceWithConfig && (biomeSourceConfig = (bcl = (BiomeSourceWithConfig)biomeSource).getBiomeSourceConfig()) instanceof WoverEndConfig) {
            WoverEndConfig config;
            TerrainGenerator.config = config = (WoverEndConfig)biomeSourceConfig;
        }
        if (config == null) {
            throw new IllegalStateException("Biome source config is not set");
        }
        class_5820 random = new class_5820(seed);
        largeIslands = new IslandLayer(random.method_43054(), GeneratorOptions.bigOptions);
        mediumIslands = new IslandLayer(random.method_43054(), GeneratorOptions.mediumOptions);
        smallIslands = new IslandLayer(random.method_43054(), GeneratorOptions.smallOptions);
        noise1 = new OpenSimplexNoise(random.method_43054());
        noise2 = new OpenSimplexNoise(random.method_43054());
        TERRAIN_BOOL_CACHE_MAP.clear();
        TerrainGenerator.biomeSource = biomeSource;
        TerrainGenerator.sampler = sampler;
    }

    public static void fillTerrainDensity(double[] buffer, int posX, int posZ, int scaleXZ, int scaleY, int maxHeight) {
        LOCKER.lock();
        float fadeOutDist = 27.0f;
        float fadOutStart = (float)maxHeight - 28.0f;
        largeIslands.clearCache();
        mediumIslands.clearCache();
        smallIslands.clearCache();
        int x = posX / scaleXZ;
        int z = posZ / scaleXZ;
        double distortion1 = noise1.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise2.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise1.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double distortion2 = noise2.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise1.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise2.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double px = (double)x * (double)scaleXZ + distortion1;
        double pz = (double)z * (double)scaleXZ + distortion2;
        largeIslands.updatePositions(px, pz, maxHeight);
        mediumIslands.updatePositions(px, pz, maxHeight);
        smallIslands.updatePositions(px, pz, maxHeight);
        float height = TerrainGenerator.getAverageDepth(x << 1, z << 1) * 0.5f;
        for (int y = 0; y < buffer.length; ++y) {
            double py = (double)y * (double)scaleY;
            float dist = largeIslands.getDensity(px, py, pz, height);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz, height));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz, height));
            if (dist > -0.5f) {
                dist += (float)(noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02);
                dist += (float)(noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01);
                dist += (float)(noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005);
            }
            if (py >= (double)maxHeight) {
                dist = -1.0f;
            } else if (py > (double)fadOutStart) {
                dist = (float)class_3532.method_16436((double)((py - (double)fadOutStart) / 27.0), (double)dist, (double)-1.0);
            }
            buffer[y] = dist;
        }
        LOCKER.unlock();
    }

    private static float getAverageDepth(int x, int z) {
        if (biomeSource == null) {
            return 0.0f;
        }
        WoverBiomeData biome = TerrainGenerator.getBiomeData(biomeSource, x, z);
        if (biome != null && biome.terrainHeight < 0.1f) {
            return 0.0f;
        }
        float depth = 0.0f;
        for (int i = 0; i < OFFS.length; ++i) {
            int px = x + TerrainGenerator.OFFS[i].x;
            int pz = z + TerrainGenerator.OFFS[i].y;
            biome = TerrainGenerator.getBiomeData(biomeSource, px, pz);
            depth += biome == null ? 0.0f : biome.terrainHeight * COEF[i];
        }
        return depth;
    }

    @Nullable
    private static WoverBiomeData getBiomeData(class_1966 biomeSource, int x, int z) {
        BiomeData biomeData = BiomeManager.biomeDataForHolder((class_6880)biomeSource.method_38109(x, 0, z, sampler));
        if (biomeData instanceof WoverBiomeData) {
            WoverBiomeData biome = (WoverBiomeData)biomeData;
            return biome;
        }
        return null;
    }

    public static Boolean isLand(int x, int z, int maxHeight) {
        byte value;
        int sectionX = TerrainBoolCache.scaleCoordinate(x);
        int sectionZ = TerrainBoolCache.scaleCoordinate(z);
        int stepY = (int)Math.ceil((double)maxHeight / 4.0);
        LOCKER.lock();
        POS.setLocation(sectionX, sectionZ);
        TerrainBoolCache section = TERRAIN_BOOL_CACHE_MAP.get(POS);
        if (section == null) {
            if (TERRAIN_BOOL_CACHE_MAP.size() > 64) {
                TERRAIN_BOOL_CACHE_MAP.clear();
            }
            section = new TerrainBoolCache();
            TERRAIN_BOOL_CACHE_MAP.put(new Point(TerrainGenerator.POS.x, TerrainGenerator.POS.y), section);
        }
        if ((value = section.getData(x, z)) > 0) {
            LOCKER.unlock();
            return value > 1;
        }
        double px = (double)(x >> 1) + 0.5;
        double pz = (double)(z >> 1) + 0.5;
        double distortion1 = noise1.eval(px * 0.1, pz * 0.1) * 20.0 + noise2.eval(px * 0.2, pz * 0.2) * 10.0 + noise1.eval(px * 0.4, pz * 0.4) * 5.0;
        double distortion2 = noise2.eval(px * 0.1, pz * 0.1) * 20.0 + noise1.eval(px * 0.2, pz * 0.2) * 10.0 + noise2.eval(px * 0.4, pz * 0.4) * 5.0;
        px = px * 8.0 + distortion1;
        pz = pz * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz, maxHeight);
        mediumIslands.updatePositions(px, pz, maxHeight);
        smallIslands.updatePositions(px, pz, maxHeight);
        boolean result = false;
        for (int y = 0; y < stepY; ++y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist += (float)(noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02);
                dist += (float)(noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01);
                dist += (float)(noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005);
            }
            if (!((double)dist > -0.01)) continue;
            result = true;
            break;
        }
        section.setData(x, z, (byte)(result ? 2 : 1));
        LOCKER.unlock();
        return result;
    }

    public static void onServerLevelInit(class_3218 level, class_5363 levelStem, long seed) {
        if (level.method_27983() == class_1937.field_25181) {
            class_2794 chunkGenerator = levelStem.comp_1013();
            if (chunkGenerator instanceof class_3754) {
                class_6880<class_5284> sHolder = ((NoiseBasedChunkGeneratorAccessor)chunkGenerator).be_getSettings();
                class_1966 class_19662 = chunkGenerator.method_12098();
                if (class_19662 instanceof WoverEndBiomeSource) {
                    WoverEndBiomeSource bcl = (WoverEndBiomeSource)class_19662;
                    ((BETargetChecker)BETargetChecker.class.cast(sHolder.comp_349())).be_setTarget(bcl.getBiomeSourceConfig().generatorVersion == WoverEndConfig.EndBiomeGeneratorType.PAULEVS);
                } else {
                    ((BETargetChecker)BETargetChecker.class.cast(sHolder.comp_349())).be_setTarget(false);
                }
            }
            TerrainGenerator.initNoise(seed, chunkGenerator.method_12098(), level.method_14178().method_41248().method_42371());
        }
    }

    public static void makeObsidianPlatform(class_5425 serverLevel, CallbackInfo info) {
        if (!GeneratorOptions.generateObsidianPlatform()) {
            info.cancel();
        } else if (GeneratorOptions.changeSpawn()) {
            class_2338 blockPos = GeneratorOptions.getSpawn();
            int i = blockPos.method_10263();
            int j = blockPos.method_10264() - 2;
            int k = blockPos.method_10260();
            class_2338.method_10094((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(blockPosx -> serverLevel.method_8652(blockPosx, class_2246.field_10124.method_9564(), 3));
            class_2338.method_10094((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(blockPosx -> serverLevel.method_8652(blockPosx, class_2246.field_10540.method_9564(), 3));
            info.cancel();
        }
    }

    public static void fillSlice(boolean primarySlice, int x, List<class_6568.class_5917> interpolators, NoiseChunkAccessor accessor, class_5309 noiseSettings) {
        int sizeY = noiseSettings.method_39545();
        int sizeXZ = noiseSettings.method_39546();
        int cellSizeXZ = accessor.bnv_getCellCountXZ() + 1;
        int firstCellZ = accessor.bnv_getFirstCellZ();
        x *= sizeXZ;
        for (int cellXZ = 0; cellXZ < cellSizeXZ; ++cellXZ) {
            int z = (firstCellZ + cellXZ) * sizeXZ;
            for (class_6568.class_5917 noiseInterpolator : interpolators) {
                if (!(noiseInterpolator instanceof NoiseInterpolatorAccessor)) continue;
                NoiseInterpolatorAccessor interpolator = (NoiseInterpolatorAccessor)noiseInterpolator;
                double[] ds = (primarySlice ? interpolator.be_getSlice0() : interpolator.be_getSlice1())[cellXZ];
                TerrainGenerator.fillTerrainDensity(ds, x, z, sizeXZ, sizeY, noiseSettings.comp_174());
            }
        }
    }

    static {
        float sum = 0.0f;
        ArrayList coef = Lists.newArrayList();
        ArrayList pos = Lists.newArrayList();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                float dist = MHelper.length((float)x, (float)z) / 3.0f;
                if (!(dist <= 1.0f)) continue;
                sum += dist;
                coef.add(Float.valueOf(dist));
                pos.add(new Point(x, z));
            }
        }
        OFFS = pos.toArray(new Point[0]);
        COEF = new float[coef.size()];
        for (int i = 0; i < COEF.length; ++i) {
            TerrainGenerator.COEF[i] = ((Float)coef.get(i)).floatValue() / sum;
        }
    }
}

