/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.rituals;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2423;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.blocks.RunedFlavolite;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.network.RitualUpdate;
import org.betterx.betterend.portal.PortalBuilder;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.Nullable;

public class EternalRitual {
    private static final Set<Point> PEDESTAL_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(-4, -5), new Point(-4, 5), new Point(-6, 0), new Point(4, -5), new Point(4, 5), new Point(6, 0)});
    private static final class_2248 PEDESTAL = EndBlocks.ETERNAL_PEDESTAL;
    public static final class_2746 ACTIVE = BlockProperties.ACTIVE;
    private class_1937 world;
    private class_2350.class_2351 axis;
    private class_2960 targetWorldId;
    private class_2338 center;
    private class_2338 exit;
    private boolean active = false;
    private boolean willActivate = false;

    public EternalRitual(class_1937 world) {
        this.world = world;
    }

    public EternalRitual(class_1937 world, class_2338 initial) {
        this(world);
        this.configure(initial);
    }

    public class_2338 getCenter() {
        return this.center;
    }

    public class_2350.class_2351 getAxis() {
        return this.axis;
    }

    public void setWorld(class_1937 world) {
        this.world = world;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    @Nullable
    public class_2960 getTargetWorldId() {
        return this.targetWorldId;
    }

    private boolean isInvalid() {
        return this.world == null || this.world.method_8608() || this.center == null || this.axis == null;
    }

    public void checkStructure(class_1657 player) {
        class_2350 moveY;
        class_2350 moveX;
        if (this.isInvalid()) {
            return;
        }
        if (class_2350.class_2351.field_11048 == this.axis) {
            moveX = class_2350.field_11034;
            moveY = class_2350.field_11043;
        } else {
            moveX = class_2350.field_11035;
            moveY = class_2350.field_11034;
        }
        boolean valid = this.checkFrame(this.world, this.center.method_10074());
        class_1792 item = null;
        for (Point pos : PEDESTAL_POSITIONS) {
            EternalPedestalEntity pedestal;
            class_2338.class_2339 checkPos = this.center.method_25503();
            checkPos.method_10104(moveX, pos.x).method_10104(moveY, pos.y);
            if (!(valid &= this.isActive((class_2338)checkPos)) || (pedestal = (EternalPedestalEntity)this.world.method_8321((class_2338)checkPos)) == null) continue;
            class_1792 pItem = pedestal.method_5438(0).method_7909();
            if (item == null) {
                item = pItem;
                continue;
            }
            if (item.equals(pItem)) continue;
            valid = false;
        }
        if (valid && item != null) {
            this.activatePortal(player, item);
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                BECriteria.PORTAL_ON.method_9141(sp);
            }
        }
    }

    public void updateActiveStateOnPedestals() {
        if (this.world == null) {
            return;
        }
        EternalRitual.updateActiveStateOnPedestals(this.center, this.axis, this.active, this.willActivate, this.world, this);
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            new RitualUpdate(this).sendToClient(serverLevel);
        }
    }

    public static void updateActiveStateOnPedestals(class_2338 center, class_2350.class_2351 axis, boolean active, boolean willActivate, class_1937 world, EternalRitual fallback) {
        class_2350 moveY;
        class_2350 moveX;
        if (class_2350.class_2351.field_11048 == axis) {
            moveX = class_2350.field_11034;
            moveY = class_2350.field_11043;
        } else {
            moveX = class_2350.field_11035;
            moveY = class_2350.field_11034;
        }
        for (Point pos : PEDESTAL_POSITIONS) {
            class_2338.class_2339 checkPos = center.method_25503();
            checkPos.method_10104(moveX, pos.x).method_10104(moveY, pos.y);
            class_2586 class_25862 = world.method_8321((class_2338)checkPos);
            if (!(class_25862 instanceof EternalPedestalEntity)) continue;
            EternalPedestalEntity pedestal = (EternalPedestalEntity)class_25862;
            if (pedestal.hasRitual()) {
                if (fallback == null) {
                    fallback = pedestal.getRitual();
                }
                pedestal.getRitual().active = active;
                pedestal.getRitual().willActivate = willActivate;
                continue;
            }
            if (fallback == null) {
                fallback = new EternalRitual(world);
                fallback.center = center;
                fallback.axis = axis;
                fallback.willActivate = willActivate;
                fallback.active = active;
            }
            pedestal.linkRitual(fallback);
        }
    }

    private boolean checkFrame(class_1937 world, class_2338 framePos) {
        class_2350 moveDir = class_2350.class_2351.field_11048 == this.axis ? class_2350.field_11043 : class_2350.field_11034;
        boolean valid = true;
        for (Point point : PortalBuilder.FRAME_POSITIONS) {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            class_2680 state = world.method_8320((class_2338)pos);
            valid &= state.method_26204() instanceof RunedFlavolite;
            pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
            state = world.method_8320((class_2338)pos);
            valid &= state.method_26204() instanceof RunedFlavolite;
        }
        return valid;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean willActivate() {
        return this.willActivate;
    }

    private void activatePortal(class_1657 player, class_1792 keyItem) {
        if (this.active) {
            return;
        }
        this.willActivate = true;
        this.updateActiveStateOnPedestals();
        class_2960 itemId = class_7923.field_41178.method_10221((Object)keyItem);
        int portalId = EndPortals.getPortalIdByItem(itemId);
        class_1937 targetWorld = this.getTargetWorld(portalId);
        class_2960 worldId = targetWorld.method_27983().method_29177();
        try {
            if (this.exit == null) {
                this.initPortal(player, worldId, portalId);
            } else {
                if (!worldId.equals((Object)this.targetWorldId)) {
                    this.initPortal(player, worldId, portalId);
                } else if (!this.checkFrame(targetWorld, this.exit.method_10074())) {
                    class_2350.class_2351 portalAxis = class_2350.class_2351.field_11048 == this.axis ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
                    PortalBuilder.generatePortal(targetWorld, this.exit, portalAxis, portalId);
                }
                this.activatePortal(targetWorld, this.exit, portalId);
            }
            this.activatePortal(this.world, this.center, portalId);
            class_1937 class_19372 = this.world;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.doEffects(serverLevel, this.center);
            }
            this.willActivate = false;
            this.active = true;
            this.updateActiveStateOnPedestals();
        }
        catch (Exception ex) {
            BetterEnd.LOGGER.error("Create End portals error.", ex);
            this.removePortal(targetWorld, this.exit);
            this.removePortal(this.world, this.center);
            this.willActivate = false;
            this.active = false;
            this.updateActiveStateOnPedestals();
        }
    }

    private void initPortal(class_1657 player, class_2960 worldId, int portalId) {
        this.targetWorldId = worldId;
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_2784 worldBorder;
            class_3218 sourceWorld = (class_3218)class_19372;
            class_3218 targetLevel = (class_3218)this.getTargetWorld(portalId);
            PortalBuilder builder = new PortalBuilder(this.world, targetLevel);
            Optional<PortalBuilder.FoundPortalRect> foundRectangle = builder.findPortalAround(this.center, worldBorder = targetLevel.method_8621());
            if (foundRectangle.isEmpty()) {
                Optional<class_2338> centerPos = builder.createPortal(PortalBuilder.getStartingPos((class_1937)sourceWorld, (class_1937)targetLevel, (class_1297)player, worldBorder), this.axis, portalId);
                centerPos.ifPresent(blockPos -> {
                    this.exit = blockPos;
                });
            }
        }
    }

    private void doEffects(class_3218 serverWorld, class_2338 center) {
        class_2350 moveY;
        class_2350 moveX;
        if (class_2350.class_2351.field_11048 == this.axis) {
            moveX = class_2350.field_11034;
            moveY = class_2350.field_11043;
        } else {
            moveX = class_2350.field_11035;
            moveY = class_2350.field_11034;
        }
        for (Point pos : PEDESTAL_POSITIONS) {
            class_2338.class_2339 p = center.method_25503();
            p.method_10104(moveX, pos.x).method_10104(moveY, pos.y);
            serverWorld.method_14199((class_2394)class_2398.field_11214, (double)p.method_10263() + 0.5, (double)p.method_10264() + 1.5, (double)p.method_10260() + 0.5, 20, 0.0, 0.0, 0.0, 1.0);
            serverWorld.method_14199((class_2394)class_2398.field_23190, (double)p.method_10263() + 0.5, (double)p.method_10264() + 1.5, (double)p.method_10260() + 0.5, 20, 0.0, 0.0, 0.0, 0.3);
        }
        serverWorld.method_8396(null, center, class_3417.field_14981, class_3419.field_15254, 16.0f, 1.0f);
    }

    private void activatePortal(class_1937 world, class_2338 center, int portalId) {
        class_2338 framePos = center.method_10074();
        class_2350 moveDir = class_2350.class_2351.field_11048 == this.axis ? class_2350.field_11043 : class_2350.field_11034;
        class_2680 frame = (class_2680)PortalBuilder.FRAME.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true));
        PortalBuilder.FRAME_POSITIONS.forEach(point -> {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            class_2680 state = world.method_8320((class_2338)pos);
            if (state.method_28498((class_2769)ACTIVE) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, frame);
            }
            if ((state = world.method_8320((class_2338)(pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y)))).method_28498((class_2769)ACTIVE) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, frame);
            }
        });
        class_2350.class_2351 portalAxis = class_2350.class_2351.field_11048 == this.axis ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        class_2680 portal = (class_2680)((class_2680)PortalBuilder.PORTAL.method_9564().method_11657((class_2769)EndPortalBlock.field_11310, (Comparable)portalAxis)).method_11657((class_2769)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        class_2388 effect = new class_2388(class_2398.field_11217, portal);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PortalBuilder.PORTAL_POSITIONS.forEach(arg_0 -> EternalRitual.lambda$activatePortal$2(center, moveDir, world, portal, serverWorld, (class_2394)effect, arg_0));
        }
    }

    public void disablePortal(int state) {
        if (!this.active || this.isInvalid()) {
            return;
        }
        if (!this.world.method_8608()) {
            this.removePortal(this.getTargetWorld(state), this.exit);
        }
        this.removePortal(this.world, this.center);
    }

    private void removePortal(class_1937 world, class_2338 center) {
        class_2338 framePos = center.method_10074();
        class_2350 moveDir = class_2350.class_2351.field_11048 == this.axis ? class_2350.field_11043 : class_2350.field_11034;
        PortalBuilder.FRAME_POSITIONS.forEach(point -> {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            class_2680 state = world.method_8320((class_2338)pos);
            if (state.method_27852(PortalBuilder.FRAME) && ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
            if ((state = world.method_8320((class_2338)(pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y)))).method_27852(PortalBuilder.FRAME) && ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        });
        PortalBuilder.PORTAL_POSITIONS.forEach(point -> {
            class_2338.class_2339 pos = center.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            if (world.method_8320((class_2338)pos).method_27852(PortalBuilder.PORTAL)) {
                world.method_8650((class_2338)pos, false);
            }
            if (world.method_8320((class_2338)(pos = center.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y))).method_27852(PortalBuilder.PORTAL)) {
                world.method_8650((class_2338)pos, false);
            }
        });
        this.active = false;
        this.updateActiveStateOnPedestals();
    }

    private class_1937 getTargetWorld(int state) {
        if (this.world.method_27983() == class_1937.field_25181) {
            return EndPortals.getWorld(this.world.method_8503(), state);
        }
        return Objects.requireNonNull(this.world.method_8503()).method_3847(class_1937.field_25181);
    }

    public void configure(class_2338 initial) {
        class_2338 checkPos = initial.method_10089(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = initial.method_10089(6);
            return;
        }
        checkPos = initial.method_10088(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = initial.method_10088(6);
            return;
        }
        checkPos = initial.method_10077(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = initial.method_10077(6);
            return;
        }
        checkPos = initial.method_10076(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = initial.method_10076(6);
            return;
        }
        checkPos = initial.method_10076(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = this.hasPedestal(checkPos = checkPos.method_10089(8)) ? initial.method_10076(5).method_10089(4) : initial.method_10076(5).method_10088(4);
            return;
        }
        checkPos = initial.method_10077(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = this.hasPedestal(checkPos = checkPos.method_10089(8)) ? initial.method_10077(5).method_10089(4) : initial.method_10077(5).method_10088(4);
            return;
        }
        checkPos = initial.method_10089(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = this.hasPedestal(checkPos = checkPos.method_10077(8)) ? initial.method_10089(5).method_10077(4) : initial.method_10089(5).method_10076(4);
            return;
        }
        checkPos = initial.method_10088(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = this.hasPedestal(checkPos = checkPos.method_10077(8)) ? initial.method_10088(5).method_10077(4) : initial.method_10088(5).method_10076(4);
        }
    }

    private boolean hasPedestal(class_2338 pos) {
        return this.world.method_8320(pos).method_27852(PEDESTAL);
    }

    private boolean isActive(class_2338 pos) {
        class_2680 state = this.world.method_8320(pos);
        if (state.method_27852(PEDESTAL)) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)this.world.method_8321(pos);
            if (pedestal != null) {
                if (!pedestal.hasRitual()) {
                    pedestal.linkRitual(this);
                } else {
                    EternalRitual ritual = pedestal.getRitual();
                    if (!ritual.equals(this)) {
                        pedestal.linkRitual(this);
                    }
                }
            }
            return (Boolean)state.method_11654((class_2769)ACTIVE);
        }
        return false;
    }

    public class_2487 toTag(class_2487 tag) {
        tag.method_10566("center", class_2512.method_10692((class_2338)this.center));
        tag.method_10582("axis", this.axis.method_10174());
        tag.method_10556("active", this.active);
        if (this.targetWorldId != null) {
            tag.method_10582("key_item", this.targetWorldId.toString());
        }
        if (this.exit != null) {
            tag.method_10566("exit", class_2512.method_10692((class_2338)this.exit));
        }
        return tag;
    }

    public void fromTag(class_2487 tag) {
        this.axis = class_2350.class_2351.method_10177((String)tag.method_10558("axis"));
        this.center = class_2512.method_10691((class_2487)tag, (String)"center").orElse(class_2338.field_10980);
        this.active = tag.method_10577("active");
        if (tag.method_10545("exit")) {
            this.exit = class_2512.method_10691((class_2487)tag, (String)"exit").orElse(class_2338.field_10980);
        }
        if (tag.method_10545("key_item")) {
            this.targetWorldId = class_2960.method_60654((String)tag.method_10558("key_item"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EternalRitual ritual = (EternalRitual)o;
        return this.world.equals(ritual.world) && Objects.equals(this.center, ritual.center) && Objects.equals(this.exit, ritual.exit);
    }

    public static EternalRitual findRitualForActivePortal(class_1937 world, class_2338 startPos) {
        class_2680 state = world.method_8320(startPos);
        if (EternalRitual.isActivePortalBlock(state)) {
            class_2586 class_25862;
            class_2350 direction;
            class_2350 class_23502 = direction = state.method_11654((class_2769)class_2423.field_11310) == class_2350.class_2351.field_11048 ? class_2350.field_11034 : class_2350.field_11043;
            while (world.method_8320(startPos.method_10074()).method_27852(EndBlocks.END_PORTAL_BLOCK)) {
                startPos = startPos.method_10074();
            }
            if (world.method_8320(startPos.method_10079(direction, -1)).method_27852(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.method_10079(direction, 1);
            } else if (world.method_8320(startPos.method_10079(direction, 1)).method_27852(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.method_10079(direction, -1);
            }
            if (!world.method_8320(startPos.method_10074()).method_27852(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.method_10074();
            }
            if (world.method_8320(startPos.method_10079(direction, -1)).method_27852(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.method_10079(direction, 1);
            } else if (world.method_8320(startPos.method_10079(direction, 1)).method_27852(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.method_10079(direction, -1);
            }
            startPos = startPos.method_10079(direction.method_10170(), 6);
            state = world.method_8320(startPos);
            if (state.method_27852(EndBlocks.ETERNAL_PEDESTAL) && (class_25862 = world.method_8321(startPos)) instanceof EternalPedestalEntity) {
                EternalPedestalEntity pedestal = (EternalPedestalEntity)class_25862;
                return pedestal.getRitual();
            }
            return null;
        }
        return null;
    }

    private static boolean isActivePortalBlock(class_2680 state) {
        return state.method_27852(EndBlocks.END_PORTAL_BLOCK) && state.method_28498((class_2769)class_2423.field_11310);
    }

    private static /* synthetic */ void lambda$activatePortal$2(class_2338 center, class_2350 moveDir, class_1937 world, class_2680 portal, class_3218 serverWorld, class_2394 effect, Point point) {
        class_2338.class_2339 pos = center.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
        if (!world.method_8320((class_2338)pos).method_27852(PortalBuilder.PORTAL)) {
            world.method_8501((class_2338)pos, portal);
            serverWorld.method_14199(effect, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.method_14199((class_2394)class_2398.field_23190, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
        if (!world.method_8320((class_2338)(pos = center.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y))).method_27852(PortalBuilder.PORTAL)) {
            world.method_8501((class_2338)pos, portal);
            serverWorld.method_14199(effect, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.method_14199((class_2394)class_2398.field_23190, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
    }
}

