/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_9801;
import org.betterx.bclib.util.BackgroundInfo;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BetterEndSkyRenderer
implements DimensionRenderingRegistry.SkyRenderer {
    private static final class_2960 NEBULA_1 = BetterEnd.C.mk("textures/sky/nebula_2.png");
    private static final class_2960 NEBULA_2 = BetterEnd.C.mk("textures/sky/nebula_3.png");
    private static final class_2960 HORIZON = BetterEnd.C.mk("textures/sky/nebula_1.png");
    private static final class_2960 STARS = BetterEnd.C.mk("textures/sky/stars.png");
    private static final class_2960 FOG = BetterEnd.C.mk("textures/sky/fog.png");
    private class_291 nebula1;
    private class_291 nebula2;
    private class_291 horizon;
    private class_291 stars1;
    private class_291 stars2;
    private class_291 stars3;
    private class_291 stars4;
    private class_291 fog;
    private Vector3f axis1;
    private Vector3f axis2;
    private Vector3f axis3;
    private Vector3f axis4;
    private boolean initialised;

    private void initialise() {
        if (!this.initialised) {
            this.initStars();
            class_5820 random = new class_5820(131L);
            this.axis1 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
            this.axis2 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
            this.axis3 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
            this.axis4 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
            this.axis1.normalize();
            this.axis2.normalize();
            this.axis3.normalize();
            this.axis4.normalize();
            this.initialised = true;
        }
    }

    public void render(WorldRenderContext context) {
        float a;
        if (context.world() == null || context.matrixStack() == null) {
            return;
        }
        this.initialise();
        Matrix4f projectionMatrix = context.projectionMatrix();
        class_4587 matrices = context.matrixStack();
        float time = ((float)context.world().method_8532() + context.tickCounter().method_60638()) % 360000.0f * 1.7453292E-5f;
        float time2 = time * 2.0f;
        float time3 = time * 3.0f;
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        float blindA = 1.0f - BackgroundInfo.blindness;
        float blind02 = blindA * 0.2f;
        float blind06 = blindA * 0.6f;
        if (blindA > 0.0f) {
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().rotationXYZ(0.0f, time, 0.0f));
            RenderSystem.setShaderTexture((int)0, (class_2960)HORIZON);
            this.renderBuffer(matrices, projectionMatrix, this.horizon, class_290.field_1585, 0.77f, 0.31f, 0.73f, 0.7f * blindA);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().rotationXYZ(0.0f, -time, 0.0f));
            RenderSystem.setShaderTexture((int)0, (class_2960)NEBULA_1);
            this.renderBuffer(matrices, projectionMatrix, this.nebula1, class_290.field_1585, 0.77f, 0.31f, 0.73f, blind02);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().rotationXYZ(0.0f, time2, 0.0f));
            RenderSystem.setShaderTexture((int)0, (class_2960)NEBULA_2);
            this.renderBuffer(matrices, projectionMatrix, this.nebula2, class_290.field_1585, 0.77f, 0.31f, 0.73f, blind02);
            matrices.method_22909();
            RenderSystem.setShaderTexture((int)0, (class_2960)STARS);
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().setAngleAxis(time, this.axis3.x, this.axis3.y, this.axis3.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars3, class_290.field_1585, 0.77f, 0.31f, 0.73f, blind06);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().setAngleAxis(time2, this.axis4.x, this.axis4.y, this.axis4.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars4, class_290.field_1585, 1.0f, 1.0f, 1.0f, blind06);
            matrices.method_22909();
        }
        if ((a = BackgroundInfo.fogDensity - 1.0f) > 0.0f) {
            if (a > 1.0f) {
                a = 1.0f;
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)FOG);
            this.renderBuffer(matrices, projectionMatrix, this.fog, class_290.field_1585, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, a);
        }
        if (blindA > 0.0f) {
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().setAngleAxis(time3, this.axis1.x, this.axis1.y, this.axis1.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars1, class_290.field_1592, 1.0f, 1.0f, 1.0f, blind06);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907(new Quaternionf().setAngleAxis(time2, this.axis2.x, this.axis2.y, this.axis2.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars2, class_290.field_1592, 0.95f, 0.64f, 0.93f, blind06);
            matrices.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBuffer(class_4587 matrices, Matrix4f matrix4f, class_291 buffer, class_293 format, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        buffer.method_1353();
        if (format == class_290.field_1592) {
            buffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34539());
        } else {
            buffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34542());
        }
        class_291.method_1354();
    }

    private void initStars() {
        class_289 tesselator = class_289.method_1348();
        this.stars1 = this.buildBuffer(tesselator, this.stars1, 0.1f, 0.3f, 3500, 41315L, this::makeStars);
        this.stars2 = this.buildBuffer(tesselator, this.stars2, 0.1f, 0.35f, 2000, 35151L, this::makeStars);
        this.stars3 = this.buildBuffer(tesselator, this.stars3, 0.4f, 1.2f, 1000, 61354L, this::makeUVStars);
        this.stars4 = this.buildBuffer(tesselator, this.stars4, 0.4f, 1.2f, 1000, 61355L, this::makeUVStars);
        this.nebula1 = this.buildBuffer(tesselator, this.nebula1, 40.0f, 60.0f, 30, 11515L, this::makeFarFog);
        this.nebula2 = this.buildBuffer(tesselator, this.nebula2, 40.0f, 60.0f, 10, 14151L, this::makeFarFog);
        this.horizon = this.buildBufferHorizon(tesselator, this.horizon);
        this.fog = this.buildBufferFog(tesselator, this.fog);
    }

    private class_291 buildBuffer(class_289 tesselator, class_291 vertexBuffer, float minSize, float maxSize, int count, long seed, BufferFunction fkt) {
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new class_291(class_291.class_8555.field_44793);
        class_287 bufferBuilder = fkt.make(tesselator, minSize, maxSize, count, seed);
        class_9801 meshData = bufferBuilder.method_60794();
        vertexBuffer.method_1353();
        vertexBuffer.method_1352(meshData);
        return vertexBuffer;
    }

    private class_291 buildBufferHorizon(class_289 tesselator, class_291 buffer) {
        return this.buildBuffer(tesselator, buffer, 0.0f, 0.0f, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0f, 100.0f));
    }

    private class_291 buildBufferFog(class_289 tesselator, class_291 buffer) {
        return this.buildBuffer(tesselator, buffer, 0.0f, 0.0f, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0f, 70.0f));
    }

    private class_287 makeStars(class_289 tesselator, float minSize, float maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        RenderSystem.setShader(class_757::method_34539);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        for (int i = 0; i < count; ++i) {
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() * 2.0f - 1.0f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float size = MHelper.randRange((float)minSize, (float)maxSize, (class_5819)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = 1.0f / (float)Math.sqrt(length);
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.method_43057() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                buffer.method_22912(px + dx, py + dy, pz + dz);
            }
        }
        return buffer;
    }

    private class_287 makeUVStars(class_289 tesselator, float minSize, float maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < count; ++i) {
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() * 2.0f - 1.0f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float size = MHelper.randRange((float)minSize, (float)maxSize, (class_5819)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = 1.0f / (float)Math.sqrt(length);
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.method_43057() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            float minV = (float)random.method_43048(4) / 4.0f;
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = (float)(index + 1 >> 1 & 1) / 4.0f + minV;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_22913(texU, texV);
            }
        }
        return buffer;
    }

    private class_287 makeFarFog(class_289 tesselator, float minSize, float maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < count; ++i) {
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() - 0.5f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float size = MHelper.randRange((float)minSize, (float)maxSize, (class_5819)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            float distance = 2.0f;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = distance / (float)Math.sqrt(length);
            size *= distance;
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.method_43057() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_22913(texU, texV);
            }
        }
        return buffer;
    }

    private class_287 makeCylinder(class_289 tesselator, int segments, float height, float radius) {
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < segments; ++i) {
            float a1 = (float)i * (float)Math.PI * 2.0f / (float)segments;
            float a2 = (float)(i + 1) * (float)Math.PI * 2.0f / (float)segments;
            float px1 = (float)Math.sin(a1) * radius;
            float pz1 = (float)Math.cos(a1) * radius;
            float px2 = (float)Math.sin(a2) * radius;
            float pz2 = (float)Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.method_22912(px1, -height, pz1).method_22913(u0, 0.0f);
            buffer.method_22912(px1, height, pz1).method_22913(u0, 1.0f);
            buffer.method_22912(px2, height, pz2).method_22913(u1, 1.0f);
            buffer.method_22912(px2, -height, pz2).method_22913(u1, 0.0f);
        }
        return buffer;
    }

    @FunctionalInterface
    static interface BufferFunction {
        public class_287 make(class_289 var1, float var2, float var3, int var4, long var5);
    }
}

