/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2897;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_7151;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.world.structures.city.CityGenerator;
import org.betterx.betternether.world.structures.city.palette.Palettes;
import org.betterx.betternether.world.structures.piece.CavePiece;
import org.betterx.betternether.world.structures.piece.CityPiece;
import org.betterx.wover.structure.api.StructureUtils;
import org.jetbrains.annotations.NotNull;

public class CityStructure
extends class_3195 {
    private static CityGenerator generator;
    public static final int RADIUS = 64;
    private static final int DEFAULT_HEIGHT = 40;

    public CityStructure(class_3195.class_7302 structureSettings) {
        super(structureSettings);
    }

    public static void initGenerator() {
        generator = new CityGenerator();
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (StructureUtils.isValidBiome((class_3195.class_7149)context, (int)40)) {
            class_1923 cPos = context.comp_568();
            class_2794 chunkGenerator = context.comp_562();
            class_5539 heightAccessor = context.comp_569();
            class_2338 center = CityStructure.getCenter(context, cPos, chunkGenerator, heightAccessor);
            return Optional.of(new class_3195.class_7150(center, structurePiecesBuilder -> CityStructure.generatePieces(structurePiecesBuilder, context)));
        }
        return Optional.empty();
    }

    private static void generatePieces(class_6626 structurePiecesBuilder, class_3195.class_7149 context) {
        int d2;
        class_1923 cPos = context.comp_568();
        class_2794 chunkGenerator = context.comp_562();
        class_5539 heightAccessor = context.comp_569();
        class_2919 random = context.comp_566();
        class_2338 center = CityStructure.getCenter(context, cPos, chunkGenerator, heightAccessor);
        ArrayList<CityPiece> buildings = generator.generate(center, (class_5819)random, Palettes.EMPTY);
        class_3341 cityBox = new class_3341(center);
        for (CityPiece p : buildings) {
            cityBox = cityBox.method_35412(p.method_14935());
        }
        int d1 = Math.max(center.method_10263() - cityBox.method_35415(), cityBox.method_35418() - center.method_10263());
        int radius = Math.max(d1, d2 = Math.max(center.method_10260() - cityBox.method_35417(), cityBox.method_35420() - center.method_10260()));
        if (radius / 2 + center.method_10264() < cityBox.method_35419()) {
            radius = (cityBox.method_35419() - center.method_10264()) / 2;
        }
        if (!(chunkGenerator instanceof class_2897)) {
            CavePiece cave = new CavePiece(center, radius + 8, (class_5819)random, cityBox);
            structurePiecesBuilder.method_35462((class_3443)cave);
        }
        buildings.forEach(b -> structurePiecesBuilder.method_35462((class_3443)b));
        BetterNether.C.log.info("BBox:" + structurePiecesBuilder.method_38721().toString());
    }

    @NotNull
    private static class_2338 getCenter(class_3195.class_7149 context, class_1923 cPos, class_2794 chunkGenerator, class_5539 heightAccessor) {
        int px = cPos.method_33939(8);
        int pz = cPos.method_33941(8);
        int y = chunkGenerator instanceof class_2897 ? chunkGenerator.method_16397(px, pz, class_2902.class_2903.field_13202, heightAccessor, context.comp_564()) : 40;
        class_2338 center = new class_2338(px, y, pz);
        return center;
    }

    public class_7151<?> method_41618() {
        return NetherStructures.CITY_STRUCTURE.type();
    }
}

