/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagespawnpoint_common_forge.events;

import com.mojang.logging.LogUtils;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.FeatureFunctions;
import com.natamus.villagespawnpoint_common_forge.config.ConfigHandler;
import com.natamus.villagespawnpoint_common_forge.data.Constants;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.ServerLevelData;
import org.slf4j.Logger;

public class VillageSpawnEvent {
    private static final Logger logger = LogUtils.getLogger();

    public static boolean onWorldLoad(ServerLevel serverLevel, ServerLevelData serverLevelData) {
        if (Constants.biomeSpawnPointLoaded) {
            return false;
        }
        WorldOptions worldGeneratorOptions = serverLevel.getServer().getWorldData().worldGenOptions();
        if (!worldGeneratorOptions.generateStructures()) {
            return false;
        }
        logger.info("[Village Spawn Point] Finding the nearest village. This might take a few seconds.");
        BlockPos spawnPos = BlockPosFunctions.getNearbyVillage((ServerLevel)serverLevel, (BlockPos)new BlockPos(0, 0, 0), (String)ConfigHandler.locateVillageTag);
        if (spawnPos == null) {
            if (ConfigHandler.keepDefaultVillageTagBackup && !ConfigHandler.locateVillageTag.equals("#minecraft:village")) {
                spawnPos = BlockPosFunctions.getNearbyVillage((ServerLevel)serverLevel, (BlockPos)new BlockPos(0, 0, 0), (String)"#minecraft:village");
            }
            if (spawnPos == null) {
                return false;
            }
        }
        logger.info("[Village Spawn Point] Village found! The world will now generate.");
        serverLevel.setDefaultSpawnPos(spawnPos, 1.0f);
        if (worldGeneratorOptions.generateBonusChest()) {
            FeatureFunctions.placeBonusChest((Level)serverLevel, (BlockPos)spawnPos);
        }
        return true;
    }
}

