/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.handler.EventHandler;

public class FoodHelper {
    public static class_4174 EMPTY_FOOD_COMPONENT = new class_4174.class_4175().method_19242();
    public static float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static float MAX_EXHAUSTION = 4.0f;

    public static boolean isFood(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_50075);
    }

    public static boolean canConsume(class_1657 player, class_4174 foodComponent) {
        return player.method_7332(foodComponent.comp_2493());
    }

    public static class_4174 getDefaultFoodValues(class_1799 itemStack) {
        return (class_4174)itemStack.method_57825(class_9334.field_50075, (Object)EMPTY_FOOD_COMPONENT);
    }

    @Nullable
    public static QueriedFoodResult query(class_1799 itemStack, class_1657 player) {
        if (!FoodHelper.isFood(itemStack)) {
            return null;
        }
        class_4174 defaultFood = FoodHelper.getDefaultFoodValues(itemStack);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent(player, itemStack, defaultFood, defaultFood);
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact(foodValuesEvent);
        return new QueriedFoodResult(foodValuesEvent.defaultFoodComponent, foodValuesEvent.modifiedFoodComponent, itemStack);
    }

    public static boolean isRotten(class_4174 foodComponent) {
        for (class_4174.class_9423 effect : foodComponent.comp_2495()) {
            if (((class_1291)effect.comp_2496().method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
            return true;
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(class_1657 player, class_4174 foodComponent) {
        if (!player.method_7317()) {
            return 0.0f;
        }
        class_1702 stats = player.method_7344();
        class_1937 world = player.method_5770();
        int foodLevel = Math.min(stats.method_7586() + foodComponent.comp_2491(), 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && world != null && world.method_8450().method_8355(class_1928.field_19395)) {
            float saturationLevel = Math.min(stats.method_7589() + foodComponent.comp_2492(), (float)foodLevel);
            float exhaustionLevel = stats.method_35219();
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        for (class_4174.class_9423 effect : foodComponent.comp_2495()) {
            class_1293 effectInstance = effect.comp_2496();
            if (effectInstance.method_5579() != class_1294.field_5924) continue;
            int amplifier = effectInstance.method_5578();
            int duration = effectInstance.method_5584();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
            break;
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > MAX_EXHAUSTION) {
                exhaustionLevel -= MAX_EXHAUSTION;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, REGEN_EXHAUSTION_INCREMENT);
                float exhaustionUntilAboveMax = Math.nextUp(MAX_EXHAUSTION) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / REGEN_EXHAUSTION_INCREMENT * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += REGEN_EXHAUSTION_INCREMENT;
        }
        return health;
    }

    public static class QueriedFoodResult {
        public class_4174 defaultFoodComponent;
        public class_4174 modifiedFoodComponent;
        public final class_1799 itemStack;

        public QueriedFoodResult(class_4174 defaultFoodComponent, class_4174 modifiedFoodComponent, class_1799 itemStack) {
            this.defaultFoodComponent = defaultFoodComponent;
            this.modifiedFoodComponent = modifiedFoodComponent;
            this.itemStack = itemStack;
        }
    }
}

