/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.items;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.chaosthedude.explorerscompass.gui.GuiWrapper;
import com.chaosthedude.explorerscompass.network.SyncPacket;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.PlayerUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.chaosthedude.explorerscompass.workers.SearchWorkerManager;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ExplorersCompassItem
extends class_1792 {
    public static final String NAME = "explorerscompass";
    private SearchWorkerManager workerManager = new SearchWorkerManager();

    public ExplorersCompassItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715()) {
            if (world.field_9236) {
                class_1799 stack = ItemUtils.getHeldItem(player, ExplorersCompass.EXPLORERS_COMPASS_ITEM);
                GuiWrapper.openGUI(world, player, stack);
            } else {
                class_3218 serverWorld = (class_3218)world;
                class_3222 serverPlayer = (class_3222)player;
                boolean canTeleport = ExplorersCompassConfig.allowTeleport && PlayerUtils.canTeleport(player);
                List<class_2960> allowedStructures = StructureUtils.getAllowedStructureIDs(serverWorld);
                ListMultimap<class_2960, class_2960> dimensionsForAllowedStructures = StructureUtils.getGeneratingDimensionIDsForAllowedStructures(serverWorld);
                Map<class_2960, class_2960> structureIDsToGroupIDs = StructureUtils.getStructureIDsToGroupIDs(serverWorld);
                ListMultimap<class_2960, class_2960> groupIDsToStructureIDs = StructureUtils.getGroupIDsToStructureIDs(serverWorld);
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new SyncPacket(canTeleport, allowedStructures, dimensionsForAllowedStructures, structureIDsToGroupIDs, groupIDsToStructureIDs));
            }
        } else {
            this.workerManager.stop();
            this.workerManager.clear();
            this.setState(player.method_5998(hand), null, CompassState.INACTIVE);
        }
        return class_1271.method_22430((Object)player.method_5998(hand));
    }

    public void searchForStructure(class_1937 world, class_1657 player, class_2960 structureID, List<class_2960> structureIDs, class_2338 pos, class_1799 stack) {
        this.setSearching(stack, structureID);
        this.setSearchRadius(stack, 0);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ArrayList<class_3195> structures = new ArrayList<class_3195>();
            for (class_2960 id : structureIDs) {
                structures.add(StructureUtils.getStructureForID(serverWorld, id));
            }
            this.workerManager.stop();
            this.workerManager.createWorkers(serverWorld, player, stack, structures, pos);
            boolean started = this.workerManager.start();
            if (!started) {
                this.setNotFound(stack, 0, 0);
            }
        }
    }

    public void succeed(class_1799 stack, class_2960 structureID, int x, int z, int samples, boolean displayCoordinates) {
        this.setFound(stack, structureID, x, z, samples);
        this.setDisplayCoordinates(stack, displayCoordinates);
        this.workerManager.clear();
    }

    public void fail(class_1799 stack, int radius, int samples) {
        this.workerManager.pop();
        boolean started = this.workerManager.start();
        if (!started) {
            this.setNotFound(stack, radius, samples);
        }
    }

    public boolean isActive(class_1799 stack) {
        if (ItemUtils.isCompass(stack)) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(class_1799 stack, class_2960 structureID) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.STRUCTURE_ID_COMPONENT, (Object)structureID.toString());
            stack.method_57379(ExplorersCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.SEARCHING.getID());
        }
    }

    public void setFound(class_1799 stack, class_2960 structureID, int x, int z, int samples) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.STRUCTURE_ID_COMPONENT, (Object)structureID.toString());
            stack.method_57379(ExplorersCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.FOUND.getID());
            stack.method_57379(ExplorersCompass.FOUND_X_COMPONENT, (Object)x);
            stack.method_57379(ExplorersCompass.FOUND_Z_COMPONENT, (Object)z);
            stack.method_57379(ExplorersCompass.SAMPLES_COMPONENT, (Object)samples);
        }
    }

    public void setNotFound(class_1799 stack, int searchRadius, int samples) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.NOT_FOUND.getID());
            stack.method_57379(ExplorersCompass.SEARCH_RADIUS_COMPONENT, (Object)searchRadius);
            stack.method_57379(ExplorersCompass.SAMPLES_COMPONENT, (Object)samples);
        }
    }

    public void setInactive(class_1799 stack) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.COMPASS_STATE_COMPONENT, (Object)CompassState.INACTIVE.getID());
        }
    }

    public void setState(class_1799 stack, class_2338 pos, CompassState state) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.COMPASS_STATE_COMPONENT, (Object)state.getID());
        }
    }

    public void setFoundStructureX(class_1799 stack, int x) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.FOUND_X_COMPONENT, (Object)x);
        }
    }

    public void setFoundStructureZ(class_1799 stack, int z) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.FOUND_Z_COMPONENT, (Object)z);
        }
    }

    public void setStructureKey(class_1799 stack, class_2960 structureID) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.STRUCTURE_ID_COMPONENT, (Object)structureID.toString());
        }
    }

    public void setSearchRadius(class_1799 stack, int searchRadius) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.SEARCH_RADIUS_COMPONENT, (Object)searchRadius);
        }
    }

    public void setSamples(class_1799 stack, int samples) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.SAMPLES_COMPONENT, (Object)samples);
        }
    }

    public void setDisplayCoordinates(class_1799 stack, boolean displayPosition) {
        if (ItemUtils.isCompass(stack)) {
            stack.method_57379(ExplorersCompass.DISPLAY_COORDS_COMPONENT, (Object)displayPosition);
        }
    }

    public CompassState getState(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.COMPASS_STATE_COMPONENT)) {
            return CompassState.fromID((Integer)stack.method_57824(ExplorersCompass.COMPASS_STATE_COMPONENT));
        }
        return null;
    }

    public int getFoundStructureX(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.FOUND_X_COMPONENT)) {
            return (Integer)stack.method_57824(ExplorersCompass.FOUND_X_COMPONENT);
        }
        return 0;
    }

    public int getFoundStructureZ(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.FOUND_Z_COMPONENT)) {
            return (Integer)stack.method_57824(ExplorersCompass.FOUND_Z_COMPONENT);
        }
        return 0;
    }

    public class_2960 getStructureID(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.STRUCTURE_ID_COMPONENT)) {
            return class_2960.method_60654((String)((String)stack.method_57824(ExplorersCompass.STRUCTURE_ID_COMPONENT)));
        }
        return class_2960.method_60655((String)"", (String)"");
    }

    public int getSearchRadius(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.SEARCH_RADIUS_COMPONENT)) {
            return (Integer)stack.method_57824(ExplorersCompass.SEARCH_RADIUS_COMPONENT);
        }
        return -1;
    }

    public int getSamples(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.SAMPLES_COMPONENT)) {
            return (Integer)stack.method_57824(ExplorersCompass.SAMPLES_COMPONENT);
        }
        return -1;
    }

    public int getDistanceToBiome(class_1657 player, class_1799 stack) {
        return StructureUtils.getHorizontalDistanceToLocation(player, this.getFoundStructureX(stack), this.getFoundStructureZ(stack));
    }

    public boolean shouldDisplayCoordinates(class_1799 stack) {
        if (ItemUtils.isCompass(stack) && stack.method_57826(ExplorersCompass.DISPLAY_COORDS_COMPONENT)) {
            return (Boolean)stack.method_57824(ExplorersCompass.DISPLAY_COORDS_COMPONENT);
        }
        return true;
    }
}

