/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.config;

import com.chaosthedude.explorerscompass.util.OverlaySide;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ExplorersCompassConfig {
    private static Path configFilePath;
    private static Gson gson;
    public static boolean allowTeleport;
    public static boolean displayCoordinates;
    public static int maxRadius;
    public static int maxSamples;
    public static List<String> structureBlacklist;
    public static boolean displayWithChatOpen;
    public static boolean translateStructureNames;
    public static int overlayLineOffset;
    public static OverlaySide overlaySide;

    public static void load() {
        if (ExplorersCompassConfig.getFilePath().toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(ExplorersCompassConfig.getFilePath());
                Data data = (Data)gson.fromJson((Reader)reader, Data.class);
                allowTeleport = data.common.allowTeleport;
                displayCoordinates = data.common.displayCoordinates;
                maxRadius = data.common.maxRadius;
                maxSamples = data.common.maxSamples;
                structureBlacklist = data.common.structureBlacklist;
                displayWithChatOpen = data.client.displayWithChatOpen;
                translateStructureNames = data.client.translateStructureNames;
                overlayLineOffset = data.client.overlayLineOffset;
                overlaySide = data.client.overlaySide;
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ExplorersCompassConfig.save();
    }

    public static void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(ExplorersCompassConfig.getFilePath(), new OpenOption[0]);
            Data data = new Data(new Data.Common(allowTeleport, displayCoordinates, maxRadius, maxSamples, structureBlacklist), new Data.Client(displayWithChatOpen, translateStructureNames, overlayLineOffset, overlaySide));
            gson.toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getFilePath() {
        if (configFilePath == null) {
            configFilePath = FabricLoader.getInstance().getConfigDir().resolve("explorerscompass.json");
        }
        return configFilePath;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        allowTeleport = true;
        displayCoordinates = true;
        maxRadius = 10000;
        maxSamples = 100000;
        structureBlacklist = new ArrayList<String>();
        displayWithChatOpen = true;
        translateStructureNames = true;
        overlayLineOffset = 1;
        overlaySide = OverlaySide.LEFT;
    }

    private static class Data {
        private Common common;
        private Client client;

        public Data(Common common, Client client) {
            this.common = common;
            this.client = client;
        }

        private static class Common {
            private final String allowTeleportComment = "Allows a player to teleport to a located structure when in creative mode, opped, or in cheat mode.";
            private final boolean allowTeleport;
            private final String displayCoordinatesComment = "Allows players to view the precise coordinates and distance of a located structure on the HUD, rather than relying on the direction the compass is pointing.";
            private final boolean displayCoordinates;
            private final String maxRadiusComment = "The maximum radius that will be searched for a structure. Raising this value will increase search accuracy but will potentially make the process more resource intensive.";
            private final int maxRadius;
            private final String maxSamplesComment = "The maximum number of samples to be taken when searching for a structure.";
            private final int maxSamples;
            private final String structureBlacklistComment = "A list of structures that the compass will not display in the GUI and will not be able to search for. The wildcard character * can be used to match any number of characters, and ? can be used to match one character. Ex (ignore backslashes): [\"minecraft:stronghold\", \"minecraft:endcity\", \"minecraft:*village*\"]";
            private final List<String> structureBlacklist;

            private Common() {
                this.allowTeleport = true;
                this.displayCoordinates = true;
                this.maxRadius = 10000;
                this.maxSamples = 100000;
                this.structureBlacklist = new ArrayList<String>();
            }

            private Common(boolean allowTeleport, boolean displayCoordinates, int maxRadius, int maxSamples, List<String> structureBlacklist) {
                this.allowTeleport = allowTeleport;
                this.displayCoordinates = displayCoordinates;
                this.maxRadius = maxRadius;
                this.maxSamples = maxSamples;
                this.structureBlacklist = structureBlacklist;
            }
        }

        private static class Client {
            private final String displayWithChatOpenComment = "Displays compass information even while chat is open.";
            private final boolean displayWithChatOpen;
            private final String translateStructureNamesComment = "Attempts to translate structure names before fixing the unlocalized names. Translations may not be available for all structures.";
            private final boolean translateStructureNames;
            private final String overlayLineOffsetComment = "The line offset for information rendered on the HUD.";
            private final int overlayLineOffset;
            private final String overlaySideComment = "The side for information rendered on the HUD. Ex: LEFT, RIGHT";
            private final OverlaySide overlaySide;

            private Client() {
                this.displayWithChatOpen = true;
                this.translateStructureNames = true;
                this.overlayLineOffset = 1;
                this.overlaySide = OverlaySide.LEFT;
            }

            private Client(boolean displayWithChatOpen, boolean translateStructureNames, int overlayLineOffset, OverlaySide overlaySide) {
                this.displayWithChatOpen = displayWithChatOpen;
                this.translateStructureNames = translateStructureNames;
                this.overlayLineOffset = overlayLineOffset;
                this.overlaySide = overlaySide;
            }
        }
    }
}

