/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.class_5421;
import net.minecraft.class_8786;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.BnCRecipeBookTypes;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegPlaceRecipe;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.container.AbstractedItemHandler;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegMenu
extends class_1729<KegRecipeWrapper, KegFermentingRecipe> {
    public static final class_2960 EMPTY_CONTAINER_SLOT_TANKARD = BrewinAndChewin.asResource("item/empty_container_slot_tankard");
    public final KegBlockEntity blockEntity;
    public final AbstractedItemHandler inventory;
    public final AbstractedFluidTank kegTank;
    private final class_3913 kegData;
    private final class_3914 canInteractWithCallable;
    protected final class_1937 level;
    private final KegRecipeWrapper recipeWrapper;

    public KegMenu(int windowId, class_1661 playerInventory, class_2338 data) {
        this(windowId, playerInventory, KegMenu.getTileEntity(playerInventory, data), (class_3913)new class_3919(4));
    }

    public KegMenu(int windowId, class_1661 playerInventory, KegBlockEntity blockEntity, class_3913 kegDataIn) {
        super(BnCMenuTypes.KEG, windowId);
        int column;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity.getInventory();
        this.kegTank = blockEntity.getFluidTank();
        this.kegData = kegDataIn;
        this.level = playerInventory.field_7546.method_37908();
        this.canInteractWithCallable = class_3914.method_17392((class_1937)blockEntity.method_10997(), (class_2338)blockEntity.method_11016());
        this.recipeWrapper = BrewinAndChewin.getHelper().createRecipeWrapper(this.inventory, this.kegTank);
        int startX = 8;
        int startY = 18;
        int inputStartX = 39;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 2; ++column) {
                this.method_7621(BrewinAndChewin.getHelper().createKegSlot(this.inventory, row * 2 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.method_7621(BrewinAndChewin.getHelper().createKegContainerSlot(this.inventory, 4, 91, 55));
        this.method_7621(BrewinAndChewin.getHelper().createKegResultSlot(this.inventory, 5, 124, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.method_7621(new class_1735((class_1263)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.method_7621(new class_1735((class_1263)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.method_17360(kegDataIn);
    }

    private static KegBlockEntity getTileEntity(class_1661 playerInventory, class_2338 data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        class_2586 tileAtPos = playerInventory.field_7546.method_37908().method_8321(data);
        if (tileAtPos instanceof KegBlockEntity) {
            return (KegBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean method_7597(class_1657 playerIn) {
        return KegMenu.method_17695((class_3914)this.canInteractWithCallable, (class_1657)playerIn, (class_2248)BnCBlocks.KEG);
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        int indexContainerInput = 4;
        int indexOutput = 5;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        class_1799 slotStackCopy = class_1799.field_8037;
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            slotStackCopy = slotStack.method_7972();
            if (index == indexOutput) {
                if (!this.method_7616(slotStack, startPlayerInv, endPlayerInv, true)) {
                    return class_1799.field_8037;
                }
            } else if (index > indexOutput) {
                boolean isValidContainer;
                boolean bl = isValidContainer = slotStack.method_31574(this.blockEntity.getInventory().getStackInSlot(4).method_7909()) || this.blockEntity.getPouringRecipe(slotStack).isPresent();
                if (isValidContainer && !this.method_7616(slotStack, indexContainerInput, indexContainerInput + 1, false)) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(slotStack, 0, indexContainerInput, false)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(slotStack, startPlayerInv, endPlayerInv, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == slotStackCopy.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getFermentProgressionScaled() {
        int i = this.kegData.method_17390(0);
        int j = this.kegData.method_17390(1);
        return j != 0 && i != 0 ? i * 22 / j : 0;
    }

    public float getProgression() {
        return this.kegData.method_17390(0);
    }

    public int getKegTemperature() {
        return this.blockEntity.getTemperature();
    }

    public boolean isFermenting() {
        Optional<class_8786<KegFermentingRecipe>> recipe = this.blockEntity.getRecipeWithoutTemperature();
        return recipe.isPresent() && KegBlockEntity.isValidTemp(this.getKegTemperature(), ((KegFermentingRecipe)recipe.get().comp_1933()).getTemperature());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_17697(boolean placeAll, class_8786<?> recipe, class_3222 player) {
        class_8786<?> recipeHolder = recipe;
        this.method_59963();
        try {
            new KegPlaceRecipe(this, this.level.method_8433()).method_12826(player, recipeHolder, placeAll);
        }
        finally {
            this.method_59964(recipeHolder);
        }
    }

    public void method_7654(class_1662 helper) {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            helper.method_7404(this.inventory.getStackInSlot(i));
        }
    }

    public void method_7657() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, class_1799.field_8037);
        }
    }

    public boolean method_7652(class_8786<KegFermentingRecipe> recipe) {
        return ((KegFermentingRecipe)recipe.comp_1933()).matches(this.recipeWrapper, this.level);
    }

    public int method_7655() {
        return 5;
    }

    public int method_7653() {
        return 2;
    }

    public int method_7656() {
        return 2;
    }

    public int method_7658() {
        return 6;
    }

    public class_5421 method_30264() {
        return BnCRecipeBookTypes.FERMENTING;
    }

    public boolean method_32339(int slot) {
        return slot < this.method_7653() * this.method_7656();
    }
}

