/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.FluidItemComponentRemapper;
import umpaz.brewinandchewin.client.utility.IdentifiableListener;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;

public class BnCFluidItemDisplays {
    private static final Map<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack> FLUID_TYPE_TO_ITEM_MAP = new HashMap<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack>();

    public static class_1799 getFluidItemDisplay(class_7225.class_7874 lookup, AbstractedFluidStack fluid) {
        if (FLUID_TYPE_TO_ITEM_MAP.containsKey(Either.right((Object)fluid.fluid()))) {
            return FLUID_TYPE_TO_ITEM_MAP.get(Either.right((Object)fluid.fluid())).getStack(lookup, fluid);
        }
        Optional<Map.Entry> validTagKey = FLUID_TYPE_TO_ITEM_MAP.entrySet().stream().filter(entry -> (Boolean)((Either)entry.getKey()).map(fluidTagKey -> fluid.fluid().method_15791(fluidTagKey), fluid1 -> false)).findFirst();
        if (validTagKey.isPresent()) {
            return ((FluidBasedItemStack)validTagKey.get().getValue()).getStack(lookup, fluid);
        }
        if (fluid.fluid().method_15774() != class_1802.field_8162) {
            return fluid.fluid().method_15774().method_7854();
        }
        return class_1799.field_8037;
    }

    public record FluidBasedItemStack(Either<class_6862<class_3611>, class_3611> fluid, FluidItemComponentRemapper dataComponentRemapper) {
        private static final HashMap<Pair<class_3611, class_9323>, class_1799> CACHE = new HashMap(32);

        private static FluidBasedItemStack createFromJson(JsonElement json, Either<class_6862<class_3611>, class_3611> fluid) {
            return new FluidBasedItemStack(fluid, (FluidItemComponentRemapper)((Pair)FluidItemComponentRemapper.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst());
        }

        private class_1799 getStack(class_7225.class_7874 lookup, AbstractedFluidStack stack) {
            Pair pair = Pair.of((Object)stack.fluid(), (Object)stack.components());
            if (CACHE.containsKey(pair)) {
                return CACHE.get(pair);
            }
            class_1799 item = this.dataComponentRemapper.convert(lookup, stack);
            CACHE.put((Pair<class_3611, class_9323>)pair, item);
            return item;
        }
    }

    public static class Loader
    extends class_4080<Map<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack>>
    implements IdentifiableListener {
        public static final Loader INSTANCE = new Loader();
        private static final Gson GSON = new GsonBuilder().create();

        protected Loader() {
        }

        protected Map<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack> prepare(class_3300 resourceManager, class_3695 profiler) {
            class_7654 fileToIdConverter = class_7654.method_45114((String)"brewinandchewin/fluid_item_displays");
            FluidBasedItemStack.CACHE.clear();
            HashMap<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack> map = new HashMap<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack>();
            for (Map.Entry entry : fileToIdConverter.method_45116(resourceManager).entrySet()) {
                for (class_3298 resource : (List)entry.getValue()) {
                    try {
                        BufferedReader reader = resource.method_43039();
                        try {
                            JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                            for (Map.Entry e : jsonObject.entrySet()) {
                                Either either;
                                boolean isCurrentOptional;
                                boolean bl = isCurrentOptional = ((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().has("optional") && ((JsonElement)e.getValue()).getAsJsonObject().get("optional").getAsBoolean();
                                if (((String)e.getKey()).startsWith("#")) {
                                    either = Either.left((Object)class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)class_2960.method_60654((String)((String)e.getKey()).substring(1))));
                                } else {
                                    class_2960 fluidLocation = class_2960.method_60654((String)((String)e.getKey()));
                                    if (!class_7923.field_41173.method_10250(fluidLocation)) {
                                        if (isCurrentOptional) continue;
                                        BrewinAndChewin.LOG.error("Could not find fluid '{}' from fluid item display JSON at location '{}' from pack '{}'.", new Object[]{e.getKey(), entry.getKey(), resource.method_14480()});
                                        continue;
                                    }
                                    either = Either.right((Object)((class_3611)class_7923.field_41173.method_10223(fluidLocation)));
                                }
                                try {
                                    map.put((Either<class_6862<class_3611>, class_3611>)either, FluidBasedItemStack.createFromJson((JsonElement)e.getValue(), (Either<class_6862<class_3611>, class_3611>)either));
                                }
                                catch (JsonParseException | IllegalArgumentException | IllegalStateException | class_151 ex) {
                                    if (isCurrentOptional) continue;
                                    BrewinAndChewin.LOG.error("Couldn't parse fluid item display JSON at location '{}' from pack '{}'. ", new Object[]{entry.getKey(), resource.method_14480(), ex});
                                }
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException | IllegalStateException | class_151 ex) {
                        BrewinAndChewin.LOG.error("Couldn't parse fluid item display JSON at location '{}' from pack '{}'. ", new Object[]{entry.getKey(), resource.method_14480(), ex});
                    }
                }
            }
            return map;
        }

        protected void apply(Map<Either<class_6862<class_3611>, class_3611>, FluidBasedItemStack> obj, class_3300 resourceManager, class_3695 profiler) {
            FLUID_TYPE_TO_ITEM_MAP.putAll(obj);
        }

        @Override
        public class_2960 getId() {
            return BrewinAndChewin.asResource("coaster_models");
        }
    }
}

