/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;

public class SimpleFluidStack
implements class_9322 {
    private static final Codec<class_3611> FLUID_NON_EMPTY_CODEC = class_7923.field_41173.method_39673().validate(fluid -> fluid == class_3612.field_15906 ? DataResult.error(() -> "Fluid must not be empty") : DataResult.success((Object)fluid));
    public static final Codec<SimpleFluidStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41173.method_39673().fieldOf("id").forGetter(SimpleFluidStack::fluid), (App)Codec.LONG.validate(aLong -> aLong > 0L ? DataResult.success((Object)aLong) : DataResult.error(() -> "Value must be positive: " + aLong)).fieldOf("amount").forGetter(SimpleFluidStack::amount), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(stack -> stack.components.method_57940())).apply((Applicative)instance, SimpleFluidStack::new)));
    private final class_3611 fluid;
    private long amount;
    private final class_9335 components;

    public SimpleFluidStack(class_3611 fluid, long amount) {
        this(fluid, amount, new class_9335(class_9323.field_49584));
    }

    public SimpleFluidStack(class_3611 fluid, long amount, class_9326 components) {
        this(fluid, amount, class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)components));
    }

    public SimpleFluidStack(class_3611 fluid, long amount, class_9335 components) {
        this.fluid = fluid;
        this.amount = amount;
        this.components = components;
    }

    public SimpleFluidStack copy() {
        return new SimpleFluidStack(this.fluid(), this.amount(), this.getComponents().method_57941());
    }

    public boolean isEmpty() {
        return this.fluid == class_3612.field_15906 || this.amount() <= 0L;
    }

    public class_3611 fluid() {
        return this.fluid;
    }

    public long amount() {
        return this.amount;
    }

    public void amount(long amount) {
        this.amount = amount;
    }

    public class_9335 getComponents() {
        return this.components;
    }

    @Nullable
    public <T> T set(class_9331<? super T> componentType, @Nullable T value) {
        return (T)this.components.method_57938(componentType, value);
    }

    @Nullable
    public <T, U> T update(class_9331<T> componentType, T value, U updateContext, BiFunction<T, U, T> updater) {
        return this.set(componentType, updater.apply(this.method_57825(componentType, value), updateContext));
    }

    @Nullable
    public <T> T update(class_9331<T> componentType, T value, UnaryOperator<T> updater) {
        return this.set(componentType, updater.apply(this.method_57825(componentType, value)));
    }

    public <T> T remove(class_9331<? extends T> componentType) {
        return (T)this.components.method_57939(componentType);
    }

    public void applyComponents(class_9326 patch) {
        this.components.method_57936(patch);
    }

    public void applyComponents(class_9323 components) {
        this.components.method_57933(components);
    }

    public static boolean matches(SimpleFluidStack first, SimpleFluidStack second) {
        if (first == second) {
            return true;
        }
        return first.amount() == second.amount() && SimpleFluidStack.isSameFluidSameComponents(first, second);
    }

    public static boolean isSameFluidSameComponents(SimpleFluidStack first, SimpleFluidStack second) {
        if (first.fluid() != second.fluid()) {
            return false;
        }
        return first.isEmpty() && second.isEmpty() || Objects.equals(first.components, second.components);
    }

    public static int hashFluidAndComponents(@Nullable SimpleFluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.fluid().hashCode();
            return 31 * i + stack.getComponents().hashCode();
        }
        return 0;
    }
}

