/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.util.ArrayUtil;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_8957;

public class RecipeUtil {
    public static IIngredient[][] shrink(IIngredient[][] ingredients) {
        int top = ingredients.length;
        int left = Integer.MAX_VALUE;
        int right = 0;
        int bottom = 0;
        for (int rowI = 0; rowI < ingredients.length; ++rowI) {
            IIngredient[] row = ingredients[rowI];
            for (int colI = 0; colI < row.length; ++colI) {
                IIngredient ingredient = row[colI];
                if (ingredient == null || ingredient.isEmpty()) continue;
                top = Math.min(top, rowI);
                bottom = Math.max(bottom, rowI);
                left = Math.min(left, colI);
                right = Math.max(right, colI);
            }
        }
        if (left == Integer.MAX_VALUE) {
            return new IIngredient[0][0];
        }
        IIngredient[][] output = new IIngredient[bottom - top + 1][right - left + 1];
        for (int rowI = 0; rowI < output.length; ++rowI) {
            IIngredient[] row = output[rowI];
            for (int colI = 0; colI < row.length; ++colI) {
                output[rowI][colI] = ingredients[top + rowI].length <= left + colI ? IIngredientEmpty.getInstance() : ingredients[top + rowI][left + colI];
            }
        }
        return output;
    }

    public static IIngredient[][] inflate(List<IIngredient> flattened, int width, int height) {
        IIngredient[][] inflated = new IIngredient[height][width];
        int ingredientIndex = 0;
        for (int row = 0; row < height; ++row) {
            int col = 0;
            while (col < width) {
                inflated[row][col] = flattened.get(ingredientIndex);
                ++col;
                ++ingredientIndex;
            }
        }
        return inflated;
    }

    public static List<IIngredient> flatten(IIngredient[][] ingredients, int width, int height) {
        int size = width * height;
        List<IIngredient> flattened = Arrays.asList(new IIngredient[size]);
        for (int i = 0; i < size; ++i) {
            flattened.set(i, ingredients[i / width][i % width]);
        }
        return flattened;
    }

    public static class_8957 createPattern(IIngredient[][] ingredients) {
        int width = ArrayUtil.getMaxWidth(ingredients);
        int height = ingredients.length;
        return RecipeUtil.createPattern(ArrayUtil.flattenToNNL(width, height, ingredients, () -> class_1856.field_9017, IIngredient::asVanillaIngredient), width, height);
    }

    public static class_8957 createPattern(class_2371<class_1856> flatIngredients, int width, int height) {
        char start = 'a';
        HashMap<Character, class_1856> keys = new HashMap<Character, class_1856>();
        LinkedList<String> pattern = new LinkedList<String>();
        int ingredientIndex = 0;
        for (int row = 0; row < height; ++row) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < width; ++col) {
                class_1856 ingredient;
                if ((ingredient = (class_1856)flatIngredients.get(ingredientIndex++)).method_8103()) {
                    rowPattern.append(" ");
                    continue;
                }
                char c = start;
                start = (char)(start + 1);
                char key = c;
                keys.put(Character.valueOf(key), ingredient);
                rowPattern.append(key);
            }
            pattern.add(rowPattern.toString());
        }
        return class_8957.method_55085(keys, pattern);
    }

    public static IIngredient[][] dissolvePattern(String[] pattern, Map<String, IIngredient> keys, int width, int height) {
        keys.put(" ", IIngredientEmpty.INSTANCE);
        IIngredient[][] ingredients = new IIngredient[height][width];
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int row = 0; row < pattern.length; ++row) {
            for (int col = 0; col < pattern[row].length(); ++col) {
                String s = pattern[row].substring(col, col + 1);
                IIngredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new IllegalArgumentException("Pattern references symbol '" + s + "' but it is not defined in the key");
                }
                set.remove(s);
                ingredients[row][col] = ingredient;
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return ingredients;
    }
}

