/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.type;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapelessRecipeSerializer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;

public class CTShapelessRecipe
extends class_1867 {
    private final IIngredient[] ctIngredients;
    private final IItemStack output;
    @Nullable
    private final RecipeFunction1D function;

    public CTShapelessRecipe(IItemStack output, IIngredient[] ingredients) {
        this(class_7710.field_40251, output, ingredients, null);
    }

    public CTShapelessRecipe(IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        this(class_7710.field_40251, output, ingredients, function);
    }

    public CTShapelessRecipe(class_7710 category, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        super("", category, output.getInternal(), class_2371.method_10211());
        this.output = output;
        this.function = function;
        boolean containsNull = false;
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.asVanillaIngredient().method_8103()) continue;
            containsNull = true;
            break;
        }
        if (containsNull) {
            ingredients = (IIngredient[])Arrays.stream(ingredients).filter(Objects::nonNull).filter(iIngredient -> !iIngredient.asVanillaIngredient().method_8103()).toArray(IIngredient[]::new);
        }
        this.ctIngredients = ingredients;
        this.method_8117().addAll(Arrays.stream(this.ctIngredients).map(IIngredient::asVanillaIngredient).toList());
    }

    public static boolean checkEmptyIngredient(class_2960 name, IIngredient[] ingredients) {
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.asVanillaIngredient().method_8103()) continue;
            CommonLoggers.api().warn("Shapeless recipe with ID '{}' contains null or empty ingredients, entries will be removed!", (Object)name);
            return true;
        }
        return false;
    }

    public boolean method_17730(class_9694 inv, class_1937 worldIn) {
        boolean[] visited = this.forAllUniqueMatches(inv, (ingredientIndex, matchingSlot, stack) -> {});
        int visitedCount = 0;
        for (int slot = 0; slot < visited.length; ++slot) {
            if (visited[slot]) {
                ++visitedCount;
                continue;
            }
            if (inv.method_59984(slot).method_7960()) continue;
            return false;
        }
        return visitedCount == this.ctIngredients.length;
    }

    public class_1799 method_17729(class_9694 inv, class_7225.class_7874 lookup) {
        if (this.function == null) {
            return this.output.getInternal().method_7972();
        }
        IItemStack[] stacks = new IItemStack[this.ctIngredients.length];
        this.forAllUniqueMatches(inv, (ingredientIndex, matchingSlot, stack) -> {
            stacks[ingredientIndex] = stack.withAmount(1);
        });
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    @Nullable
    public RecipeFunction1D getFunction() {
        return this.function;
    }

    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return this.output.getInternal().method_7972();
    }

    public class_2371<class_1799> getRemainingItems(class_9694 inv) {
        class_2371 remainingItems = class_2371.method_10213((int)inv.method_59983(), (Object)class_1799.field_8037);
        this.forAllUniqueMatches(inv, (ingredientIndex, matchingSlot, stack) -> remainingItems.set(matchingSlot, (Object)this.ctIngredients[ingredientIndex].getRemainingItem(stack).getInternal()));
        return remainingItems;
    }

    private boolean[] forAllUniqueMatches(class_9694 inv, ForAllUniqueAction action) {
        boolean[] visited = new boolean[inv.method_59983()];
        block0: for (int ingredientIndex = 0; ingredientIndex < this.ctIngredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ctIngredients[ingredientIndex];
            for (int i = 0; i < inv.method_59983(); ++i) {
                IItemStack stack;
                class_1799 stackInSlot;
                if (visited[i] || (stackInSlot = inv.method_59984(i)).method_7960() || !ingredient.matches(stack = IItemStack.of(stackInSlot))) continue;
                visited[i] = true;
                action.accept(ingredientIndex, i, stack);
                continue block0;
            }
        }
        return visited;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        for (IIngredient ingredient : this.ctIngredients) {
            ingredients.add((Object)ingredient.asVanillaIngredient());
        }
        return ingredients;
    }

    public class_2371<IIngredient> getFlatCtIngredients() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.addAll(Arrays.asList(this.ctIngredients));
        return ingredients;
    }

    public class_1865<CTShapelessRecipe> method_8119() {
        return CTShapelessRecipeSerializer.INSTANCE;
    }

    public IIngredient[] getCtIngredients() {
        return this.ctIngredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CTShapelessRecipe that = (CTShapelessRecipe)((Object)o);
        return Arrays.equals(this.ctIngredients, that.ctIngredients) && Objects.equals(this.output, that.output) && Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        int result = Objects.hash(this.output, this.function);
        result = 31 * result + Arrays.hashCode(this.ctIngredients);
        return result;
    }

    @FunctionalInterface
    private static interface ForAllUniqueAction {
        public void accept(int var1, int var2, IItemStack var3);
    }
}

