/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.api.util.RecipeUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class CTShapedRecipeSerializer
implements class_1865<CTShapedRecipe> {
    public static final CTShapedRecipeSerializer INSTANCE = new CTShapedRecipeSerializer();
    public static final MapCodec<CTShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IItemStack.CODEC.fieldOf("output").forGetter(CTShapedRecipe::getCtOutput), (App)IIngredient.CODEC.listOf().listOf().fieldOf("ingredients").xmap(lists -> (IIngredient[][])lists.stream().map(ingredients -> (IIngredient[])ingredients.toArray(IIngredient[]::new)).toArray(x$0 -> new IIngredient[x$0][]), ingredients -> Arrays.stream(ingredients).map(iIngredients -> Arrays.stream(iIngredients).toList()).toList()).forGetter(CTShapedRecipe::getCtIngredients), (App)MirrorAxis.CODEC.fieldOf("mirror_axis").forGetter(CTShapedRecipe::getMirrorAxis)).apply((Applicative)instance, CTShapedRecipe::new));
    public static final class_9139<class_9129, CTShapedRecipe> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48550, class_1869::method_8158, (class_9139)class_9135.field_48550, class_1869::method_8150, (class_9139)IIngredient.STREAM_CODEC.method_56433(class_9135.method_56363()), CTShapedRecipe::getFlatCtIngredients, IItemStack.STREAM_CODEC, CTShapedRecipe::getCtOutput, (class_9139)new class_9139<class_9129, MirrorAxis>(){

        public MirrorAxis decode(class_9129 buffer) {
            return (MirrorAxis)buffer.method_10818(MirrorAxis.class);
        }

        public void encode(class_9129 buffer, MirrorAxis axis) {
            buffer.method_10817((Enum)axis);
        }
    }, CTShapedRecipe::getMirrorAxis, (height, width, ingredients, output, mirrorAxis) -> new CTShapedRecipe((IItemStack)output, RecipeUtil.inflate(ingredients, width, height), (MirrorAxis)((Object)mirrorAxis)));

    private CTShapedRecipeSerializer() {
    }

    public MapCodec<CTShapedRecipe> method_53736() {
        return CODEC;
    }

    public class_9139<class_9129, CTShapedRecipe> method_56104() {
        return STREAM_CODEC;
    }

    private static CTShapedRecipe fromNetwork(class_9129 buffer) {
        int height = buffer.method_10816();
        int width = buffer.method_10816();
        IIngredient[][] inputs = new IIngredient[height][width];
        for (int h = 0; h < inputs.length; ++h) {
            for (int w = 0; w < inputs[h].length; ++w) {
                inputs[h][w] = IIngredient.fromIngredient((class_1856)class_1856.field_48355.decode((Object)buffer));
            }
        }
        MirrorAxis mirrorAxis = (MirrorAxis)buffer.method_10818(MirrorAxis.class);
        class_1799 output = (class_1799)class_1799.field_48349.decode((Object)buffer);
        return CTShapedRecipeSerializer.makeRecipe(IItemStack.of(output), inputs, mirrorAxis, null);
    }

    private static void toNetwork(class_9129 buffer, CTShapedRecipe recipe) {
        buffer.method_10804(recipe.method_8158());
        buffer.method_10804(recipe.method_8150());
        for (class_1856 ingredient : recipe.method_8117()) {
            class_1856.field_48355.encode((Object)buffer, (Object)ingredient);
        }
        buffer.method_10817((Enum)recipe.getMirrorAxis());
        class_1799.field_48349.encode((Object)buffer, (Object)AccessibleElementsProvider.get().registryAccess(recipe::method_8110));
    }

    private static CTShapedRecipe makeRecipe(IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        return new CTShapedRecipe(output, ingredients, mirrorAxis, function);
    }
}

