/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.villager;

import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.villager.ITradeRemover;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3853;

public class ActionRemoveWanderingTrade
extends ActionTradeBase {
    private final ITradeRemover tradeRemover;
    private final List<class_3853.class_1652> removed;

    public ActionRemoveWanderingTrade(int level, ITradeRemover tradeRemover) {
        super(level);
        this.tradeRemover = tradeRemover;
        this.removed = new ArrayList<class_3853.class_1652>();
    }

    @Override
    protected Int2ObjectMap<class_3853.class_1652[]> getTrades() {
        return class_3853.field_17724;
    }

    @Override
    public void apply() {
        List<class_3853.class_1652> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<class_3853.class_1652> tradeList) {
        tradeList.forEach(iTrade -> {
            if (this.tradeRemover.shouldRemove((class_3853.class_1652)iTrade)) {
                this.removed.add((class_3853.class_1652)iTrade);
            }
        });
        tradeList.removeAll(this.removed);
    }

    @Override
    public String describe() {
        return String.format("Removing Wandering Trader trade for Level: '%s'", this.level);
    }

    @Override
    public void undo() {
        List<class_3853.class_1652> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<class_3853.class_1652> tradeList) {
        tradeList.addAll(this.removed);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing removal of Wandering Trader trade for Level: '%s'", this.level);
    }
}

