/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BigTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection4;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection5;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.OreDeposit;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoom;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoomDungeon;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelStairs;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelTurn;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.ZombieVillagerRoom;
import net.minecraft.class_2350;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5819;
import net.minecraft.class_6130;

public class BetterMineshaftGenerator {
    public static void generateAndAddBigTunnelPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, int x, int y, int z, class_2350 direction, int chainLength) {
        if (chainLength > 3) {
            return;
        }
        int rand = randomSource.method_43048(100);
        BetterMineshaftConfiguration config = ((BetterMineshaftPiece)structurePiece).config;
        if (rand >= 10 || chainLength < 2) {
            class_3341 boundingBox = BigTunnel.determineBoxPosition(x, y, z, direction);
            BigTunnel newPiece = new BigTunnel(chainLength + 1, boundingBox, direction, config);
            structurePieceAccessor.method_35462((class_3443)newPiece);
            ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
        }
    }

    public static BetterMineshaftPiece generateAndAddSmallTunnelPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, int x, int y, int z, class_2350 direction, int chainLength) {
        int rand = randomSource.method_43048(100);
        BetterMineshaftConfiguration config = ((BetterMineshaftPiece)structurePiece).config;
        if (chainLength > BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            if (rand < BetterMineshaftsCommon.CONFIG.spawnRates.zombieVillagerRoomSpawnRate) {
                if (direction == class_2350.field_11043) {
                    --x;
                } else if (direction == class_2350.field_11034) {
                    --z;
                } else if (direction == class_2350.field_11035) {
                    ++x;
                } else if (direction == class_2350.field_11039) {
                    ++z;
                }
                class_3341 boundingBox = ZombieVillagerRoom.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
                if (boundingBox != null) {
                    ZombieVillagerRoom newPiece = new ZombieVillagerRoom(chainLength + 1, boundingBox, direction, config);
                    structurePieceAccessor.method_35462((class_3443)newPiece);
                    ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                    return newPiece;
                }
            } else {
                if (!BetterMineshaftsCommon.CONFIG.ores.enabled) {
                    return null;
                }
                class_3341 boundingBox = OreDeposit.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
                if (boundingBox != null) {
                    OreDeposit newPiece = new OreDeposit(chainLength + 1, boundingBox, direction, config);
                    structurePieceAccessor.method_35462((class_3443)newPiece);
                    ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                    return newPiece;
                }
            }
            return null;
        }
        if (rand >= 90 && chainLength > 2 && chainLength < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            class_3341 boundingBox = LayeredIntersection4.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
            if (boundingBox != null) {
                LayeredIntersection4 newPiece = new LayeredIntersection4(chainLength + 1, boundingBox, direction, config);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                return newPiece;
            }
        } else if (rand >= 80 && chainLength < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            class_3341 boundingBox = SmallTunnelStairs.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
            if (boundingBox != null) {
                SmallTunnelStairs newPiece = new SmallTunnelStairs(chainLength + 1, boundingBox, direction, config);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                return newPiece;
            }
        } else if (rand >= 70 && chainLength > 2) {
            class_3341 boundingBox = SmallTunnelTurn.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
            if (boundingBox != null) {
                SmallTunnelTurn newPiece = new SmallTunnelTurn(chainLength + 1, randomSource, boundingBox, direction, config);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                return newPiece;
            }
        } else if (rand >= 60 && chainLength > 2 && chainLength < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            class_3341 boundingBox = LayeredIntersection5.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
            if (boundingBox != null) {
                LayeredIntersection5 newPiece = new LayeredIntersection5(chainLength + 1, boundingBox, direction, config);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                return newPiece;
            }
        } else {
            class_3341 boundingBox = SmallTunnel.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
            if (boundingBox != null) {
                SmallTunnel newPiece = new SmallTunnel(chainLength + 1, boundingBox, direction, config);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
                return newPiece;
            }
        }
        return null;
    }

    public static BetterMineshaftPiece generateAndAddSideRoomPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, int x, int y, int z, class_2350 direction, int chainLength) {
        BetterMineshaftConfiguration config = ((BetterMineshaftPiece)structurePiece).config;
        class_3341 boundingBox = SideRoom.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
        if (boundingBox != null) {
            SideRoom newPiece = new SideRoom(chainLength + 1, boundingBox, direction, config);
            structurePieceAccessor.method_35462((class_3443)newPiece);
            ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
            return newPiece;
        }
        return null;
    }

    public static BetterMineshaftPiece generateAndAddSideRoomDungeonPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, int x, int y, int z, class_2350 direction, int chainLength) {
        BetterMineshaftConfiguration config = ((BetterMineshaftPiece)structurePiece).config;
        class_3341 boundingBox = SideRoomDungeon.determineBoxPosition(structurePieceAccessor, x, y, z, direction);
        if (boundingBox != null) {
            SideRoomDungeon newPiece = new SideRoomDungeon(chainLength + 1, boundingBox, direction, config);
            structurePieceAccessor.method_35462((class_3443)newPiece);
            ((BetterMineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, randomSource);
            return newPiece;
        }
        return null;
    }
}

