/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class EmojiFromEmojipedia
extends Emoji {
    public class_1049 img;
    public class_2960 resourceLocation = loading_texture;

    @Override
    public void checkLoad() {
        if (this.img != null) {
            return;
        }
        this.img = new DownloadImageData(new File("emojiful/cache/" + this.name + "-" + this.version), "https://cdn.emojidex.com/emoji/px32/" + this.location + ".png", loading_texture);
        this.resourceLocation = class_2960.method_60655((String)"emojiful", (String)("texures/emoji/" + this.location.toLowerCase() + "_" + this.version));
        class_310.method_1551().method_1531().method_4616(this.resourceLocation, (class_1044)this.img);
    }

    @Override
    public class_2960 getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.method_4528();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public class DownloadImageData
    extends class_1049 {
        private final File cacheFile;
        private final String imageUrl;
        private class_1011 nativeImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public DownloadImageData(File cacheFileIn, String imageUrlIn, class_2960 textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.nativeImage != null) {
                if (this.field_5224 != null) {
                    this.method_4528();
                }
                TextureUtil.prepareImage((int)super.method_4624(), (int)this.nativeImage.method_4307(), (int)this.nativeImage.method_4323());
                this.nativeImage.method_4301(0, 0, 0, true);
                this.textureUploaded = true;
            }
        }

        private void setImage(class_1011 nativeImageIn) {
            class_310.method_1551().execute(() -> {
                this.textureUploaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
                } else {
                    this.upload(nativeImageIn);
                }
            });
        }

        private void upload(class_1011 imageIn) {
            TextureUtil.prepareImage((int)this.method_4624(), (int)imageIn.method_4307(), (int)imageIn.method_4323());
            imageIn.method_4301(0, 0, 0, true);
        }

        @Nullable
        private class_1011 loadTexture(InputStream inputStreamIn) {
            class_1011 nativeimage = null;
            try {
                nativeimage = class_1011.method_4309((InputStream)inputStreamIn);
            }
            catch (IOException ioexception) {
                Constants.LOG.warn("Error while loading the skin texture", (Throwable)ioexception);
            }
            return nativeimage;
        }

        public void method_4625(class_3300 resourceManager) throws IOException {
            if (this.imageThread == null) {
                if (this.cacheFile != null && this.cacheFile.isFile()) {
                    try {
                        FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                        this.setImage(this.loadTexture(fileinputstream));
                    }
                    catch (IOException ioexception) {
                        this.loadTextureFromServer();
                    }
                } else {
                    this.loadTextureFromServer();
                }
            }
        }

        protected void loadTextureFromServer() {
            this.imageThread = new Thread("Emojiful Texture Downloader #" + Emoji.threadDownloadCounter.incrementAndGet()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(DownloadImageData.this.imageUrl).openConnection(class_310.method_1551().method_1487());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputStream;
                            int contentLength = httpurlconnection.getContentLength();
                            if (DownloadImageData.this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)DownloadImageData.this.cacheFile);
                                inputStream = new FileInputStream(DownloadImageData.this.cacheFile);
                            } else {
                                inputStream = httpurlconnection.getInputStream();
                            }
                            DownloadImageData.this.setImage(DownloadImageData.this.loadTexture(inputStream));
                        } else {
                            EmojiFromEmojipedia.this.resourceLocation = Emoji.noSignal_texture;
                            EmojiFromEmojipedia.this.deleteOldTexture = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EmojiFromEmojipedia.this.resourceLocation = Emoji.error_texture;
                        EmojiFromEmojipedia.this.deleteOldTexture = true;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

