/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.Map;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.EntityDifficultyScalable;
import net.dungeon_difficulty.logic.MathHelper;
import net.dungeon_difficulty.logic.PatternMatching;
import net.dungeon_difficulty.logic.PerPlayerDifficulty;
import net.dungeon_difficulty.mixin.AccessorAttributeContainer;
import net.dungeon_difficulty.mixin.AccessorDefaultAttributeContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EntityScaling {
    public static void scale(class_1297 entity, class_3218 world) {
        if (entity instanceof class_1657) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            EntityDifficultyScalable scalableEntity = (EntityDifficultyScalable)livingEntity;
            if (scalableEntity.isAlreadyScaled()) {
                return;
            }
            PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, livingEntity.method_24515());
            PatternMatching.EntityData entityData = PatternMatching.EntityData.create(livingEntity);
            scalableEntity.setScalingLocationData(locationData);
            float relativeHealth = livingEntity.method_6032() / livingEntity.method_6063();
            EntityScaling.apply(PerPlayerDifficulty.getAttributeModifiers(entityData, world), livingEntity);
            PatternMatching.EntityScaleResult locationScaling = PatternMatching.getAttributeModifiersForEntity(locationData, entityData, world);
            EntityScaling.apply(locationScaling, livingEntity);
            scalableEntity.markAlreadyScaled(locationScaling.level());
            livingEntity.method_6033(relativeHealth * livingEntity.method_6063());
        }
    }

    private static void apply(PatternMatching.EntityScaleResult scaling, class_1309 entity) {
        int level = scaling.level();
        if (level <= 0) {
            return;
        }
        for (Config.AttributeModifier modifier : scaling.modifiers()) {
            String pattern = modifier.attribute;
            if (pattern == null || pattern.isEmpty()) continue;
            ArrayList<Object> matchingAttributes = new ArrayList<Object>();
            if (pattern.startsWith("~")) {
                String regex = pattern.substring("~".length());
                Map<class_6880<class_1320>, class_1324> instances = ((AccessorDefaultAttributeContainer)((Object)((AccessorAttributeContainer)entity.method_6127()))).getInstances();
                for (Map.Entry<class_6880<class_1320>, class_1324> entry : instances.entrySet()) {
                    String id;
                    class_6880<class_1320> class_68802 = entry.getKey();
                    if (class_68802 == null || class_68802.comp_349() == null || !PatternMatching.regexMatches(id = ((class_1320)class_68802.comp_349()).toString(), regex)) continue;
                    matchingAttributes.add(entry.getKey());
                }
            } else {
                class_6880.class_6883 attribute = class_7923.field_41190.method_55841(class_2960.method_60654((String)modifier.attribute)).orElse(null);
                if (attribute == null || !entity.method_6127().method_45331((class_6880)attribute)) continue;
                matchingAttributes.add(attribute);
            }
            float modifierValue = modifier.randomizedValue(level);
            float roundingUnit = modifier.value * 0.25f;
            modifierValue = (float)MathHelper.round(modifierValue, roundingUnit);
            class_2960 id = class_2960.method_60655((String)"dungeon_difficulty", (String)scaling.name());
            for (class_6880 class_68803 : matchingAttributes) {
                class_1322.class_1323 operation = switch (modifier.operation) {
                    default -> throw new MatchException(null, null);
                    case Config.Operation.ADDITION -> class_1322.class_1323.field_6328;
                    case Config.Operation.MULTIPLY_BASE -> class_1322.class_1323.field_6330;
                };
                class_1322 entityModifier = new class_1322(id, (double)modifierValue, operation);
                class_1324 instance = entity.method_5996(class_68803);
                if (instance == null || instance.method_6196(id)) continue;
                instance.method_26837(entityModifier);
            }
        }
    }
}

