/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.datagen;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.jewelry.datagen.JewelryCraftingRecipes;
import net.jewelry.items.Gems;
import net.jewelry.items.JewelryItems;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class JewelryDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(JewelryCraftingRecipes::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(UnsmeltGenerator::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public String method_10321() {
            return "Jewelry Unsmelt Recipes";
        }

        public void method_10419(class_8790 exporter) {
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.gold_ring.item()), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.iron_ring.item()), class_1802.field_8675);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.emerald_necklace.item()), class_1802.field_8687);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.diamond_necklace.item()), class_1802.field_8477);
            UnsmeltGenerator.disassemble(exporter, JewelryItems.all.stream().filter(entry -> entry.tier() == 2).map(entry -> entry.item()).toList(), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, JewelryItems.all.stream().filter(entry -> entry.id().method_12832().contains("netherite")).map(entry -> entry.item()).toList(), class_1802.field_22021);
        }

        private static void disassemble(class_8790 exporter, List<class_1935> items, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
            Gems.all.forEach(gem -> itemModelGenerator.method_25733(gem.item(), class_4943.field_22938));
            JewelryItems.all.forEach(entry -> itemModelGenerator.method_25733(entry.item(), class_4943.field_22938));
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateJewelryTags();
            this.generateLootTierTags();
        }

        private void generateJewelryTags() {
            FabricTagProvider.FabricTagBuilder gemsTag = this.getOrCreateTagBuilder(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"jewelry", (String)"gems")));
            Gems.all.forEach(gem -> gemsTag.addOptional(gem.id()));
            FabricTagProvider.FabricTagBuilder ringsTag = this.getOrCreateTagBuilder(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"jewelry", (String)"rings")));
            JewelryItems.all.stream().filter(entry -> entry.id().method_12832().contains("ring")).forEach(entry -> ringsTag.addOptional(entry.id()));
            FabricTagProvider.FabricTagBuilder necklacesTag = this.getOrCreateTagBuilder(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"jewelry", (String)"necklaces")));
            JewelryItems.all.stream().filter(entry -> entry.id().method_12832().contains("necklace")).forEach(entry -> necklacesTag.addOptional(entry.id()));
        }

        private void generateLootTierTags() {
            HashMap<class_2960, Equipment.LootProperties> accessoriesMap = new HashMap<class_2960, Equipment.LootProperties>();
            for (JewelryItems.Entry entry : JewelryItems.all) {
                Equipment.LootProperties lootProperties = new Equipment.LootProperties(entry.tier(), null);
                accessoriesMap.put(entry.id(), lootProperties);
            }
            this.generateAccessoryTags(accessoriesMap);
        }
    }
}

