/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.geom.Point2D;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class RenderUtils {
    public static class_241 toScreenCoords(Matrix4f matrix, double x, double y) {
        Matrix4f inverse = new Matrix4f((Matrix4fc)matrix);
        inverse.invert();
        return RenderUtils.toViewportCoords(inverse, x, y);
    }

    public static class_241 toViewportCoords(Matrix4f matrix, double x, double y) {
        Vector4f vec = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
        vec = matrix.transform(vec);
        return new class_241(vec.x(), vec.y());
    }

    private boolean isPointInQuad(double x, double y, Point2D[] quad) {
        return this.pointInTriangle(x, y, quad[0], quad[1], quad[2]) || this.pointInTriangle(x, y, quad[0], quad[2], quad[3]);
    }

    private boolean pointInTriangle(double px, double py, Point2D a, Point2D b, Point2D c) {
        double area = 0.5 * (-b.getY() * c.getX() + a.getY() * (-b.getX() + c.getX()) + a.getX() * (b.getY() - c.getY()) + b.getX() * c.getY());
        double sign = area < 0.0 ? -1.0 : 1.0;
        double s = (a.getY() * c.getX() - a.getX() * c.getY() + (c.getY() - a.getY()) * px + (a.getX() - c.getX()) * py) * sign;
        double t = (a.getX() * b.getY() - a.getY() * b.getX() + (a.getY() - b.getY()) * px + (b.getX() - a.getX()) * py) * sign;
        return s >= 0.0 && t >= 0.0 && s + t <= 2.0 * area * sign;
    }

    public static void renderTextureFromCenter(class_4587 matrix, float centerX, float centerY, float width, float height, float scale, float zOffset) {
        RenderUtils.renderTextureFromCenter(matrix, centerX, centerY, 0.0f, 0.0f, width, height, width, height, scale, zOffset);
    }

    public static void renderTextureFromCenter(class_4587 matrix, float centerX, float centerY, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, float scale, float zOffset) {
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        RenderSystem.setShader(class_757::method_34542);
        matrix.method_22903();
        matrix.method_46416(centerX, centerY, 0.0f);
        matrix.method_22905(scale, scale, scale);
        Matrix4f m = matrix.method_23760().method_23761();
        float u1 = texOffX / texWidth;
        float u2 = (texOffX + width) / texWidth;
        float v1 = texOffY / texHeight;
        float v2 = (texOffY + height) / texHeight;
        float w2 = width / 2.0f;
        float h2 = height / 2.0f;
        builder.method_22918(m, -w2, h2, zOffset).method_22913(u1, v2);
        builder.method_22918(m, w2, h2, zOffset).method_22913(u2, v2);
        builder.method_22918(m, w2, -h2, zOffset).method_22913(u2, v1);
        builder.method_22918(m, -w2, -h2, zOffset).method_22913(u1, v1);
        matrix.method_22909();
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public static void renderTilingTexture(class_4587 matrix, float x, float y, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, float zOffset, boolean tileHorizontally, boolean tileVertically) {
        RenderSystem.setShader(class_757::method_34542);
        int wrapS = tileHorizontally ? 10497 : 10496;
        int wrapT = tileVertically ? 10497 : 10496;
        RenderSystem.texParameter((int)3553, (int)10242, (int)wrapS);
        RenderSystem.texParameter((int)3553, (int)10243, (int)wrapT);
        float uStart = texOffX / texWidth;
        float vStart = texOffY / texHeight;
        float uRange = tileHorizontally ? width / texWidth : 1.0f;
        float vRange = tileVertically ? height / texHeight : 1.0f;
        float uEnd = uStart + uRange;
        float vEnd = vStart + vRange;
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        matrix.method_22903();
        matrix.method_46416(x, y, 0.0f);
        Matrix4f m = matrix.method_23760().method_23761();
        builder.method_22918(m, 0.0f, height, zOffset).method_22913(uStart, vEnd).method_22918(m, width, height, zOffset).method_22913(uEnd, vEnd).method_22918(m, width, 0.0f, zOffset).method_22913(uEnd, vStart).method_22918(m, 0.0f, 0.0f, zOffset).method_22913(uStart, vStart);
        matrix.method_22909();
        class_286.method_43433((class_9801)builder.method_60800());
    }
}

