/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.world.summoning.StoredBoundHorse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7444;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningStorage
extends class_18 {
    protected final Map<UUID, Map<class_5321<class_7444>, StoredBoundHorse>> boundHorses;
    protected final List<UUID> unboundHorses;
    protected final List<UUID> horsesToRemove;

    private SummoningStorage(Map<UUID, Map<class_5321<class_7444>, StoredBoundHorse>> boundHorses, List<UUID> unboundHorses, List<UUID> horsesToRemove) {
        this.boundHorses = boundHorses;
        this.unboundHorses = unboundHorses;
        this.horsesToRemove = horsesToRemove;
    }

    private SummoningStorage() {
        this(new HashMap<UUID, Map<class_5321<class_7444>, StoredBoundHorse>>(), new ArrayList<UUID>(), new ArrayList<UUID>());
    }

    public Map<UUID, Map<class_5321<class_7444>, StoredBoundHorse>> getBoundHorses() {
        return this.boundHorses;
    }

    public List<UUID> getUnboundHorses() {
        return this.unboundHorses;
    }

    public List<UUID> getHorsesToRemove() {
        return this.horsesToRemove;
    }

    @NotNull
    public static SummoningStorage loadOrCreate(MinecraftServer server) {
        return (SummoningStorage)server.method_30002().method_17983().method_17924(SummoningStorage.factory(), "horseman_horse_calling");
    }

    private static class_18.class_8645<SummoningStorage> factory() {
        return new class_18.class_8645(SummoningStorage::new, SummoningStorage::load, null);
    }

    private static SummoningStorage load(class_2487 tag, class_7225.class_7874 provider) {
        try {
            class_2487 boundHorsesTag = tag.method_10562("BoundHorses");
            HashMap<UUID, Map<class_5321<class_7444>, StoredBoundHorse>> boundHorses = new HashMap<UUID, Map<class_5321<class_7444>, StoredBoundHorse>>();
            for (String uuidStr : boundHorsesTag.method_10541()) {
                UUID uuid = UUID.fromString(uuidStr);
                class_2487 innerTag = boundHorsesTag.method_10562(uuidStr);
                HashMap<class_5321, StoredBoundHorse> innerMap = new HashMap<class_5321, StoredBoundHorse>();
                for (String instrumentString : innerTag.method_10541()) {
                    class_2960 location = class_2960.method_60654((String)instrumentString);
                    class_5321 instrumentKey = class_5321.method_29179((class_5321)class_7924.field_41275, (class_2960)location);
                    class_2487 horseTag = innerTag.method_10562(instrumentString);
                    @Nullable StoredBoundHorse horse = StoredBoundHorse.load(horseTag);
                    if (horse == null) continue;
                    innerMap.put(instrumentKey, horse);
                }
                boundHorses.put(uuid, innerMap);
            }
            ArrayList<UUID> unboundHorses = new ArrayList<UUID>();
            class_2499 unboundHorsesListTag = tag.method_10554("UnboundHorses", 11);
            for (class_2520 unboundUUID : unboundHorsesListTag) {
                unboundHorses.add(class_2512.method_25930((class_2520)unboundUUID));
            }
            ArrayList<UUID> horsesToRemove = new ArrayList<UUID>();
            class_2499 horsesToRemoveListTag = tag.method_10554("HorsesToRemove", 11);
            for (class_2520 toRemoveUUID : horsesToRemoveListTag) {
                horsesToRemove.add(class_2512.method_25930((class_2520)toRemoveUUID));
            }
            return new SummoningStorage(boundHorses, unboundHorses, horsesToRemove);
        }
        catch (Exception e) {
            Horseman.LOGGER.error("Failed to load HorseCallingStorage: ", (Throwable)e);
            return new SummoningStorage();
        }
    }

    @NotNull
    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        class_2487 boundHorsesTag = new class_2487();
        for (Map.Entry<UUID, Map<class_5321<class_7444>, StoredBoundHorse>> entry : this.boundHorses.entrySet()) {
            UUID uuid = entry.getKey();
            Map<class_5321<class_7444>, StoredBoundHorse> innerMap = entry.getValue();
            class_2487 innerTag = new class_2487();
            for (Map.Entry<class_5321<class_7444>, StoredBoundHorse> innerEntry : innerMap.entrySet()) {
                class_5321<class_7444> key = innerEntry.getKey();
                StoredBoundHorse horse = innerEntry.getValue();
                class_2487 horseTag = horse.save(new class_2487());
                innerTag.method_10566(key.method_29177().toString(), (class_2520)horseTag);
            }
            boundHorsesTag.method_10566(uuid.toString(), (class_2520)innerTag);
        }
        tag.method_10566("BoundHorses", (class_2520)boundHorsesTag);
        class_2499 unboundHorsesListTag = new class_2499();
        for (UUID uuid : this.unboundHorses) {
            unboundHorsesListTag.add((Object)class_2512.method_25929((UUID)uuid));
        }
        tag.method_10566("UnboundHorses", (class_2520)unboundHorsesListTag);
        class_2499 class_24992 = new class_2499();
        for (UUID uuid : this.horsesToRemove) {
            class_24992.add((Object)class_2512.method_25929((UUID)uuid));
        }
        tag.method_10566("HorsesToRemove", (class_2520)class_24992);
        return tag;
    }
}

