/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import com.google.common.base.Preconditions;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.world.HitchableHorse;
import io.github.mortuusars.horseman.world.summoning.BoundData;
import io.github.mortuusars.horseman.world.summoning.CallResult;
import io.github.mortuusars.horseman.world.summoning.StoredBoundHorse;
import io.github.mortuusars.horseman.world.summoning.SummonDimensionHandling;
import io.github.mortuusars.horseman.world.summoning.SummoningStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7444;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Summoning {
    protected final SummoningStorage storage;

    public Summoning(MinecraftServer server) {
        this.storage = SummoningStorage.loadOrCreate(server);
    }

    public SummoningStorage getStorage() {
        return this.storage;
    }

    public boolean isBound(class_1496 horse) {
        return horse.getHorsemanBoundData() != null;
    }

    @Nullable
    public StoredBoundHorse getBoundHorse(UUID owner, class_5321<class_7444> instrument) {
        return (StoredBoundHorse)this.getStorage().getBoundHorses().getOrDefault(owner, Collections.emptyMap()).get(instrument);
    }

    @Nullable
    public StoredBoundHorse getBoundHorse(class_1657 owner, class_5321<class_7444> instrument) {
        return this.getBoundHorse(owner.method_5667(), instrument);
    }

    public Map<class_5321<class_7444>, StoredBoundHorse> getStoredHorsesOf(UUID owner) {
        return this.getStorage().getBoundHorses().computeIfAbsent(owner, id -> new HashMap());
    }

    public Map<class_5321<class_7444>, StoredBoundHorse> getStoredHorsesOf(class_1657 owner) {
        return this.getStoredHorsesOf(owner.method_5667());
    }

    protected void addOrUpdateBoundHorse(class_1496 horse) {
        @Nullable BoundData data = horse.getHorsemanBoundData();
        if (data == null) {
            Horseman.LOGGER.warn("Tried to update a horse that does not have a bound data. Horse: {}", (Object)horse);
            return;
        }
        this.getStoredHorsesOf(data.owner()).put(data.instrument(), new StoredBoundHorse(horse));
        this.getStorage().method_80();
    }

    public void bind(class_3218 level, class_1496 horse, class_1657 player, class_5321<class_7444> instrument) {
        this.unbindExistingHorse(level, player, instrument);
        horse.setHorsemanBoundData(new BoundData(player, instrument));
        this.addOrUpdateBoundHorse(horse);
    }

    public void unbindHorse(class_3218 level, StoredBoundHorse boundHorse) {
        class_1496 class_14962;
        if (boundHorse.getBoundData() != null) {
            this.getStoredHorsesOf(boundHorse.getBoundData().owner()).remove(boundHorse.getBoundData().instrument());
        }
        if ((class_14962 = this.tryFindLoadedHorse(level, boundHorse.getEntityUuid())) instanceof class_1496) {
            class_1496 loadedHorse = class_14962;
            loadedHorse.setHorsemanBoundData(null);
        } else {
            this.getStorage().getUnboundHorses().add(boundHorse.getEntityUuid());
        }
        this.getStorage().method_80();
    }

    public void unbindExistingHorse(class_3218 level, class_1657 player, class_5321<class_7444> instrument) {
        @Nullable StoredBoundHorse boundHorse = this.getBoundHorse(player, instrument);
        if (boundHorse != null) {
            this.unbindHorse(level, boundHorse);
        }
    }

    public CallResult call(class_3222 player, class_5321<class_7444> instrument) {
        class_3218 level = player.method_51469();
        @Nullable StoredBoundHorse boundHorse = this.getBoundHorse((class_1657)player, instrument);
        if (boundHorse == null) {
            return CallResult.NO_BOUND_HORSE;
        }
        if (boundHorse.isDead()) {
            return CallResult.HORSE_IS_DEAD;
        }
        @Nullable class_1496 existingHorse = this.tryFindLoadedHorse(level, boundHorse.getEntityUuid());
        if (existingHorse != null) {
            if (!this.isBound(existingHorse)) {
                return CallResult.ERROR_HORSE_IS_NOT_BOUND;
            }
            this.addOrUpdateBoundHorse(existingHorse);
            boundHorse = this.getBoundHorse((class_1657)player, instrument);
            Preconditions.checkNotNull((Object)boundHorse);
        }
        if (!this.dimensionsAreValid((class_1657)player, boundHorse)) {
            return CallResult.INVALID_DIMENSION;
        }
        if (!this.isInRange((class_1657)player, boundHorse)) {
            return CallResult.TOO_FAR;
        }
        if (existingHorse != null && this.canWalkInsteadOfResummoning((class_1657)player, existingHorse)) {
            return this.walkToPlayer(player, existingHorse);
        }
        return this.summonHorse(player, boundHorse);
    }

    protected CallResult walkToPlayer(class_3222 player, class_1496 horse) {
        class_1324 followRangeAttribute;
        HitchableHorse hitchableHorse;
        if (horse instanceof HitchableHorse && HitchableHorse.isHitched(hitchableHorse = (HitchableHorse)horse)) {
            horse.method_5932(true, false);
        }
        if ((followRangeAttribute = horse.method_5996(class_5134.field_23717)) != null) {
            followRangeAttribute.method_6192(((Double)Config.Server.HORSE_SUMMONING_MAX_WALKING_DISTANCE.get()).doubleValue());
        }
        horse.method_5942().method_6335((class_1297)player, ((Double)Config.Server.HORSE_SUMMONING_WALK_MOVEMENT_SPEED.get()).doubleValue());
        this.addOrUpdateBoundHorse(horse);
        Horseman.CriteriaTriggers.HORSE_SUMMONED.get().trigger(player, horse);
        return CallResult.SUCCESS;
    }

    protected CallResult summonHorse(class_3222 player, @NotNull StoredBoundHorse boundHorse) {
        class_3218 level = player.method_51469();
        Optional type = class_1299.method_17684((class_2487)boundHorse.getTag());
        if (type.isEmpty()) {
            Horseman.LOGGER.error("Failed to get the type from a stored boundHorse data. 'id' probably wasn't saved properly. Tag '{}'.", (Object)boundHorse.getTag());
            return CallResult.ERROR_ENTITY_NOT_CREATED;
        }
        @Nullable class_1297 entity = ((class_1299)type.get()).method_5883(player.method_37908());
        if (!(entity instanceof class_1496)) {
            Horseman.LOGGER.error("Created entity isn't an AbstractHorse but {}. Something went wrong.", (Object)entity);
            return CallResult.ERROR_ENTITY_NOT_CREATED;
        }
        class_1496 newHorse = (class_1496)entity;
        newHorse.method_5651(boundHorse.getTag());
        newHorse.method_5826(UUID.randomUUID());
        newHorse.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
        if (!this.hasSpaceFor(level, (class_1657)player, newHorse)) {
            return CallResult.NO_SPACE;
        }
        player.method_37908().method_8649((class_1297)newHorse);
        this.removeOldBoundHorse(level, boundHorse);
        this.addOrUpdateBoundHorse(newHorse);
        Horseman.CriteriaTriggers.HORSE_SUMMONED.get().trigger(player, newHorse);
        return CallResult.SUCCESS;
    }

    protected boolean dimensionsAreValid(class_1657 player, StoredBoundHorse boundHorse) {
        return switch ((SummonDimensionHandling)((Object)Config.Server.HORSE_SUMMONING_DIMENSION_HANDLING.get())) {
            default -> throw new MatchException(null, null);
            case SummonDimensionHandling.ANY -> true;
            case SummonDimensionHandling.SAME -> boundHorse.isInSameDimension(player);
            case SummonDimensionHandling.WHITELIST -> {
                String playerDimension = player.method_37908().method_27983().method_29177().toString();
                yield ((List)Config.Server.HORSE_SUMMONING_DIMENSIONS.get()).stream().anyMatch(dimension -> dimension.equals(playerDimension));
            }
            case SummonDimensionHandling.BLACKLIST -> {
                String playerDimension = player.method_37908().method_27983().method_29177().toString();
                yield ((List)Config.Server.HORSE_SUMMONING_DIMENSIONS.get()).stream().noneMatch(dimension -> dimension.equals(playerDimension));
            }
        };
    }

    protected boolean isInRange(class_1657 player, StoredBoundHorse boundHorse) {
        int maxDistance = (Integer)Config.Server.HORSE_SUMMONING_MAX_DISTANCE.get();
        if (maxDistance < 0) {
            return true;
        }
        int distance = (int)boundHorse.position.method_1022(player.method_19538());
        return distance <= maxDistance;
    }

    protected boolean canWalkInsteadOfResummoning(class_1657 player, class_1496 horse) {
        return player.method_37908().method_27983().equals(horse.method_37908().method_27983()) && (double)player.method_5739((class_1297)horse) < (Double)Config.Server.HORSE_SUMMONING_MAX_WALKING_DISTANCE.get();
    }

    protected boolean hasSpaceFor(class_3218 level, class_1657 player, class_1496 horse) {
        StoredBoundHorse boundHorse = new StoredBoundHorse(horse);
        Optional type = class_1299.method_17684((class_2487)boundHorse.getTag());
        if (type.isEmpty()) {
            return false;
        }
        @Nullable class_1297 entity = ((class_1299)type.get()).method_5883(player.method_37908());
        if (!(entity instanceof class_1496)) {
            return false;
        }
        class_1496 newHorse = (class_1496)entity;
        newHorse.method_5651(boundHorse.getTag());
        newHorse.method_5826(UUID.randomUUID());
        newHorse.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
        return !newHorse.method_5757();
    }

    public boolean onHorseLoaded(class_3218 level, class_1496 horse) {
        if (!this.isBound(horse)) {
            return false;
        }
        UUID entityUUID = horse.method_5667();
        if (this.getStorage().getHorsesToRemove().contains(entityUUID)) {
            this.getStorage().getHorsesToRemove().remove(entityUUID);
            this.getStorage().getUnboundHorses().remove(entityUUID);
            horse.method_5772();
            return true;
        }
        if (this.getStorage().getUnboundHorses().contains(entityUUID)) {
            horse.setHorsemanBoundData(null);
            this.getStorage().getUnboundHorses().remove(entityUUID);
        }
        this.getStorage().method_80();
        return false;
    }

    public void onHorseUnloaded(class_3218 level, class_1496 horse) {
        if (this.isBound(horse)) {
            this.addOrUpdateBoundHorse(horse);
            if (horse.method_29504() && horse.method_5797() == null) {
                Horseman.LOGGER.info("Bound horse has died at [{}, {}, {}].", new Object[]{(int)horse.method_23317(), (int)horse.method_23318(), (int)horse.method_23321()});
            }
        }
    }

    @Nullable
    protected class_1496 tryFindLoadedHorse(class_3218 level, UUID entityUuid) {
        for (class_3218 dimension : level.method_8503().method_3738()) {
            class_1297 class_12972 = dimension.method_14190(entityUuid);
            if (!(class_12972 instanceof class_1496)) continue;
            class_1496 horse = (class_1496)class_12972;
            return horse;
        }
        return null;
    }

    protected void removeOldBoundHorse(class_3218 level, @NotNull StoredBoundHorse boundHorse) {
        boolean removed = false;
        for (class_3218 dimension : level.method_8503().method_3738()) {
            @Nullable class_1297 existingHorse = dimension.method_14190(boundHorse.getEntityUuid());
            if (existingHorse == null) continue;
            existingHorse.method_31472();
            removed = true;
            break;
        }
        if (!removed) {
            this.getStorage().getHorsesToRemove().add(boundHorse.getEntityUuid());
        }
        this.getStorage().method_80();
    }
}

