/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.scarab;

import com.github.teamfusion.rottencreatures.common.level.entities.scarab.ScarabFlyingGoal;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5534;
import org.jetbrains.annotations.Nullable;

public class Scarab
extends class_1588 {
    private static final class_2940<Boolean> DATA_IS_FLYING = class_2945.method_12791(Scarab.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_LANDING = class_2945.method_12791(Scarab.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(Scarab.class, (class_2941)class_2943.field_13327);
    private class_1409 groundNavigation;
    private class_1407 flyingNavigation;
    private int flyingTime = 0;
    private int jumpDelay = 0;
    private int landingTime = 0;
    private static final int LANDING_DURATION = 10;
    private static final int EMBELLISHED_FLIGHT_CHANCE = 15;
    private static final int DEFAULT_FLIGHT_CHANCE = 1;

    public Scarab(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new BeetleMoveControl(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23720, 0.4).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 16.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_FLYING, (Object)false);
        builder.method_56912(DATA_IS_LANDING, (Object)false);
        builder.method_56912(DATA_VARIANT, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BeetleMeleeAttackGoal(this, 1.25, false));
        this.field_6201.method_6277(2, (class_1352)new ScarabFlyingGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BeetleRandomStrollGoal(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    protected class_1408 method_5965(class_1937 level) {
        if (this.isFlying()) {
            if (this.flyingNavigation == null) {
                this.flyingNavigation = new class_1407((class_1308)this, level);
                this.flyingNavigation.method_6332(false);
                this.flyingNavigation.method_6354(true);
                this.flyingNavigation.method_6331(true);
            }
            return this.flyingNavigation;
        }
        if (this.groundNavigation == null) {
            this.groundNavigation = new class_1409((class_1308)this, level);
            this.groundNavigation.method_6363(false);
            this.groundNavigation.method_6354(true);
            this.groundNavigation.method_35139(true);
        }
        return this.groundNavigation;
    }

    public void method_5773() {
        super.method_5773();
        if (this.isLanding()) {
            ++this.landingTime;
            if (this.landingTime >= 10) {
                this.setLanding(false);
                this.landingTime = 0;
            }
        }
        if (this.isFlying() && this.method_24828() && !this.isLanding()) {
            this.setLanding(true);
            this.setFlying(false);
        }
        if (this.isFlying()) {
            int maxFlyingTime;
            ++this.flyingTime;
            int n = maxFlyingTime = this.isEmbellished() ? 400 : 200;
            if (this.flyingTime > maxFlyingTime && this.field_5974.method_43048(100) < 10 && !this.method_6510()) {
                this.setLanding(true);
                this.setFlying(false);
                this.flyingTime = 0;
            }
            if (!this.method_24828() && this.method_18798().field_1351 < 0.0) {
                this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
            }
        } else if (!this.isLanding() && this.method_24828()) {
            int flightChance;
            int n = flightChance = this.isEmbellished() ? 15 : 1;
            if (--this.jumpDelay <= 0 && !this.method_6510() && this.field_5974.method_43048(100) < flightChance) {
                this.setFlying(true);
                this.jumpDelay = this.isEmbellished() ? 100 + this.field_5974.method_43048(200) : 300 + this.field_5974.method_43048(300);
                this.method_5762(0.0, 0.4, 0.0);
            }
            if (this.method_5968() != null) {
                int combatFlightChance;
                int n2 = combatFlightChance = this.isEmbellished() ? 20 : 3;
                if (this.field_5974.method_43048(100) < combatFlightChance) {
                    this.setFlying(true);
                }
            }
        }
    }

    public boolean isLanding() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_LANDING);
    }

    public void setLanding(boolean landing) {
        this.field_6011.method_12778(DATA_IS_LANDING, (Object)landing);
    }

    public boolean isEmbellished() {
        return (Integer)this.field_6011.method_12789(DATA_VARIANT) == 1;
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(DATA_IS_FLYING, (Object)flying);
        this.field_6189 = this.method_5965(this.method_37908());
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("IsFlying", this.isFlying());
        tag.method_10556("IsLanding", this.isLanding());
        tag.method_10569("Variant", ((Integer)this.field_6011.method_12789(DATA_VARIANT)).intValue());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setFlying(tag.method_10577("IsFlying"));
        this.setLanding(tag.method_10577("IsLanding"));
        this.setVariant(tag.method_10545("Variant") ? tag.method_10550("Variant") : 0);
    }

    protected class_3414 method_5994() {
        return this.isFlying() ? class_3417.field_20605 : class_3417.field_14786;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14593;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14673;
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    static class BeetleMoveControl
    extends class_1335 {
        private final Scarab scarab;

        public BeetleMoveControl(Scarab scarab) {
            super((class_1308)scarab);
            this.scarab = scarab;
        }

        public void method_6240() {
            if (this.scarab.isLanding()) {
                super.method_6240();
                return;
            }
            if (this.scarab.isFlying()) {
                if (this.field_6374 == class_1335.class_1336.field_6378) {
                    double dz;
                    double dy;
                    this.field_6374 = class_1335.class_1336.field_6377;
                    double dx = this.field_6370 - this.scarab.method_23317();
                    double distSq = dx * dx + (dy = this.field_6369 - this.scarab.method_23318()) * dy + (dz = this.field_6367 - this.scarab.method_23321()) * dz;
                    if (distSq < 2.5E-7) {
                        this.field_6371.method_5930(0.0f);
                        return;
                    }
                    float speed = (float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23720));
                    double dist = Math.sqrt(distSq);
                    this.field_6371.method_18799(this.field_6371.method_18798().method_1031(dx / dist * 0.1 * (double)speed, dy / dist * 0.1 * (double)speed + 0.05, dz / dist * 0.1 * (double)speed));
                    this.field_6371.method_36456((float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f);
                    this.field_6371.method_5636(this.field_6371.method_36454());
                    class_243 movement = this.field_6371.method_18798();
                    double maxSpeed = (double)speed * 0.5;
                    if (movement.method_37268() > maxSpeed * maxSpeed) {
                        class_243 capped = movement.method_1029().method_1021(maxSpeed);
                        this.field_6371.method_18800(capped.field_1352, movement.field_1351, capped.field_1350);
                    }
                } else {
                    this.field_6371.method_5930(0.0f);
                    class_243 motion = this.scarab.method_18798();
                    this.scarab.method_18799(motion.method_18805(0.9, 0.9, 0.9));
                }
            } else {
                super.method_6240();
            }
        }
    }

    static class BeetleMeleeAttackGoal
    extends class_1366 {
        private final Scarab scarab;
        private int ramCooldown = 0;
        private int flyAttemptCooldown = 0;

        public BeetleMeleeAttackGoal(Scarab scarab, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((class_1314)scarab, speedModifier, followingTargetEvenIfNotSeen);
            this.scarab = scarab;
        }

        public void method_6268() {
            super.method_6268();
            if (this.scarab.method_5968() != null) {
                if (!this.scarab.isEmbellished() && !this.scarab.isFlying() && --this.ramCooldown <= 0 && this.scarab.method_5858((class_1297)this.scarab.method_5968()) < 10.0 && this.scarab.field_5974.method_43048(20) == 0) {
                    class_243 toTarget = this.scarab.method_5968().method_19538().method_1020(this.scarab.method_19538()).method_1029();
                    this.scarab.method_18799(toTarget.method_1021(0.8));
                    this.ramCooldown = 60;
                }
                if (this.scarab.isEmbellished() && !this.scarab.isFlying() && !this.scarab.isLanding() && --this.flyAttemptCooldown <= 0) {
                    if (this.scarab.field_5974.method_43048(100) < 20) {
                        this.scarab.setFlying(true);
                    }
                    this.flyAttemptCooldown = 20;
                }
            }
        }
    }

    static class BeetleRandomStrollGoal
    extends class_1394 {
        protected final Scarab scarab;

        public BeetleRandomStrollGoal(Scarab scarab, double speedModifier) {
            super((class_1314)scarab, speedModifier);
            this.scarab = scarab;
        }

        @Nullable
        protected class_243 method_6302() {
            if (this.scarab.isFlying()) {
                class_243 forward = this.field_6566.method_5828(0.0f);
                class_243 upward = new class_243(0.0, 1.0, 0.0);
                class_243 right = forward.method_1036(upward).method_1029();
                forward = forward.method_1021(this.field_6566.method_59922().method_43058() * 8.0);
                upward = upward.method_1021(this.field_6566.method_59922().method_43058() * 2.0 - 1.0);
                right = right.method_1021(this.field_6566.method_59922().method_43058() * 4.0 - 2.0);
                class_243 target = this.field_6566.method_19538().method_1019(forward).method_1019(upward).method_1019(right);
                int minY = this.field_6566.method_37908().method_31607() + 5;
                if (target.field_1351 < (double)minY) {
                    target = new class_243(target.field_1352, (double)minY, target.field_1350);
                }
                return target;
            }
            if (this.field_6566.method_5816()) {
                class_243 vec3 = class_5534.method_31527((class_1314)this.field_6566, (int)15, (int)7);
                return vec3 == null ? super.method_6302() : vec3;
            }
            return this.field_6566.method_59922().method_43057() >= this.field_6626 ? class_5534.method_31527((class_1314)this.field_6566, (int)10, (int)7) : super.method_6302();
        }

        public boolean method_6264() {
            class_243 vec3;
            if (!this.field_6565) {
                if (this.field_6566.method_6131() >= 100) {
                    return false;
                }
                if (this.field_6566.method_59922().method_43048(BeetleRandomStrollGoal.method_38848((int)this.field_6564)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.method_6302()) == null) {
                return false;
            }
            this.field_6563 = vec3.field_1352;
            this.field_6562 = vec3.field_1351;
            this.field_6561 = vec3.field_1350;
            this.field_6565 = false;
            return true;
        }

        public boolean method_6266() {
            if (this.scarab.isFlying()) {
                return this.field_6566.method_5942().method_23966() && this.field_6566.method_5649(this.field_6563, this.field_6562, this.field_6561) > 2.0;
            }
            return super.method_6266();
        }
    }
}

