/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.network;

import com.aetherteam.nitrogen.Nitrogen;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2802;
import net.minecraft.class_310;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_8042;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PacketDistributor {
    private static boolean isClient = false;

    public static void flagAsClient() {
        isClient = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_8710 payload, class_8710 ... payloads) {
        class_634 listener = Objects.requireNonNull(class_310.method_1551().method_1562());
        listener.method_52787(ClientPlayNetworking.createC2SPacket((class_8710)payload));
        for (class_8710 otherPayload : payloads) {
            listener.method_52787(ClientPlayNetworking.createC2SPacket((class_8710)otherPayload));
        }
    }

    public static void sendToPlayer(class_3222 player, class_8710 payload, class_8710 ... payloads) {
        player.field_13987.method_14364(PacketDistributor.makeClientboundPacket(payload, payloads));
    }

    public static void sendToPlayersInDimension(class_3218 level, class_8710 payload, class_8710 ... payloads) {
        level.method_8503().method_3760().method_14589(PacketDistributor.makeClientboundPacket(payload, payloads), level.method_27983());
    }

    public static void sendToPlayersNear(class_3218 level, @Nullable class_3222 excluded, double x, double y, double z, double radius, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = PacketDistributor.makeClientboundPacket(payload, payloads);
        level.method_8503().method_3760().method_14605((class_1657)excluded, x, y, z, radius, level.method_27983(), packet);
    }

    public static void sendToAllPlayers(class_8710 payload, class_8710 ... payloads) {
        MinecraftServer server = Objects.requireNonNull(Nitrogen.SERVER_INSTANCE, "Cannot send clientbound payloads on the client");
        server.method_3760().method_14581(PacketDistributor.makeClientboundPacket(payload, payloads));
    }

    public static void sendToPlayersTrackingEntity(class_1297 entity, class_8710 payload, class_8710 ... payloads) {
        class_2802 class_28022 = entity.method_37908().method_8398();
        if (!(class_28022 instanceof class_3215)) {
            throw new IllegalStateException("Cannot send clientbound payloads on the client");
        }
        class_3215 chunkCache = (class_3215)class_28022;
        chunkCache.method_18754(entity, PacketDistributor.makeClientboundPacket(payload, payloads));
    }

    public static void sendToPlayersTrackingEntityAndSelf(class_1297 entity, class_8710 payload, class_8710 ... payloads) {
        class_2802 class_28022 = entity.method_37908().method_8398();
        if (!(class_28022 instanceof class_3215)) {
            throw new IllegalStateException("Cannot send clientbound payloads on the client");
        }
        class_3215 chunkCache = (class_3215)class_28022;
        chunkCache.method_18751(entity, PacketDistributor.makeClientboundPacket(payload, payloads));
    }

    public static void sendToPlayersTrackingChunk(class_3218 level, class_1923 chunkPos, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = PacketDistributor.makeClientboundPacket(payload, payloads);
        for (class_3222 player : level.method_14178().field_17254.method_17210(chunkPos, false)) {
            player.field_13987.method_14364(packet);
        }
    }

    private static class_2596<?> makeClientboundPacket(class_8710 payload, class_8710 ... payloads) {
        if (payloads.length > 0) {
            ArrayList<class_2658> packets = new ArrayList<class_2658>();
            packets.add(new class_2658(payload));
            for (class_8710 otherPayload : payloads) {
                packets.add(new class_2658(otherPayload));
            }
            return new class_8042(packets);
        }
        return new class_2658(payload);
    }
}

