/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.events;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeModifierHelper {
    private final class_9285 defaultModifiers;
    private ItemAttributeModifiersBuilder builder;
    public static final Event<Callback> ON_MODIFICATION = EventFactory.createArrayBacked(Callback.class, invokers -> (stack, event) -> {
        for (Callback invoker : invokers) {
            invoker.onAttributes(stack, event);
        }
    });

    @ApiStatus.Internal
    protected ItemAttributeModifierHelper(class_9285 defaultModifiers) {
        this.defaultModifiers = defaultModifiers;
    }

    public static ItemAttributeModifierHelper invokeEvent(class_1799 stack, class_9285 defaultModifiers) {
        ItemAttributeModifierHelper helper = new ItemAttributeModifierHelper(defaultModifiers);
        ((Callback)ON_MODIFICATION.invoker()).onAttributes(stack, helper);
        return helper;
    }

    public class_9285 getDefaultModifiers() {
        return this.defaultModifiers;
    }

    public List<class_9285.class_9287> getModifiers() {
        return this.builder == null ? this.defaultModifiers.comp_2393() : this.builder.getEntryView();
    }

    public boolean addModifier(class_6880<class_1320> attribute, class_1322 modifier, class_9274 slot) {
        return this.getBuilder().addModifier(attribute, modifier, slot);
    }

    public boolean removeModifier(class_6880<class_1320> attribute, class_2960 id) {
        return this.getBuilder().removeModifier(attribute, id);
    }

    public void replaceModifier(class_6880<class_1320> attribute, class_1322 modifier, class_9274 slot) {
        this.getBuilder().replaceModifier(attribute, modifier, slot);
    }

    public boolean removeIf(Predicate<class_9285.class_9287> condition) {
        return this.getBuilder().removeIf(condition);
    }

    public boolean removeAllModifiersFor(class_6880<class_1320> attribute) {
        return this.getBuilder().removeIf(entry -> entry.comp_2395().equals((Object)attribute));
    }

    public void clearModifiers() {
        this.getBuilder().clear();
    }

    public class_9285 build() {
        return this.builder == null ? this.defaultModifiers : this.builder.build(this.defaultModifiers.comp_2394());
    }

    private ItemAttributeModifiersBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new ItemAttributeModifiersBuilder(this.defaultModifiers);
        }
        return this.builder;
    }

    public static interface Callback {
        public void onAttributes(class_1799 var1, ItemAttributeModifierHelper var2);
    }

    private static class ItemAttributeModifiersBuilder {
        private List<class_9285.class_9287> entries = new LinkedList<class_9285.class_9287>();
        private Map<Key, class_9285.class_9287> entriesByKey;

        ItemAttributeModifiersBuilder(class_9285 defaultModifiers) {
            this.entriesByKey = new HashMap<Key, class_9285.class_9287>(defaultModifiers.comp_2393().size());
            for (class_9285.class_9287 entry : defaultModifiers.comp_2393()) {
                this.entries.add(entry);
                this.entriesByKey.put(new Key((class_6880<class_1320>)entry.comp_2395(), entry.comp_2396().comp_2447()), entry);
            }
        }

        List<class_9285.class_9287> getEntryView() {
            return Collections.unmodifiableList(this.entries);
        }

        boolean addModifier(class_6880<class_1320> attribute, class_1322 modifier, class_9274 slot) {
            Key key = new Key(attribute, modifier.comp_2447());
            if (this.entriesByKey.containsKey(key)) {
                return false;
            }
            class_9285.class_9287 entry = new class_9285.class_9287(attribute, modifier, slot);
            this.entries.add(entry);
            this.entriesByKey.put(key, entry);
            return true;
        }

        boolean removeModifier(class_6880<class_1320> attribute, class_2960 id) {
            class_9285.class_9287 entry = this.entriesByKey.remove(new Key(attribute, id));
            if (entry == null) {
                return false;
            }
            this.entries.remove(entry);
            return true;
        }

        @Nullable
        class_9285.class_9287 replaceModifier(class_6880<class_1320> attribute, class_1322 modifier, class_9274 slot) {
            Key key = new Key(attribute, modifier.comp_2447());
            class_9285.class_9287 entry = new class_9285.class_9287(attribute, modifier, slot);
            if (!this.entriesByKey.containsKey(key)) {
                this.entries.add(entry);
                this.entriesByKey.put(key, entry);
                return null;
            }
            class_9285.class_9287 previousEntry = this.entriesByKey.get(key);
            int index = this.entries.indexOf(previousEntry);
            if (index != -1) {
                this.entries.set(index, entry);
            } else {
                this.entries.add(entry);
            }
            this.entriesByKey.put(key, entry);
            return previousEntry;
        }

        boolean removeIf(Predicate<class_9285.class_9287> condition) {
            this.entries.removeIf(condition);
            return this.entriesByKey.values().removeIf(condition);
        }

        void clear() {
            this.entries.clear();
            this.entriesByKey.clear();
        }

        public class_9285 build(boolean showInTooltip) {
            return new class_9285((List)ImmutableList.copyOf(this.entries), showInTooltip);
        }

        private record Key(class_6880<class_1320> attr, class_2960 id) {
        }
    }
}

