/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric;

import com.aetherteam.aether.mixin.mixins.common.accessor.ConnectionAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerCommonPacketListenerImplAccessor;
import com.aetherteam.aetherfabric.network.payload.AdvancedAddEntityPayload;
import com.aetherteam.aetherfabric.network.payload.KnownRegistryDataMapsPayload;
import com.aetherteam.aetherfabric.network.payload.KnownRegistryDataMapsReplyPayload;
import com.aetherteam.aetherfabric.network.payload.RegistryDataMapSyncPayload;
import com.aetherteam.aetherfabric.network.tasks.RegistryDataMapNegotiation;
import com.aetherteam.aetherfabric.registries.DataMapLoader;
import com.aetherteam.aetherfabric.registries.RegistryManager;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapType;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapsUpdatedEvent;
import com.aetherteam.aetherfabric.registries.datamaps.RegisterDataMapTypesEvent;
import com.aetherteam.aetherfabric.registries.datamaps.builtin.Compostable;
import com.aetherteam.aetherfabric.registries.datamaps.builtin.FurnaceFuel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3962;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8605;

public class AetherFabric {
    public static final DataMapType<class_1792, Compostable> COMPOSTABLES = DataMapType.builder(class_2960.method_60655((String)"neoforge", (String)"compostables"), class_7924.field_41197, Compostable.CODEC).synced(Compostable.CHANCE_CODEC, false).build();
    public static final DataMapType<class_1792, FurnaceFuel> FURNACE_FUELS = DataMapType.builder(class_2960.method_60655((String)"neoforge", (String)"furnace_fuels"), class_7924.field_41197, FurnaceFuel.CODEC).synced(FurnaceFuel.BURN_TIME_CODEC, false).build();

    public static void init() {
        PayloadTypeRegistry.configurationS2C().register(KnownRegistryDataMapsPayload.TYPE, KnownRegistryDataMapsPayload.STREAM_CODEC);
        PayloadTypeRegistry.configurationC2S().register(KnownRegistryDataMapsReplyPayload.TYPE, KnownRegistryDataMapsReplyPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(RegistryDataMapSyncPayload.TYPE, RegistryDataMapSyncPayload.STREAM_CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> handler.addTask((class_8605)new RegistryDataMapNegotiation(handler)));
        ServerConfigurationNetworking.registerGlobalReceiver(KnownRegistryDataMapsReplyPayload.TYPE, RegistryManager::handleKnownDataMapsReply);
        RegisterDataMapTypesEvent.EVENT.register(event -> {
            event.register(COMPOSTABLES);
            event.register(FURNACE_FUELS);
        });
        RegistryManager.initDataMaps();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(DataMapLoader.ID, DataMapLoader::new);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> RegistryManager.getDataMaps().forEach((registry, values) -> {
            Optional regOpt = player.method_5682().method_30002().method_30349().method_33310(registry);
            if (regOpt.isEmpty()) {
                return;
            }
            if (!ServerPlayNetworking.canSend((class_3222)player, RegistryDataMapSyncPayload.TYPE)) {
                return;
            }
            class_2535 connection = ((ServerCommonPacketListenerImplAccessor)player.field_13987).aetherFabric$connection();
            if (connection.method_10756()) {
                return;
            }
            Map playerMaps = (Map)((ConnectionAccessor)connection).aetherFabric$getChannel().attr(RegistryManager.ATTRIBUTE_KNOWN_DATA_MAPS).get();
            if (playerMaps == null) {
                return;
            }
            RegistryManager.handleSync(player, (class_2378)regOpt.get(), playerMaps.getOrDefault(registry, List.of()));
        }));
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                return;
            }
            DataMapLoader.apply(registries);
        });
        PayloadTypeRegistry.playS2C().register(AdvancedAddEntityPayload.TYPE, AdvancedAddEntityPayload.STREAM_CODEC);
        DataMapsUpdatedEvent.EVENT.register((Object)new FurnaceFuelCallback());
        DataMapsUpdatedEvent.EVENT.register((Object)new CompostableFuelCallback());
    }

    public static class FurnaceFuelCallback
    implements DataMapsUpdatedEvent.CallBack {
        private final Set<class_5321<class_1792>> addedEntries = new HashSet<class_5321<class_1792>>();

        @Override
        public void onUpdate(DataMapsUpdatedEvent event) {
            this.addedEntries.forEach(addedEntry -> FuelRegistry.INSTANCE.clear((class_1935)class_7923.field_41178.method_29107(addedEntry)));
            event.ifRegistry(class_7924.field_41197, registry -> registry.aetherFabric$getDataMap(FURNACE_FUELS).forEach((itemResourceKey, furnaceFuel) -> {
                this.addedEntries.add((class_5321<class_1792>)itemResourceKey);
                FuelRegistry.INSTANCE.add((class_1935)registry.method_29107(itemResourceKey), (Object)furnaceFuel.burnTime());
            }));
        }
    }

    public static class CompostableFuelCallback
    implements DataMapsUpdatedEvent.CallBack {
        private final Set<class_5321<class_1792>> addedEntries = new HashSet<class_5321<class_1792>>();

        @Override
        public void onUpdate(DataMapsUpdatedEvent event) {
            this.addedEntries.forEach(addedEntry -> class_3962.field_17566.removeFloat(class_7923.field_41178.method_29107(addedEntry)));
            event.ifRegistry(class_7924.field_41197, registry -> registry.aetherFabric$getDataMap(COMPOSTABLES).forEach((itemResourceKey, furnaceFuel) -> {
                this.addedEntries.add((class_5321<class_1792>)itemResourceKey);
                class_3962.field_17566.put((Object)((class_1935)registry.method_29107(itemResourceKey)), furnaceFuel.chance());
            }));
        }
    }
}

